/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSUtil;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.FormSubmitData;
import ice.pilots.html4.FormTypeElement;
import ice.storm.DynEnv;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.html.HTMLTextAreaElement;

public class DTextAreaElement
extends FormTypeElement
implements HTMLTextAreaElement {
    private String defaultValue;
    public static final int DEFAULT_ROWS_COUNT = 3;
    public static final int DEFAULT_COLS_COUNT = 20;
    private static final int Field_accessKey = 1;
    private static final int Field_cols = 2;
    private static final int Field_defaultValue = 3;
    private static final int Field_disabled = 4;
    private static final int Field_form = 5;
    private static final int Field_readOnly = 7;
    private static final int Field_rows = 8;
    private static final int Field_tabIndex = 9;
    private static final int Field_type = 10;
    private static final int Field_value = 11;
    private static final int Method_blur = -1;
    private static final int Method_focus = -2;
    private static final int Method_select = -3;

    protected DTextAreaElement(DDocument dDocument, int n) {
        super(dDocument, n);
    }

    public String getDefaultValue() {
        if (this.defaultValue == null) {
            this.recordDefaultValue();
        }
        return this.defaultValue;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public String getAccessKey() {
        return this.getAttribute(4);
    }

    public void setAccessKey(String string) {
        this.setAttribute(4, string);
    }

    public boolean getDisabled() {
        return this.getAttribute(38) != null;
    }

    public void setDisabled(boolean bl) {
        this.setAttribute(38, bl ? "disabled" : null);
    }

    public boolean getReadOnly() {
        return this.getAttribute(89) != null;
    }

    public void setReadOnly(boolean bl) {
        this.setAttribute(89, bl ? "readonly" : null);
    }

    public int getTabIndex() {
        return -1;
    }

    public void setTabIndex(int n) {
    }

    public String getType() {
        return "textarea";
    }

    public String getValue() {
        if (this.defaultValue == null) {
            this.recordDefaultValue();
        }
        return this.getAttribute(114);
    }

    private String script_getValue() {
        String string = this.getValue();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public void setValue(String string) {
        this.setAttribute(114, string);
    }

    public void dispatchSelection(int n, int n2) {
        DOMEvent dOMEvent = this.doc.createDOMEvent(17);
        dOMEvent.target = this;
        this.doc.processEvent(dOMEvent);
    }

    public int getCols() {
        int n = 20;
        String string = this.getAttribute(28);
        if (string != null) {
            n = CSSUtil.parseInt(string, n);
        }
        return n;
    }

    public void setCols(int n) {
        this.setAttribute(28, Integer.toString(n));
    }

    public int getRows() {
        int n = 3;
        String string = this.getAttribute(92);
        if (string != null) {
            n = CSSUtil.parseInt(string, n);
        }
        return n;
    }

    public void setRows(int n) {
        this.setAttribute(92, Integer.toString(n));
    }

    public void blur() {
        this.doc.getDomView().processBlurCall(this);
    }

    public void focus() {
        this.doc.getDomView().processFocusCall(this);
    }

    public void select() {
        this.doc.getDomView().processSelectCall(this);
    }

    void recordData(FormSubmitData formSubmitData, Object object) {
        if (!this.getDisabled()) {
            formSubmitData.appendData(this.getNameForServer(), this.fixValue(this.getValue()));
        }
    }

    void reset() {
        this.setValue(this.getDefaultValue());
    }

    private void recordDefaultValue() {
        Node node = this.getFirstChild();
        if (node != null && node instanceof Text) {
            String string = ((Text)node).getData();
            this.setDefaultValue(string);
            this.setValue(string);
        } else {
            this.setDefaultValue("");
            this.setValue("");
        }
    }

    public void dispatchChange() {
        DOMEvent dOMEvent = this.doc.createDOMEvent(18);
        dOMEvent.target = this;
        this.doc.processEvent(dOMEvent);
    }

    public Object getDynamicValue(String string, DynEnv dynEnv) {
        int n = DTextAreaElement.toDynamicId(string);
        if (n < 0) {
            return dynEnv.wrapMethod(this, string);
        }
        if (n > 0) {
            return this.getDynamicValue(n, dynEnv);
        }
        return super.getDynamicValue(string, dynEnv);
    }

    public int setDynamicValue(String string, Object object, DynEnv dynEnv) {
        int n = DTextAreaElement.toDynamicId(string);
        if (n < 0) {
            return 2;
        }
        if (n > 0) {
            return this.setDynamicValue(n, object, dynEnv);
        }
        return super.setDynamicValue(string, object, dynEnv);
    }

    public Object execDynamicMethod(String string, Object[] objectArray, DynEnv dynEnv) {
        int n = DTextAreaElement.toDynamicId(string);
        if (n < 0) {
            return this.execDynamicMethod(n, objectArray, dynEnv);
        }
        return super.execDynamicMethod(string, objectArray, dynEnv);
    }

    private Object getDynamicValue(int n, DynEnv dynEnv) {
        switch (n) {
            case 1: {
                return this.getAccessKey();
            }
            case 2: {
                return dynEnv.wrapInt(this.getCols());
            }
            case 3: {
                return this.getDefaultValue();
            }
            case 4: {
                return dynEnv.wrapBoolean(this.getDisabled());
            }
            case 5: {
                return this.getDForm();
            }
            case 7: {
                return dynEnv.wrapBoolean(this.getReadOnly());
            }
            case 8: {
                return dynEnv.wrapInt(this.getRows());
            }
            case 9: {
                return dynEnv.wrapInt(this.getTabIndex());
            }
            case 10: {
                return this.getType();
            }
            case 11: {
                return this.script_getValue();
            }
        }
        return null;
    }

    private int setDynamicValue(int n, Object object, DynEnv dynEnv) {
        switch (n) {
            case 1: {
                this.setAccessKey(dynEnv.toStr(object));
                return 1;
            }
            case 2: {
                this.setCols(dynEnv.toInt(object));
                return 1;
            }
            case 3: {
                this.setDefaultValue(dynEnv.toStr(object));
                return 1;
            }
            case 4: {
                this.setDisabled(dynEnv.toBoolean(object));
                return 1;
            }
            case 5: {
                return 2;
            }
            case 7: {
                this.setReadOnly(dynEnv.toBoolean(object));
                return 1;
            }
            case 8: {
                this.setRows(dynEnv.toInt(object));
                return 1;
            }
            case 9: {
                this.setTabIndex(dynEnv.toInt(object));
                return 1;
            }
            case 11: {
                this.setValue(dynEnv.toStr(object));
                return 1;
            }
        }
        return 2;
    }

    private Object execDynamicMethod(int n, Object[] objectArray, DynEnv dynEnv) {
        switch (n) {
            case -1: {
                this.blur();
                break;
            }
            case -2: {
                this.focus();
                break;
            }
            case -3: {
                this.select();
            }
        }
        return dynEnv.wrapVoid();
    }

    private static int toDynamicId(String string) {
        int n = 0;
        String string2 = null;
        block0 : switch (string.length()) {
            case 4: {
                switch (string.charAt(0)) {
                    case 'b': {
                        string2 = "blur";
                        n = -1;
                        break block0;
                    }
                    case 'c': {
                        string2 = "cols";
                        n = 2;
                        break block0;
                    }
                    case 'f': {
                        string2 = "form";
                        n = 5;
                        break block0;
                    }
                    case 'r': {
                        string2 = "rows";
                        n = 8;
                        break block0;
                    }
                    case 't': {
                        string2 = "type";
                        n = 10;
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                char c = string.charAt(0);
                if (c == 'f') {
                    string2 = "focus";
                    n = -2;
                    break;
                }
                if (c != 'v') break;
                string2 = "value";
                n = 11;
                break;
            }
            case 6: {
                string2 = "select";
                n = -3;
                break;
            }
            case 8: {
                char c = string.charAt(0);
                if (c == 'd') {
                    string2 = "disabled";
                    n = 4;
                    break;
                }
                if (c == 'r') {
                    string2 = "readOnly";
                    n = 7;
                    break;
                }
                if (c != 't') break;
                string2 = "tabIndex";
                n = 9;
                break;
            }
            case 9: {
                string2 = "accessKey";
                n = 1;
                break;
            }
            case 12: {
                string2 = "defaultValue";
                n = 3;
                break;
            }
        }
        if (string2 != null && (string2 == string || string2.equals(string))) {
            return n;
        }
        return 0;
    }
}

