/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import ice.storm.Viewport;
import ice.util.Defs;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class DOMEvent
extends DynamicObject
implements Event {
    private static final boolean ENABLE_FROM_TO_ELEM_SUPPORT = true;
    public static final int CLICK = 1;
    public static final int DBLCLICK = 2;
    public static final int MOUSEDOWN = 3;
    public static final int MOUSEUP = 4;
    public static final int MOUSEOVER = 5;
    public static final int MOUSEMOVE = 6;
    public static final int MOUSEOUT = 7;
    public static final int KEYPRESS = 8;
    public static final int KEYDOWN = 9;
    public static final int KEYUP = 10;
    public static final int RESIZE = 11;
    public static final int SCROLL = 12;
    public static final int LOAD = 13;
    public static final int UNLOAD = 14;
    public static final int ABORT = 15;
    public static final int ERROR = 16;
    public static final int SELECT = 17;
    public static final int CHANGE = 18;
    public static final int SUBMIT = 19;
    public static final int RESET = 20;
    public static final int FOCUS = 21;
    public static final int BLUR = 22;
    public static final int HELP = 23;
    public static final int CONTEXTMENU = 24;
    public static final int DOMSubtreeModified = 25;
    public static final int DOMNodeInserted = 26;
    public static final int DOMNodeRemoved = 27;
    public static final int DOMAttrModified = 28;
    public static final int CSSModified = 29;
    public static final int GOTO = 30;
    public static final int NUM_EVENTS = 31;
    protected DDocument doc;
    int typeId;
    long timestamp;
    DNode target;
    DNode currentNode;
    DNode nodeAfterMap;
    short eventPhase;
    boolean cancel = false;
    private boolean canceledDefault;
    protected DNode defaultActionTarget;
    int posX;
    int posY;
    DNode relatedNode;
    private EventListener _eventAction;
    private boolean _defaultDone;
    private Object _systemEvent;
    private static final int Field_bubbles = 1;
    private static final int Field_cancelable = 2;
    private static final int Field_cancelBubble = 3;
    private static final int Field_currentNode = 4;
    private static final int Field_currentTarget = 5;
    private static final int Field_eventPhase = 6;
    private static final int Field_fromElement = 7;
    private static final int Field_srcElement = 8;
    private static final int Field_target = 9;
    private static final int Field_timeStamp = 10;
    private static final int Field_toElement = 11;
    private static final int Field_type = 12;
    private static final int Method_initEvent = -1;
    private static final int Method_isDefaultCancelled = -2;
    private static final int Method_preventDefault = -3;
    private static final int Method_stopPropagation = -4;

    static int mapEventTypeToId(String string) {
        int n = 0;
        String string2 = null;
        block0 : switch (string.length()) {
            case 4: {
                char c = string.charAt(0);
                if (c == 'b') {
                    string2 = "blur";
                    n = 22;
                    break;
                }
                if (c == 'h') {
                    string2 = "help";
                    n = 23;
                    break;
                }
                if (c == 'l') {
                    string2 = "load";
                    n = 13;
                    break;
                }
                if (c != 'g') break;
                string2 = "goto";
                n = 30;
                break;
            }
            case 5: {
                switch (string.charAt(0)) {
                    case 'a': {
                        string2 = "abort";
                        n = 15;
                        break block0;
                    }
                    case 'c': {
                        string2 = "click";
                        n = 1;
                        break block0;
                    }
                    case 'e': {
                        string2 = "error";
                        n = 16;
                        break block0;
                    }
                    case 'f': {
                        string2 = "focus";
                        n = 21;
                        break block0;
                    }
                    case 'k': {
                        string2 = "keyup";
                        n = 10;
                        break block0;
                    }
                    case 'r': {
                        string2 = "reset";
                        n = 20;
                        break block0;
                    }
                }
                break;
            }
            case 6: {
                switch (string.charAt(4)) {
                    case 'a': {
                        string2 = "unload";
                        n = 14;
                        break block0;
                    }
                    case 'c': {
                        string2 = "select";
                        n = 17;
                        break block0;
                    }
                    case 'g': {
                        string2 = "change";
                        n = 18;
                        break block0;
                    }
                    case 'i': {
                        string2 = "submit";
                        n = 19;
                        break block0;
                    }
                    case 'l': {
                        string2 = "scroll";
                        n = 12;
                        break block0;
                    }
                    case 'z': {
                        string2 = "resize";
                        n = 11;
                        break block0;
                    }
                }
                break;
            }
            case 7: {
                char c = string.charAt(0);
                if (c == 'k') {
                    string2 = "keydown";
                    n = 9;
                    break;
                }
                if (c != 'm') break;
                string2 = "mouseup";
                n = 4;
                break;
            }
            case 8: {
                char c = string.charAt(0);
                if (c == 'd') {
                    string2 = "dblclick";
                    n = 2;
                    break;
                }
                if (c == 'k') {
                    string2 = "keypress";
                    n = 8;
                    break;
                }
                if (c != 'm') break;
                string2 = "mouseout";
                n = 7;
                break;
            }
            case 9: {
                char c = string.charAt(5);
                if (c == 'd') {
                    string2 = "mousedown";
                    n = 3;
                    break;
                }
                if (c == 'm') {
                    string2 = "mousemove";
                    n = 6;
                    break;
                }
                if (c != 'o') break;
                string2 = "mouseover";
                n = 5;
                break;
            }
            case 11: {
                char c = string.charAt(0);
                if (c == 'C') {
                    string2 = "CSSModified";
                    n = 29;
                    break;
                }
                if (c != 'c') break;
                string2 = "contextmenu";
                n = 24;
                break;
            }
            case 14: {
                string2 = "DOMNodeRemoved";
                n = 27;
                break;
            }
            case 15: {
                char c = string.charAt(3);
                if (c == 'A') {
                    string2 = "DOMAttrModified";
                    n = 28;
                    break;
                }
                if (c != 'N') break;
                string2 = "DOMNodeInserted";
                n = 26;
                break;
            }
            case 18: {
                string2 = "DOMSubtreeModified";
                n = 25;
                break;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        if (n == 0) {
            n = -1;
        }
        return n;
    }

    static String mapEventIdToType(int n) {
        switch (n) {
            case 1: {
                return "click";
            }
            case 2: {
                return "dblclick";
            }
            case 3: {
                return "mousedown";
            }
            case 4: {
                return "mouseup";
            }
            case 5: {
                return "mouseover";
            }
            case 6: {
                return "mousemove";
            }
            case 7: {
                return "mouseout";
            }
            case 8: {
                return "keypress";
            }
            case 9: {
                return "keydown";
            }
            case 10: {
                return "keyup";
            }
            case 11: {
                return "resize";
            }
            case 12: {
                return "scroll";
            }
            case 13: {
                return "load";
            }
            case 14: {
                return "unload";
            }
            case 15: {
                return "abort";
            }
            case 16: {
                return "error";
            }
            case 17: {
                return "select";
            }
            case 18: {
                return "change";
            }
            case 19: {
                return "submit";
            }
            case 20: {
                return "reset";
            }
            case 21: {
                return "focus";
            }
            case 22: {
                return "blur";
            }
            case 23: {
                return "help";
            }
            case 24: {
                return "contextmenu";
            }
            case 25: {
                return "DOMSubtreeModified";
            }
            case 26: {
                return "DOMNodeInserted";
            }
            case 27: {
                return "DOMNodeRemoved";
            }
            case 28: {
                return "DOMAttrModified";
            }
            case 29: {
                return "CSSModified";
            }
            case 30: {
                return "goto";
            }
        }
        return null;
    }

    static String internType(String string) {
        return DOMEvent.mapEventIdToType(DOMEvent.mapEventTypeToId(string));
    }

    static boolean canBubbleEvent(int n) {
        switch (n) {
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
            case 6: {
                return true;
            }
            case 7: {
                return true;
            }
            case 8: {
                return true;
            }
            case 9: {
                return true;
            }
            case 10: {
                return true;
            }
            case 11: {
                return true;
            }
            case 12: {
                return true;
            }
            case 13: {
                return false;
            }
            case 14: {
                return false;
            }
            case 15: {
                return true;
            }
            case 16: {
                return true;
            }
            case 17: {
                return true;
            }
            case 18: {
                return true;
            }
            case 19: {
                return true;
            }
            case 20: {
                return true;
            }
            case 21: {
                return false;
            }
            case 22: {
                return false;
            }
            case 23: {
                return false;
            }
            case 24: {
                return false;
            }
            case 30: {
                return false;
            }
        }
        return false;
    }

    static boolean canCancelEvent(int n) {
        switch (n) {
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
            case 6: {
                return false;
            }
            case 7: {
                return true;
            }
            case 8: {
                return true;
            }
            case 9: {
                return true;
            }
            case 10: {
                return true;
            }
            case 11: {
                return false;
            }
            case 12: {
                return false;
            }
            case 13: {
                return false;
            }
            case 14: {
                return false;
            }
            case 15: {
                return false;
            }
            case 16: {
                return false;
            }
            case 17: {
                return false;
            }
            case 18: {
                return false;
            }
            case 19: {
                return true;
            }
            case 20: {
                return false;
            }
            case 21: {
                return false;
            }
            case 22: {
                return false;
            }
            case 23: {
                return true;
            }
            case 24: {
                return true;
            }
            case 30: {
                return false;
            }
        }
        return false;
    }

    protected DOMEvent(DDocument dDocument, int n) {
        this.doc = dDocument;
        this.typeId = n;
        this.timestamp = System.currentTimeMillis();
    }

    public final DDocument getDDocument() {
        return this.doc;
    }

    public final Viewport getViewport() {
        return this.doc.pilot.getPilotViewport();
    }

    protected void copyUIDataFrom(DOMEvent dOMEvent) {
        this.target = dOMEvent.target;
        this.currentNode = dOMEvent.currentNode;
        this.nodeAfterMap = dOMEvent.nodeAfterMap;
        this.defaultActionTarget = dOMEvent.defaultActionTarget;
        this.posX = dOMEvent.posX;
        this.posY = dOMEvent.posY;
        this.relatedNode = dOMEvent.relatedNode;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public String getType() {
        return DOMEvent.mapEventIdToType(this.typeId);
    }

    public EventTarget getTarget() {
        return this.target;
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    public EventTarget getCurrentTarget() {
        return this.currentNode;
    }

    public short getEventPhase() {
        return this.eventPhase;
    }

    public boolean getBubbles() {
        return DOMEvent.canBubbleEvent(this.typeId);
    }

    public boolean getCancelable() {
        return DOMEvent.canCancelEvent(this.typeId);
    }

    public void stopPropagation() {
        this.cancel = true;
    }

    public void preventDefault() {
        if (!this.canceledDefault && this.getCancelable()) {
            this.canceledDefault = true;
        }
    }

    public void initEvent(String string, boolean bl, boolean bl2) {
    }

    void setTarget(DNode dNode) {
        this.target = dNode;
    }

    void setCurrentNode(Node node) {
        this.currentNode = (DNode)node;
    }

    void setEventPhase(short s) {
        this.eventPhase = s;
    }

    public boolean isDefaultCancelled() {
        return this.canceledDefault;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public String toString() {
        return "[event " + this.getType() + "]";
    }

    private DNode getSrcElement() {
        DNode dNode;
        for (dNode = this.target; dNode != null && !(dNode instanceof DElement); dNode = dNode.getParentDNode()) {
        }
        return dNode;
    }

    private DNode getToElement() {
        DNode dNode = this.target;
        if (this.typeId == 7) {
            dNode = this.relatedNode;
        }
        return dNode;
    }

    private DNode getFromElement() {
        DNode dNode = this.target;
        if (this.typeId == 5) {
            dNode = this.relatedNode;
        }
        return dNode;
    }

    private void setCancelBubble(boolean bl) {
        this.cancel = bl;
    }

    private boolean getCancelBubble() {
        return this.cancel;
    }

    EventListener getAction() {
        return this._eventAction;
    }

    void setAction(EventListener eventListener) {
        if (eventListener == null) {
            Defs.badArg();
        }
        if (this._eventAction != null) {
            Defs.badArg();
        }
        this._eventAction = eventListener;
    }

    public boolean isDefaultDone() {
        return this._defaultDone;
    }

    public void setDefaultDone() {
        this._defaultDone = true;
    }

    public Object getSystemEvent() {
        return this._systemEvent;
    }

    public void setSystemEvent(Object object) {
        if (object == null) {
            Defs.badArg();
        }
        if (this._systemEvent != null) {
            Defs.badArg();
        }
        this._systemEvent = object;
    }

    public Object getDynamicValue(String string, DynEnv dynEnv) {
        int n = DOMEvent.toDynamicId(string);
        if (n < 0) {
            return dynEnv.wrapMethod(this, string);
        }
        if (n > 0) {
            return this.getDynamicValue(n, dynEnv);
        }
        return super.getDynamicValue(string, dynEnv);
    }

    public int setDynamicValue(String string, Object object, DynEnv dynEnv) {
        int n = DOMEvent.toDynamicId(string);
        if (n < 0) {
            return 2;
        }
        if (n > 0) {
            return this.setDynamicValue(n, object, dynEnv);
        }
        return super.setDynamicValue(string, object, dynEnv);
    }

    public Object execDynamicMethod(String string, Object[] objectArray, DynEnv dynEnv) {
        int n = DOMEvent.toDynamicId(string);
        if (n < 0) {
            return this.execDynamicMethod(n, objectArray, dynEnv);
        }
        return super.execDynamicMethod(string, objectArray, dynEnv);
    }

    private Object getDynamicValue(int n, DynEnv dynEnv) {
        switch (n) {
            case 1: {
                return dynEnv.wrapBoolean(this.getBubbles());
            }
            case 2: {
                return dynEnv.wrapBoolean(this.getCancelable());
            }
            case 3: {
                return dynEnv.wrapBoolean(this.getCancelBubble());
            }
            case 4: {
                return this.getCurrentNode();
            }
            case 5: {
                return this.getCurrentTarget();
            }
            case 6: {
                return dynEnv.wrapInt(this.getEventPhase());
            }
            case 7: {
                return this.getFromElement();
            }
            case 8: {
                return this.getSrcElement();
            }
            case 9: {
                return this.getTarget();
            }
            case 10: {
                return dynEnv.wrapLong(this.getTimeStamp());
            }
            case 11: {
                return this.getToElement();
            }
            case 12: {
                return this.getType();
            }
        }
        return null;
    }

    private int setDynamicValue(int n, Object object, DynEnv dynEnv) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 1;
            }
            case 3: {
                this.setCancelBubble(dynEnv.toBoolean(object));
                return 1;
            }
            case 6: {
                this.setEventPhase(dynEnv.toShort(object));
                return 1;
            }
            case 7: {
                return 1;
            }
            case 8: {
                return 1;
            }
            case 9: {
                this.setTarget((DNode)dynEnv.toNative(object));
                return 1;
            }
            case 10: {
                return 1;
            }
            case 11: {
                return 1;
            }
            case 12: {
                return 1;
            }
        }
        return 2;
    }

    private Object execDynamicMethod(int n, Object[] objectArray, DynEnv dynEnv) {
        switch (n) {
            case -1: {
                String string = dynEnv.toStr(objectArray, 0);
                boolean bl = dynEnv.toBoolean(objectArray, 1);
                boolean bl2 = dynEnv.toBoolean(objectArray, 2);
                this.initEvent(string, bl, bl2);
                break;
            }
            case -2: {
                return dynEnv.wrapBoolean(this.isDefaultCancelled());
            }
            case -3: {
                this.preventDefault();
                break;
            }
            case -4: {
                this.stopPropagation();
            }
        }
        return dynEnv.wrapVoid();
    }

    private static int toDynamicId(String string) {
        int n = 0;
        String string2 = null;
        switch (string.length()) {
            case 4: {
                string2 = "type";
                n = 12;
                break;
            }
            case 6: {
                string2 = "target";
                n = 9;
                break;
            }
            case 7: {
                string2 = "bubbles";
                n = 1;
                break;
            }
            case 9: {
                char c = string.charAt(1);
                if (c == 'i') {
                    string2 = "timeStamp";
                    n = 10;
                    break;
                }
                if (c == 'n') {
                    string2 = "initEvent";
                    n = -1;
                    break;
                }
                if (c != 'o') break;
                string2 = "toElement";
                n = 11;
                break;
            }
            case 10: {
                char c = string.charAt(0);
                if (c == 'c') {
                    string2 = "cancelable";
                    n = 2;
                    break;
                }
                if (c == 'e') {
                    string2 = "eventPhase";
                    n = 6;
                    break;
                }
                if (c != 's') break;
                string2 = "srcElement";
                n = 8;
                break;
            }
            case 11: {
                char c = string.charAt(0);
                if (c == 'c') {
                    string2 = "currentNode";
                    n = 4;
                    break;
                }
                if (c != 'f') break;
                string2 = "fromElement";
                n = 7;
                break;
            }
            case 12: {
                string2 = "cancelBubble";
                n = 3;
                break;
            }
            case 13: {
                string2 = "currentTarget";
                n = 5;
                break;
            }
            case 14: {
                string2 = "preventDefault";
                n = -3;
                break;
            }
            case 15: {
                string2 = "stopPropagation";
                n = -4;
                break;
            }
            case 18: {
                string2 = "isDefaultCancelled";
                n = -2;
                break;
            }
        }
        if (string2 != null && (string2 == string || string2.equals(string))) {
            return n;
        }
        return 0;
    }
}

