/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.dombase.LexBase;
import ice.pilots.html4.CSSBuilder;
import ice.pilots.html4.DAppletElement;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DFormElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DStyleSheet;
import ice.pilots.html4.DTextAreaElement;
import ice.pilots.html4.DTextNode;
import ice.pilots.html4.DXmlElement;
import ice.pilots.html4.HtmlDOMFixer;
import ice.pilots.html4.Lex2;
import ice.pilots.html4.LexCallback;
import ice.pilots.html4.Names;
import ice.pilots.html4.ProgressDetail;
import ice.pilots.html4.StormData;
import ice.pilots.html4.ThePilot;
import ice.storm.StormBase;
import ice.util.Defs;
import ice.util.alg.CharKit;
import ice.util.encoding.CharIO;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Stack;
import java.util.Vector;

public final class DOMBuilder
implements LexCallback {
    private boolean titleEventFired;
    private DDocument doc;
    private ThePilot pilot;
    private DNode startNode;
    private DNode curNode = null;
    private HtmlDOMFixer fixer;
    private boolean encodingChanged = false;
    private String totalLengthString = null;
    private boolean spaceAdded = false;
    private boolean isPre = false;
    private boolean preJustStarted = false;
    private boolean isTextArea = false;
    private String xmlBody;
    private String scriptBody = null;
    private String scriptLanguage = null;
    private int[] attrIds = new int[50];
    private String[] attrNames = new String[50];
    private String[] attrValues = new String[50];
    private int numAttrs = 0;
    private boolean isXmlnsPending = false;
    private Stack prefixDefs = new Stack();
    private Stack nsDefs = new Stack();
    private int defaultNamespace = 0;
    private DFormElement curHackForm;
    private Vector eventScripts = new Vector();
    private int iframeNesting;
    boolean noJS = false;
    private int cdataStartLine;
    boolean loadSingleOnly = false;
    private char[] textBuffer = new char[2048];
    private int textBufferPos = 0;

    public static void setLoadSingleOnly(StormBase stormBase) {
        StormData stormData = StormData.get(stormBase);
        stormData.setLoadSingleOnly(true);
    }

    public DOMBuilder(DDocument dDocument, ThePilot thePilot) {
        this(dDocument, dDocument, thePilot);
    }

    public DOMBuilder(DDocument dDocument, DNode dNode, ThePilot thePilot) {
        this.doc = dDocument;
        this.startNode = dNode;
        this.pilot = thePilot;
        if (thePilot != null) {
            StormData stormData = StormData.get(thePilot.getStorm());
            this.loadSingleOnly = stormData.getLoadSingleOnly();
        }
    }

    public boolean isStopRequested() {
        if (this.pilot == null) {
            return false;
        }
        return this.pilot.isStopRequested();
    }

    public void progress(int n, ProgressDetail progressDetail) {
        if (this.startNode != this.doc) {
            return;
        }
        if (this.pilot == null) {
            return;
        }
        String string = this.pilot.getPilotViewport().getLocation();
        if (string == null) {
            return;
        }
        if (this.totalLengthString == null) {
            this.totalLengthString = this.pilot.getPageInfo("content-length");
            if (this.totalLengthString == null) {
                this.totalLengthString = "-1";
            }
        }
        this.pilot.firePropertyChange("contentLoadingProgress", progressDetail, string + " " + n + " " + this.totalLengthString);
    }

    public void startDocument() {
        this.fixer = new HtmlDOMFixer(this.doc);
        this.numAttrs = 0;
        this.titleEventFired = false;
        this.curNode = this.startNode;
        this.defaultNamespace = this.doc.defaultNamespace;
    }

    public void endDocument() {
        if (this.textBufferPos > 0) {
            this.addTextNode();
        }
        this.curNode = null;
        this.curHackForm = null;
        this.fixer.moveIsIndexElements();
        this.fixer = null;
        this.prefixDefs.removeAllElements();
        this.nsDefs.removeAllElements();
        for (int i = 0; i < this.eventScripts.size(); i += 3) {
            String string = (String)this.eventScripts.elementAt(i);
            String string2 = (String)this.eventScripts.elementAt(i + 1);
            String string3 = (String)this.eventScripts.elementAt(i + 2);
            DNode dNode = null;
            dNode = string.equals("document") || string.equals("window") ? this.doc.getDBody() : (DNode)((Object)this.doc.getElementById(string));
            if (dNode == null) continue;
            int n = this.doc.names.getAttrId(3, string2);
            dNode.setDAttr(n, string3, false);
        }
        this.eventScripts.removeAllElements();
        if (this.pilot != null) {
            this.pilot.moveToBodyTmpBodyEventHandlers();
        }
        this.doc.applyXSLT();
    }

    public void documentCharset(String string) {
        this.doc.setDefaultCharset(string);
        this.encodingChanged = true;
    }

    public void cdataBody(char[] cArray, int n, int n2) {
        this.appendChars(cArray, n, n2);
    }

    public void textCharacters(char[] cArray, int n, int n2) {
        if (this.isPre) {
            this.appendPreText(cArray, n, n2);
        } else {
            this.appendDefaultText(cArray, n, n2);
        }
    }

    public void startElement(LexBase lexBase, char[] cArray, int n, int n2, int n3, boolean bl) {
        int n4;
        Object object;
        int n5;
        int n6;
        String string;
        int n7;
        if (this.textBufferPos > 0) {
            this.addTextNode();
        }
        if (cArray[n] == '!') {
            this.numAttrs = 0;
            return;
        }
        if (cArray[n] == '?') {
            String string2 = new String(cArray, n + 1, n2 - 1);
            if (string2.equalsIgnoreCase("xml-stylesheet")) {
                String string3 = null;
                String string4 = null;
                String string5 = null;
                for (int i = 0; i < this.numAttrs; ++i) {
                    if (this.attrNames[i].equals("href")) {
                        string3 = this.attrValues[i];
                        continue;
                    }
                    if (this.attrNames[i].equals("type")) {
                        string4 = this.attrValues[i];
                        continue;
                    }
                    if (!this.attrNames[i].equals("media")) continue;
                    string5 = this.attrValues[i];
                }
                if (string3 != null) {
                    this.doc.linkStyleSheet(string3, string4, string5, null, this.doc);
                }
            }
            this.numAttrs = 0;
            return;
        }
        if (this.isXmlnsPending) {
            for (n7 = 0; n7 < this.numAttrs; ++n7) {
                string = this.attrNames[n7];
                if (!CharKit.startsWithIgnoreAsciiCase((String)string, (String)"xmlns")) continue;
                String string6 = this.attrValues[n7];
                n6 = "".equals(string6) || "null".equals(string6) ? (this.doc.defaultNamespace == 3 ? 3 : 5) : this.doc.names.getNamespace(string6);
                n5 = string.indexOf(58);
                if (n5 < 0) {
                    this.defaultNamespace = n6;
                    object = new NSEntry(null, n6, null);
                    this.nsDefs.push(object);
                    continue;
                }
                object = string.substring(n5 + 1);
                NSEntry nSEntry = new NSEntry(null, n6, (String)object);
                this.prefixDefs.push(nSEntry);
            }
        }
        n7 = this.defaultNamespace;
        if (n3 > 0) {
            string = new String(cArray, n, n3 - 1);
            int n8 = this.getNamespaceFromPrefix(string);
            if (n8 >= 0) {
                n7 = n8;
            } else {
                this.isXmlnsPending = false;
                this.numAttrs = 0;
                return;
            }
        }
        if (n2 >= 8 && CharKit.startsWith((char[])cArray, (int)n, (int)(n + n2), (String)"itemtb")) {
            CharKit.asciiToUpperCase((char[])cArray, (int)n, (int)(n + n2));
            n7 = 5;
        }
        if ((n4 = this.doc.names.getTagId(n7, cArray, n + n3, n2 - n3)) < 0) {
            this.isXmlnsPending = false;
            this.numAttrs = 0;
            return;
        }
        if (n4 == 14) {
            this.spaceAdded = true;
        }
        if (n4 == 32 && this.curHackForm != null) {
            this.isXmlnsPending = false;
            this.numAttrs = 0;
            return;
        }
        DElement dElement = this.doc.createElement(n4);
        if (n3 > 0) {
            dElement.qname = new String(cArray, n, n2);
        }
        if (this.numAttrs > this.attrIds.length) {
            this.attrIds = new int[this.attrNames.length];
        }
        if (this.isXmlnsPending) {
            this.isXmlnsPending = false;
            for (n6 = this.nsDefs.size() - 1; n6 >= 0; --n6) {
                NSEntry nSEntry = (NSEntry)this.nsDefs.elementAt(n6);
                if (nSEntry.node != null) break;
                nSEntry.node = dElement;
            }
            for (n6 = this.prefixDefs.size() - 1; n6 >= 0; --n6) {
                NSEntry nSEntry = (NSEntry)this.prefixDefs.elementAt(n6);
                if (nSEntry.node != null) break;
                nSEntry.node = dElement;
            }
            Names names = this.doc.names;
            for (n5 = 0; n5 < this.numAttrs; ++n5) {
                object = this.attrNames[n5];
                int n9 = ((String)object).indexOf(58);
                if (n9 < 0) {
                    this.attrIds[n5] = names.getAttrId(n7, (String)object);
                    continue;
                }
                int n10 = 0;
                String string7 = ((String)object).substring(0, n9);
                int n11 = this.getNamespaceFromPrefix(string7);
                if (n11 >= 0) {
                    n10 = n11;
                }
                this.attrIds[n5] = names.getAttrId(n10, (String)object);
            }
        } else {
            for (n6 = 0; n6 < this.numAttrs; ++n6) {
                this.attrIds[n6] = this.doc.names.getAttrId(n7, this.attrNames[n6]);
            }
        }
        dElement.setAttributes(this.attrIds, this.attrValues, this.numAttrs);
        this.numAttrs = 0;
        this.curNode = this.fixer.addChildNode(this.curNode, dElement);
        if (bl && this.curNode != null && this.curNode.getNameId() == n4) {
            this.curNode = this.curNode.getParentDNode();
        }
        if (this.curNode != dElement) {
            this.closeNamespaces(dElement, this.curNode);
        }
        switch (n4) {
            case 94: {
                if (bl) {
                    this.loadIfGivenExternalXML((DXmlElement)dElement);
                    break;
                }
                lexBase.reqEmbeddedXml();
                break;
            }
            case 76: {
                lexBase.reqCdata();
                break;
            }
            case 70: {
                if (!this.shouldIgnoreScripts()) {
                    this.scriptLanguage = DOMBuilder.extractScriptLanguage(dElement);
                    boolean bl2 = this.scriptLanguage != null && this.scriptLanguage.equalsIgnoreCase("vbscript");
                    this.fixer.setAllowNoScript(bl2);
                    if (bl) {
                        this.loadIfGivenExternalScript(dElement);
                    }
                }
                if (bl) break;
                this.cdataStartLine = lexBase.lineNumber;
                lexBase.reqScriptCdata();
                break;
            }
            case 54: {
                this.doc.handleLinkTag(dElement);
                break;
            }
            case 57: {
                String string8 = dElement.getAttribute("charset");
                if (string8 != null && !this.encodingChanged) {
                    this.encodingChanged = true;
                    if (this.applyEncodingChange(string8, (Lex2)lexBase)) {
                        return;
                    }
                }
                String string9 = dElement.getAttribute(49);
                object = dElement.getAttribute(31);
                if (string9 == null || object == null) break;
                if (string9.equalsIgnoreCase("content-type")) {
                    int n12 = ((String)object).toLowerCase().indexOf("charset");
                    if (n12 <= 0 || this.encodingChanged) break;
                    this.encodingChanged = true;
                    if ((n12 = ((String)object).indexOf(61, n12)) <= 0 || !this.applyEncodingChange((String)(object = ((String)object).substring(n12 + 1).trim()), (Lex2)lexBase)) break;
                    return;
                }
                if (!string9.equalsIgnoreCase("set-cookie")) break;
                this.doc.setCookie((String)object);
                break;
            }
            case 66: {
                this.isPre = true;
                this.preJustStarted = true;
                break;
            }
            case 34: {
                this.doc.isFrameset = true;
                break;
            }
            case 8: {
                String string10 = dElement.getAttribute(46);
                String string11 = dElement.getAttribute(108);
                if (string10 != null) {
                    this.doc.setBaseUrl(this.doc.resolveUrl(string10));
                }
                if (string11 == null) break;
                this.doc.setBaseTarget(string11);
                break;
            }
            case 13: {
                this.doc.validateBodyAttrs();
                break;
            }
            case 32: {
                this.curHackForm = (DFormElement)dElement;
                break;
            }
            case 15: 
            case 47: {
                if (this.curHackForm == null) break;
                this.curHackForm.addHackElement(dElement);
                if (this.curHackForm.getParentNode() != null || dElement.getParentNode() == null) break;
                dElement.getParentNode().insertBefore(this.curHackForm, dElement);
                break;
            }
            case 82: {
                lexBase.reqTextareaCdata();
                this.isTextArea = true;
                if (this.curHackForm == null) break;
                this.curHackForm.addHackElement(dElement);
                if (this.curHackForm.getParentNode() != null || dElement.getParentNode() == null) break;
                dElement.getParentNode().insertBefore(this.curHackForm, dElement);
                break;
            }
            case 71: {
                if (this.curHackForm == null) break;
                this.curHackForm.addHackElement(dElement);
                if (this.curHackForm.getParentNode() != null || dElement.getParentNode() == null) break;
                dElement.getParentNode().insertBefore(this.curHackForm, dElement);
                break;
            }
            case 45: {
                if (cArray[n] == 'e' || cArray[n] == 'E') {
                    if (this.curNode != dElement) break;
                    this.curNode = dElement.getParentDNode();
                    break;
                }
                if (bl) break;
                ++this.iframeNesting;
                break;
            }
            case 46: {
                this.spaceAdded = false;
            }
        }
    }

    private boolean applyEncodingChange(String string, Lex2 lex2) {
        if (lex2.applyEncodingChange(string)) {
            this.doc.clear();
            this.doc.setUnresolvedCharset(string);
            this.doc.setDefaultCharset(string);
            this.startDocument();
            return true;
        }
        return false;
    }

    public void elementAttribute(char[] cArray, int n, int n2, int n3, int n4, int n5) {
        String[] stringArray;
        String string;
        if (n3 > 0) {
            this.isXmlnsPending = true;
        } else if (CharKit.startsWithIgnoreAsciiCase((char[])cArray, (int)n, (int)(n + n2), (String)"xml")) {
            this.isXmlnsPending = true;
        }
        String string2 = new String(cArray, n, n2);
        if (n != n4) {
            string = new String(cArray, n4, n5);
        } else if (this.defaultNamespace == 3 && n3 == 0) {
            if (string2.equalsIgnoreCase("value")) {
                return;
            }
            string = string2;
        } else {
            string = "";
        }
        switch (this.doc.names.getAttrId(3, string2)) {
            case 5: 
            case 9: 
            case 11: 
            case 20: 
            case 22: 
            case 25: 
            case 33: 
            case 46: 
            case 56: 
            case 87: 
            case 102: 
            case 112: {
                String string3 = null;
                try {
                    stringArray = this.doc.getDefaultCharset();
                    string3 = Defs.property((String)"ice.pilots.html4.defaultUrlEncoding", (String)CharIO.getDefaultEncoding());
                    string = new String(stringArray != null ? string.getBytes((String)stringArray) : string.getBytes(), string3);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Debug.trace((String)("Unsupported encoding: " + string3 + "\r\n    " + "Revert to system's default encoding: " + CharIO.getDefaultEncoding()));
                    try {
                        string = new String(string.getBytes(this.doc.getDefaultCharset()), CharIO.getDefaultEncoding());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException2) {
                        Debug.ex((Throwable)unsupportedEncodingException2);
                    }
                }
                break;
            }
        }
        int n6 = this.attrNames.length;
        if (this.numAttrs == n6) {
            stringArray = new String[n6 * 2];
            System.arraycopy(this.attrNames, 0, stringArray, 0, n6);
            this.attrNames = stringArray;
            stringArray = new String[n6 * 2];
            System.arraycopy(this.attrValues, 0, stringArray, 0, n6);
            this.attrValues = stringArray;
        }
        this.attrNames[this.numAttrs] = string2;
        this.attrValues[this.numAttrs] = string;
        ++this.numAttrs;
    }

    public void endElement(LexBase lexBase, char[] cArray, int n, int n2, int n3) {
        Object object;
        DNode dNode;
        int n4;
        if (this.textBufferPos > 0) {
            this.addTextNode();
        }
        int n5 = this.defaultNamespace;
        if (n3 > 0) {
            String string = new String(cArray, n, n3 - 1);
            int n6 = this.getNamespaceFromPrefix(string);
            if (n6 >= 0) {
                n5 = n6;
            } else {
                return;
            }
        }
        if ((n4 = this.doc.names.getTagId(n5, cArray, n + n3, n2 - n3)) == 86 && this.fixer.parentOfIllegalTitleNode != null) {
            this.fixer.parentOfIllegalTitleNode = null;
            return;
        }
        if (n4 < 0) {
            return;
        }
        String string = null;
        DElement dElement = null;
        DElement dElement2 = null;
        switch (n4) {
            case 87: {
                if (this.curNode.getNameId() != 87) break;
                this.fixer.onClosingTR(this.curNode);
                break;
            }
            case 81: {
                this.fixer.closeLastBreakNode();
                break;
            }
            case 79: {
                if (!this.fixer.hasHackTable()) break;
                this.curNode = this.fixer.closeHackTable(false);
                break;
            }
            case 66: {
                this.isPre = false;
                break;
            }
            case 82: {
                this.isTextArea = false;
                break;
            }
            case 86: {
                if (this.pilot == null || this.titleEventFired) break;
                this.pilot.firePropertyChange("title", null, this.doc.getTitle());
                this.titleEventFired = true;
                break;
            }
            case 70: {
                if (!this.shouldIgnoreScripts() && this.curNode != null && this.curNode.tagId == 70) {
                    dElement = (DElement)this.curNode;
                    string = this.scriptBody;
                }
                this.scriptBody = null;
                break;
            }
            case 94: {
                if (this.curNode != null && this.curNode.tagId == 94 && !this.loadIfGivenExternalXML((DXmlElement)(dNode = (DXmlElement)this.curNode)) && this.xmlBody != null && (object = this.doc.getDom().parseEmbeddedDocumentFromString(this.xmlBody)) != null) {
                    ((DXmlElement)dNode).setGeneratedDocument((DDocument)object);
                }
                this.xmlBody = null;
                break;
            }
            case 32: {
                this.curHackForm = null;
                break;
            }
            case 5: {
                if (this.curNode == null || !(this.curNode instanceof DAppletElement)) break;
                dNode = (DAppletElement)this.curNode;
                ((DAppletElement)dNode).setLoaded();
                this.doc.mutate();
                break;
            }
            case 43: {
                if (this.doc.defaultNamespace != 3) break;
                return;
            }
            case 45: {
                dElement2 = (DElement)this.curNode;
            }
        }
        dNode = this.checkClosing(true, n4);
        if (dNode == null) {
            this.checkClosing(false, n4);
        }
        if (dElement != null && this.pilot != null && !this.loadIfGivenExternalScript(dElement) && string != null && !this.checkScriptEventHandler(dElement, (String)(object = DOMBuilder.cleanupScript(string)))) {
            String string2 = this.doc.getBaseUrl();
            this.pilot.doScriptEval(this.scriptLanguage, (String)object, string2, this.cdataStartLine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadIfGivenExternalXML(DXmlElement dXmlElement) {
        Object var2_2 = null;
        String string = dXmlElement.getAttribute(102);
        if (string == null) {
            string = dXmlElement.getAttribute(90);
        }
        if (string != null) {
            String string2 = this.doc.resolveUrl(string);
            if (string2 != null) {
                DDocument dDocument;
                block11: {
                    dDocument = null;
                    if (this.loadSingleOnly) {
                        return true;
                    }
                    if (Debug.trace) {
                        Debug.trace((String)("External XML: url=" + string2));
                    }
                    try {
                        Reader reader = this.doc.openUrlReader(string2);
                        try {
                            dDocument = this.doc.getDom().parseEmbeddedDocumentFromReader(reader);
                        }
                        finally {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!Debug.ex) break block11;
                        Debug.ex((Throwable)iOException);
                    }
                }
                if (dDocument != null) {
                    dXmlElement.setGeneratedDocument(dDocument);
                }
            }
            return true;
        }
        return false;
    }

    private boolean loadIfGivenExternalScript(DElement dElement) {
        String string = dElement.getAttribute(102);
        if (string != null) {
            if (this.loadSingleOnly) {
                return true;
            }
            String string2 = this.doc.resolveUrl(string);
            if (string2 != null) {
                String string3;
                if (Debug.trace) {
                    Debug.trace((String)("External script: url=" + string2));
                }
                if ((string3 = this.loadDataOrNull(string2)) != null && this.pilot != null && !this.checkScriptEventHandler(dElement, string3)) {
                    this.pilot.doScriptEval(this.scriptLanguage, string3, string2.toString(), 0);
                }
            }
            return true;
        }
        return false;
    }

    static String extractScriptLanguage(DElement dElement) {
        String string = dElement.getAttribute(54);
        if (string == null || string.length() == 0 || string.equals("language") || string.equals("liveScript")) {
            string = "ECMAScript";
        }
        return string;
    }

    static String cleanupScript(String string) {
        String string2 = string.trim();
        if (string2.endsWith("-->")) {
            string = string2.substring(0, string2.length() - 3);
        }
        return string;
    }

    private boolean checkScriptEventHandler(DElement dElement, String string) {
        String string2 = dElement.getAttribute(120);
        String string3 = dElement.getAttribute(41);
        if (string3 != null && string2 != null) {
            this.eventScripts.addElement(string3);
            this.eventScripts.addElement(string2);
            this.eventScripts.addElement(string);
            return true;
        }
        return false;
    }

    DNode checkClosing(boolean bl, int n) {
        DNode dNode;
        for (dNode = this.curNode; dNode != null; dNode = dNode.getParentDNode()) {
            if (!(dNode instanceof DElement)) continue;
            DElement dElement = (DElement)dNode;
            if (bl && dElement.getSynthetic()) continue;
            if (dElement.tagId == n || this.fixer.tagsAreSynonymous(dElement, n)) {
                DNode dNode2 = this.curNode;
                this.curNode = dElement.getParentDNode();
                this.closeNamespaces(dNode2, this.curNode);
                if (n != 45 || this.iframeNesting == 0) break;
                --this.iframeNesting;
                break;
            }
            if (this.fixer.canCloseNodeWith(dNode, n)) continue;
            dNode = null;
            break;
        }
        return dNode;
    }

    String removeBufferedChars() {
        String string = new String(this.textBuffer, 0, this.textBufferPos);
        this.textBufferPos = 0;
        return string;
    }

    private final void addTextNode() {
        DTextNode dTextNode = this.doc.createDTextNode(this.textBuffer, 0, this.textBufferPos, this.isPre || this.isTextArea);
        this.curNode = this.fixer.addChildNode(this.curNode, dTextNode);
        if (this.isTextArea && this.curNode instanceof DTextAreaElement) {
            ((DTextAreaElement)this.curNode).getValue();
        }
        this.textBufferPos = 0;
        if (this.curNode instanceof DElement) {
            DElement dElement = (DElement)this.curNode;
            if (dElement.tagId == 76) {
                try {
                    DStyleSheet dStyleSheet = this.doc.getDom().createDStyleSheet(this.doc.defaultNamespace, dElement, null, null);
                    CSSBuilder cSSBuilder = new CSSBuilder(this.doc);
                    cSSBuilder.build(dStyleSheet, new CharArrayReader(dTextNode.text), this.doc.getBaseUrl());
                    this.doc.addStyleSheet(dStyleSheet);
                }
                catch (IOException iOException) {
                    if (Debug.ex) {
                        Debug.ex((Throwable)iOException);
                    }
                }
            } else if (dElement.tagId == 70) {
                if (!this.shouldIgnoreScripts()) {
                    this.scriptBody = dTextNode.getNodeValue();
                }
            } else if (dElement.tagId == 94) {
                this.xmlBody = dTextNode.getNodeValue();
            }
        }
    }

    private void ensureTextBufferAppend(int n) {
        int n2 = this.textBufferPos + n;
        int n3 = this.textBuffer.length;
        if (n2 > n3) {
            if (n2 > (n3 *= 2)) {
                n3 = n2;
            }
            char[] cArray = new char[n3];
            if (this.textBufferPos != 0) {
                System.arraycopy(this.textBuffer, 0, cArray, 0, this.textBufferPos);
            }
            this.textBuffer = cArray;
        }
    }

    private void appendChars(char[] cArray, int n, int n2) {
        this.ensureTextBufferAppend(n2);
        System.arraycopy(cArray, n, this.textBuffer, this.textBufferPos, n2);
        this.textBufferPos += n2;
    }

    private void appendPreText(char[] cArray, int n, int n2) {
        this.ensureTextBufferAppend(n2);
        int n3 = n;
        int n4 = this.textBufferPos;
        while (n3 < n + n2) {
            int n5 = cArray[n3];
            if (n5 == 12) {
                n5 = 10;
            } else if (n5 == 10) {
                if (n3 < n + n2 - 1 && cArray[n3 + 1] == '\r') {
                    ++n3;
                }
            } else if (n5 == 13) {
                if (n3 < n + n2 - 1 && cArray[n3 + 1] == '\n') {
                    ++n3;
                }
                n5 = 10;
            } else if (n5 == 9) {
                n5 = 32;
            }
            ++n3;
            if (!this.preJustStarted || n4 != this.textBufferPos || n5 != 10) {
                this.textBuffer[n4++] = n5;
            }
            this.preJustStarted = false;
        }
        this.textBufferPos = n4;
    }

    private void appendDefaultText(char[] cArray, int n, int n2) {
        int n3;
        this.ensureTextBufferAppend(n2);
        char[] cArray2 = this.textBuffer;
        int n4 = 0;
        int n5 = this.textBufferPos;
        int n6 = n + n2;
        for (n3 = n; n3 != n6 && DOMBuilder.isWhiteSpace(n4 = cArray[n3]); ++n3) {
        }
        if (n3 != n && !this.spaceAdded) {
            if (this.fixer.isFirstWhitespaceAllowed(this.curNode)) {
                cArray2[n5++] = 32;
            }
            this.spaceAdded = true;
        }
        if (n3 != n6) {
            cArray2[n5++] = n4;
            ++n3;
            boolean bl = true;
            while (n3 != n6) {
                n4 = cArray[n3];
                if (bl) {
                    if (DOMBuilder.isWhiteSpace(n4)) {
                        bl = false;
                        n4 = 32;
                    }
                    cArray2[n5++] = n4;
                } else if (!DOMBuilder.isWhiteSpace(n4)) {
                    cArray2[n5++] = n4;
                    bl = true;
                }
                ++n3;
            }
            this.spaceAdded = !bl;
        }
        this.textBufferPos = n5;
    }

    private static boolean isWhiteSpace(int n) {
        return n == 32 || n == 9 || n == 10 || n == 13 || n == 12 || n == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadDataOrNull(String string) {
        String string2;
        Reader reader = this.doc.openUrlReader(string);
        try {
            int n;
            int n2 = 0;
            char[] cArray = new char[2048];
            while ((n = reader.read(cArray, n2, cArray.length - n2)) >= 0) {
                if ((n2 += n) != cArray.length) continue;
                char[] cArray2 = new char[n2 * 2];
                System.arraycopy(cArray, 0, cArray2, 0, n2);
                cArray = cArray2;
            }
            string2 = new String(cArray, 0, n2);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                if (Debug.ex) {
                    Debug.ex((Throwable)iOException);
                }
                return null;
            }
        }
        reader.close();
        return string2;
    }

    private final void closeNamespaces(DNode dNode, DNode dNode2) {
        NSEntry nSEntry;
        while (dNode != null && dNode != dNode2) {
            while (!this.prefixDefs.empty()) {
                nSEntry = (NSEntry)this.prefixDefs.peek();
                if (nSEntry.node != dNode) break;
                this.prefixDefs.pop();
            }
            while (!this.nsDefs.empty()) {
                nSEntry = (NSEntry)this.nsDefs.peek();
                if (nSEntry.node != dNode) break;
                this.nsDefs.pop();
            }
            dNode = dNode.getParentDNode();
        }
        if (this.nsDefs.empty()) {
            this.defaultNamespace = this.doc.defaultNamespace;
        } else {
            nSEntry = (NSEntry)this.nsDefs.peek();
            this.defaultNamespace = nSEntry.nsId;
        }
    }

    private final int getNamespaceFromPrefix(String string) {
        if ("xmlns".equals(string)) {
            return 2;
        }
        for (int i = this.prefixDefs.size() - 1; i >= 0; --i) {
            NSEntry nSEntry = (NSEntry)this.prefixDefs.elementAt(i);
            if (!nSEntry.prefix.equals(string)) continue;
            return nSEntry.nsId;
        }
        return -1;
    }

    boolean shouldIgnoreScripts() {
        int n;
        if (this.noJS) {
            return true;
        }
        boolean bl = false;
        if (this.curNode != null && ((n = this.curNode.tagId) == 58 || n == 59 || this.iframeNesting != 0)) {
            bl = true;
        }
        return bl;
    }

    static class NSEntry {
        DNode node;
        int nsId;
        String prefix;

        NSEntry(DNode dNode, int n, String string) {
            this.node = dNode;
            this.nsId = n;
            this.prefix = string;
        }
    }
}

