/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import java.util.Vector;

class CSSCounters {
    private int num = 0;
    private int maxNum = 8;
    private int[] values = new int[this.maxNum];
    private String[] names = new String[this.maxNum];

    CSSCounters() {
    }

    void clear() {
        this.num = 0;
    }

    void resetCounters(Vector vector) {
        for (int i = 0; i < vector.size(); i += 2) {
            String string = (String)vector.elementAt(i);
            Integer n = (Integer)vector.elementAt(i + 1);
            if (this.num == this.maxNum) {
                this.grow();
            }
            this.names[this.num] = string;
            this.values[this.num] = n;
            ++this.num;
        }
    }

    void removeCounters(Vector vector) {
        this.num -= vector.size() >> 1;
    }

    void incCounters(Vector vector) {
        for (int i = 0; i < vector.size(); i += 2) {
            String string = (String)vector.elementAt(i);
            Integer n = (Integer)vector.elementAt(i + 1);
            for (int j = this.num - 1; j >= 0; --j) {
                if (!this.names[j].equals(string)) continue;
                int n2 = j;
                this.values[n2] = this.values[n2] + n;
                return;
            }
            if (this.num == this.maxNum) {
                this.grow();
            }
            System.arraycopy(this.names, 0, this.names, 1, this.num);
            System.arraycopy(this.values, 0, this.values, 1, this.num);
            ++this.num;
            this.names[0] = string;
            this.values[0] = n;
        }
    }

    void updateCounters(Vector vector) {
        for (int i = 0; i < vector.size(); i += 2) {
            String string = (String)vector.elementAt(i);
            Integer n = (Integer)vector.elementAt(i + 1);
            for (int j = this.num - 1; j >= 0; --j) {
                if (!this.names[j].equals(string)) continue;
                this.values[j] = n;
                return;
            }
            if (this.num == this.maxNum) {
                this.grow();
            }
            System.arraycopy(this.names, 0, this.names, 1, this.num);
            System.arraycopy(this.values, 0, this.values, 1, this.num);
            ++this.num;
            this.names[0] = string;
            this.values[0] = n;
        }
    }

    String getCounterValue(String string, boolean bl, String string2, int n) {
        String string3 = "";
        if (bl) {
            for (int i = 0; i < this.num; ++i) {
                if (!this.names[i].equals(string)) continue;
                string3 = string3 + this.getValue(this.values[i], n);
                if (i >= this.num - 1) continue;
                string3 = string3 + string2;
            }
        } else {
            for (int i = this.num - 1; i >= 0; --i) {
                if (!this.names[i].equals(string)) continue;
                string3 = this.getValue(this.values[i], n);
                break;
            }
        }
        return string3;
    }

    private String getValue(int n, int n2) {
        switch (n2) {
            case 105: 
            case 106: {
                return this.getLowerAlphaValue(n);
            }
            case 107: 
            case 108: {
                return this.getUpperAlphaValue(n);
            }
            case 102: {
                if (n <= 0) break;
                return this.getLowerRomanValue(n);
            }
            case 103: {
                if (n <= 0) break;
                return this.getUpperRomanValue(n);
            }
        }
        return String.valueOf(n);
    }

    private String getLowerAlphaValue(int n) {
        return this.getAlphaValue(n, 97, 122);
    }

    private String getUpperAlphaValue(int n) {
        return this.getAlphaValue(n, 65, 90);
    }

    private String getAlphaValue(int n, int n2, int n3) {
        String string = "";
        if (n == 0) {
            return "@";
        }
        int n4 = n;
        if (n4 < 0) {
            n4 = -n4;
        }
        int n5 = n3 - n2 + 1;
        while (n4 > 0) {
            int n6 = n4 % n5 - 1;
            n4 /= n5;
            String string2 = String.valueOf((char)(n2 + n6));
            string = string2 + string;
        }
        if (n < 0) {
            string = "-" + string;
        }
        return string;
    }

    private String getLowerRomanValue(int n) {
        String string = this.digitToRoman(n % 10, "i", "v", "x");
        string = this.digitToRoman((n /= 10) % 10, "x", "l", "c") + string;
        string = this.digitToRoman((n /= 10) % 10, "c", "d", "m") + string;
        string = this.digitToRoman((n /= 10) % 10, "m", "h", " ") + string;
        n /= 10;
        return string;
    }

    private String getUpperRomanValue(int n) {
        String string = this.digitToRoman(n % 10, "I", "V", "X");
        string = this.digitToRoman((n /= 10) % 10, "X", "L", "C") + string;
        string = this.digitToRoman((n /= 10) % 10, "C", "D", "M") + string;
        string = this.digitToRoman((n /= 10) % 10, "M", "H", " ") + string;
        n /= 10;
        return string;
    }

    private String digitToRoman(int n, String string, String string2, String string3) {
        switch (n) {
            case 1: {
                return string;
            }
            case 2: {
                return string + string;
            }
            case 3: {
                return string + string + string;
            }
            case 4: {
                return string + string2;
            }
            case 5: {
                return string2;
            }
            case 6: {
                return string2 + string;
            }
            case 7: {
                return string2 + string + string;
            }
            case 8: {
                return string2 + string + string + string;
            }
            case 9: {
                return string + string3;
            }
        }
        return "";
    }

    private final void grow() {
        this.maxNum *= 2;
        String[] stringArray = new String[this.maxNum];
        int[] nArray = new int[this.maxNum];
        System.arraycopy(this.names, 0, stringArray, 0, this.num);
        System.arraycopy(this.values, 0, nArray, 0, this.num);
        this.names = stringArray;
        this.values = nArray;
    }
}

