/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.awt;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.DTextAreaElement;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.awt.DocView;
import ice.pilots.html4.awt.Movable;
import ice.util.Defs;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.TextArea;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

class FormTextArea
extends TextArea
implements EventListener,
ObjectPainter,
TextListener,
Movable {
    private DocView I;
    private DTextAreaElement OEAB;
    private ObjectBox add;
    private String addEventListener;

    FormTextArea(DocView docView, DElement dElement) {
        super(null, 0, 0, 1);
        this.I = docView;
        dElement.addEventListener("blur", this, false);
        this.OEAB = (DTextAreaElement)dElement;
        int n = dElement.getAttributeAsInt("rows");
        int n2 = dElement.getAttributeAsInt("cols");
        if (n < 0) {
            n = 3;
        }
        if (n2 < 0) {
            n2 = 20;
        }
        this.setRows(n + 1);
        this.setColumns(n2 + 1);
        String string = this.OEAB.getValue();
        if (string != null) {
            this.setText(string);
        }
        this.I();
        this.addTextListener(this);
        this.enableEvents(28L);
    }

    private void I() {
        this.setEditable(!this.OEAB.getReadOnly());
        this.setEnabled(!this.OEAB.getDisabled());
        String string = this.OEAB.getValue();
        if (string != null && !string.equals(this.getText())) {
            this.setText(string);
            try {
                this.setCaretPosition(string.length());
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        this.OEAB.setValue(this.getText());
    }

    public void onElementAttrChange(DElement dElement, DAttr dAttr) {
        this.I();
    }

    public void dispose() {
        Container container = this.getParent();
        if (container != null) {
            container.remove(this);
        }
    }

    public void setBox(ObjectBox objectBox) {
        this.add = objectBox;
        this.I.checkAwtTree(objectBox, this);
    }

    public ObjectBox getBox() {
        return this.add;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int n, int n2) {
        this.setSize(n, n2);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void draw(Graphics graphics) {
        if (this.isVisible()) {
            return;
        }
        graphics.setColor(Color.lightGray);
        graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
    }

    public void syncDom(int n, int n2, boolean bl) {
        this.setLocation(n, n2);
        this.setVisible(bl);
    }

    void updateFont() {
        CSSAttribs cSSAttribs;
        Font font;
        if (this.add != null && !(font = (cSSAttribs = this.add.getCSSAttribs()).getFont()).equals(super.getFont())) {
            int n = this.getCaretPosition();
            Container container = this.getParent();
            container.remove(this);
            super.setFont(font);
            container.add(this);
            try {
                this.setCaretPosition(n);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        ComponentEvent componentEvent;
        FormTextArea formTextArea = null;
        int n = aWTEvent.getID();
        if (n == 401 || n == 402) {
            componentEvent = (KeyEvent)aWTEvent;
            int n2 = ((KeyEvent)componentEvent).getKeyCode();
            if (n2 == 38 || n2 == 40 || n2 == 39 || n2 == 37) {
                formTextArea = this;
            } else if (n2 == 9) {
                ((InputEvent)componentEvent).consume();
            }
        }
        if (this.I.onComponentEvent(this, aWTEvent, formTextArea)) {
            super.processEvent(aWTEvent);
            if (n == 1004) {
                if (this.addEventListener == null) {
                    this.addEventListener = this.getText();
                }
            } else if (n == 1005 && !((FocusEvent)(componentEvent = (FocusEvent)aWTEvent)).isTemporary()) {
                String string = this.getText();
                if (!string.equals(this.addEventListener)) {
                    this.OEAB.dispatchChange();
                }
                this.addEventListener = null;
            }
        }
    }

    public void handleEvent(Event event) {
        DOMEvent dOMEvent = (DOMEvent)event;
        if (dOMEvent.getTypeId() == 22) {
            this.select(0, 0);
            return;
        }
        super.processEvent((AWTEvent)dOMEvent.getSystemEvent());
        dOMEvent.setDefaultDone();
    }

    public Dimension getPreferredSize() {
        String string = Defs.sysProperty((String)"ice.pilots.html4.colWidthChar");
        Dimension dimension = super.getPreferredSize();
        if (string == null || string.length() != 1) {
            return dimension;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            FontMetrics fontMetrics = this.getFontMetrics(this.add.getCSSAttribs().getFont());
            int n = this.getColumns() * fontMetrics.charWidth(string.charAt(0));
            Dimension dimension2 = new Dimension(n, dimension.height);
            return dimension2;
        }
    }

    public void setBorderVisible(boolean bl) {
    }

    public void setFontHints(CSSAttribs cSSAttribs) {
        this.updateFont();
    }
}

