/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.swing.DocView;
import ice.pilots.html4.swing.Movable;
import ice.util.Defs;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

class FormInputText
extends JTextField
implements EventListener,
ObjectPainter,
DocumentListener,
CaretListener,
Movable {
    private DocView OEAB;
    private DInputElement addCaretListener;
    private ObjectBox addDocumentListener;
    private Border black = this.getBorder();
    int maxLength = 10000;
    private String charAt;

    FormInputText(DocView docView, DElement dElement) {
        this.OEAB = docView;
        this.addCaretListener = (DInputElement)dElement;
        this.OEAB();
        int n = dElement.getAttributeAsInt("size");
        if (n <= 0) {
            n = 20;
        }
        this.setColumns(n + 1);
        this.setOpaque(true);
        this.getDocument().addDocumentListener(this);
        this.addCaretListener(this);
    }

    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
    }

    private void OEAB() {
        String string;
        this.setEditable(!this.addCaretListener.getReadOnly());
        this.setEnabled(!this.addCaretListener.getDisabled());
        int n = this.addCaretListener.getMaxLength();
        if (n > 0) {
            this.maxLength = n;
        }
        if ((string = this.addCaretListener.getValue()) != null && !string.equals(this.getText())) {
            int n2 = this.getCaretPosition();
            this.setText(string);
            try {
                this.setCaretPosition(n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.addCaretListener();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.addCaretListener();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.addCaretListener();
    }

    public void caretUpdate(CaretEvent caretEvent) {
        int n;
        int n2 = caretEvent.getDot();
        if (n2 != (n = caretEvent.getMark())) {
            int n3;
            int n4;
            if (n2 < n) {
                n4 = n2;
                n3 = n;
            } else {
                n3 = n2;
                n4 = n;
            }
            this.addCaretListener.dispatchSelection(n4, n3);
        }
    }

    private void addCaretListener() {
        this.OEAB.getPilot().getStorm().runOnEventThreadLater(new Runnable(this){
            private final FormInputText this$0;
            {
                this.this$0 = formInputText;
            }

            public void run() {
                this.this$0.updateFont();
                String string = this.this$0.getText();
                if (string.length() > this.this$0.maxLength) {
                    int n = this.this$0.getCaretPosition();
                    if (n > this.this$0.maxLength) {
                        n = this.this$0.maxLength;
                    }
                    string = string.substring(0, this.this$0.maxLength);
                    this.this$0.setText(string);
                    this.this$0.setCaretPosition(n);
                }
            }
        }, 0L);
        String string = this.addCaretListener.getValue();
        String string2 = this.getText();
        if (!string2.equals(string)) {
            this.addCaretListener.setValue(string2);
        }
    }

    void updateFont() {
        if (this.addDocumentListener != null) {
            String string = this.getText();
            CSSAttribs cSSAttribs = this.addDocumentListener.getCSSAttribs();
            Font font = cSSAttribs.getTestedFont(string);
            if (!font.equals(this.getFont())) {
                this.setFont(font);
            }
        }
    }

    public void onElementAttrChange(DElement dElement, DAttr dAttr) {
        this.OEAB();
    }

    public void dispose() {
        Container container = this.getParent();
        if (container != null) {
            container.remove(this);
        }
    }

    public void setBox(ObjectBox objectBox) {
        this.addDocumentListener = objectBox;
        this.OEAB.checkAwtTree(objectBox, this);
    }

    public ObjectBox getBox() {
        return this.addDocumentListener;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int n, int n2) {
        this.setSize(n, n2);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isManagingFocus() {
        return true;
    }

    public void draw(Graphics graphics) {
    }

    public void paintComponent(Graphics graphics) {
        if (this.isShowing()) {
            super.paintComponent(graphics);
        } else {
            graphics.translate(1, 1);
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.getSize().width - 2, this.getSize().height - 2);
            graphics.setColor(Color.lightGray);
            graphics.drawRect(0, 0, this.getSize().width - 2, this.getSize().height - 2);
            graphics.setColor(Color.black);
            String string = this.addCaretListener.getValue();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            fontMetrics = ((Component)this).getFontMetrics(this.getFont());
            int n = fontMetrics.getDescent();
            graphics.drawString(string, 2, this.getBounds().height / 2 + n);
        }
    }

    public void syncDom(int n, int n2, boolean bl) {
        this.setLocation(n, n2);
        this.setVisible(bl);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        KeyEvent keyEvent;
        int n;
        FormInputText formInputText = null;
        int n2 = aWTEvent.getID();
        if (!(n2 != 401 && n2 != 402 || (n = (keyEvent = (KeyEvent)aWTEvent).getKeyCode()) != 38 && n != 40 && n != 39 && n != 37)) {
            formInputText = this;
        }
        if (this.OEAB.onComponentEvent(this, aWTEvent, formInputText)) {
            super.processEvent(aWTEvent);
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        int n = focusEvent.getID();
        if (n == 1004) {
            this.addDocumentListener(focusEvent);
        } else if (n == 1005) {
            this.black(focusEvent);
        }
        super.processFocusEvent(focusEvent);
    }

    private void addDocumentListener(FocusEvent focusEvent) {
        if (this.charAt == null) {
            this.charAt = this.getText();
        }
    }

    private void black(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        String string = this.getText();
        if (!string.equals(this.charAt)) {
            this.addCaretListener.dispatchChange();
        }
        this.charAt = null;
    }

    public void handleEvent(Event event) {
        DOMEvent dOMEvent = (DOMEvent)event;
        super.processEvent((AWTEvent)dOMEvent.getSystemEvent());
        dOMEvent.setDefaultDone();
    }

    protected int getColumnWidth() {
        String string = Defs.sysProperty((String)"ice.pilots.html4.colWidthChar", (String)"o");
        if (string == null || string.length() != 1) {
            return super.getColumnWidth();
        }
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.getFont());
        return fontMetrics.charWidth(string.charAt(0));
    }

    public void setBorderVisible(boolean bl) {
        if (!bl) {
            this.setBorder(null);
        } else {
            this.setBorder(this.black);
        }
    }

    public void setFontHints(CSSAttribs cSSAttribs) {
        this.updateFont();
    }
}

