/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool.propertyeditor.panels;

import com.mathworks.beans.EnumPair;
import com.mathworks.hg.types.HGDouble;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.mlservices.MLInspectorServices;
import com.mathworks.mlwidgets.graphics.ColorPicker;
import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.page.plottool.PropertyEditor;
import com.mathworks.page.plottool.propertyeditor.PropertyEditorResources;
import com.mathworks.page.plottool.propertyeditor.controls.CategoricalVariableComboControl;
import com.mathworks.page.plottool.propertyeditor.controls.ColorControl;
import com.mathworks.page.plottool.propertyeditor.controls.ComboControl;
import com.mathworks.page.plottool.propertyeditor.controls.FontComboControl;
import com.mathworks.page.plottool.propertyeditor.controls.PropertyControl;
import com.mathworks.page.plottool.propertyeditor.controls.RadioControl;
import com.mathworks.page.plottool.propertyeditor.controls.SliderControl;
import com.mathworks.page.plottool.propertyeditor.panels.IPropertyPanel;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;

public class PropertyPanel
extends MJPanel
implements IPropertyPanel,
Customizer,
CellEditorListener {
    protected Object[] fObjects;
    protected Vector<PropertyControl> fControls = new Vector();
    protected Matlab fMatlab;
    protected PropertyEditor fPropertyEditor = null;
    protected MJButton fOptionsBtn;
    protected MJButton fRefreshBtn;
    protected ButtonPanel fOptionsBtnPanel;
    public static int VERT_SPACE = 3;
    public static int HORIZ_SPACE = 2;
    public static int LG_VERT_SPACE = 10;
    public static int LG_HORIZ_SPACE = 15;
    private MatlabListener fRefreshLsnr = new MatlabListener(){

        public void matlabEvent(MatlabEvent matlabEvent) {
            PropertyPanel.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    };

    public PropertyPanel() {
        this.fMatlab = new Matlab();
        this.setBorder(BorderFactory.createEmptyBorder(5, 4, 5, 0));
        String string = this.getClass().getName();
        this.setName(string.substring(string.lastIndexOf(46) + 1, string.length()));
    }

    @Override
    public void setObject(Object object) {
        try {
            this.fObjects = (Object[])object;
        }
        catch (ClassCastException classCastException) {
            this.fObjects = new Object[]{object};
        }
        this.clearPropertyControlListeners();
        if (this.fObjects == null || this.fObjects.length == 0) {
            return;
        }
        this.addPropertyControlListeners(this.fObjects);
        for (PropertyControl propertyControl : this.fControls) {
            propertyControl.initialize(this.fObjects, propertyControl.getPropertyName());
        }
    }

    @Override
    public PropertyEditor getPropertyEditor() {
        return this.fPropertyEditor;
    }

    @Override
    public void setPropertyEditor(PropertyEditor propertyEditor) {
        this.fPropertyEditor = propertyEditor;
        this.doButtonLayout();
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        PropertyControl propertyControl = null;
        if (changeEvent.getSource() instanceof PropertyControl) {
            propertyControl = (PropertyControl)changeEvent.getSource();
        }
        if (propertyControl != null) {
            propertyControl.applyChanges(this.fObjects);
        }
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    public void addPropertyControlListeners(Object[] objectArray) {
        for (PropertyControl propertyControl : this.fControls) {
            propertyControl.addPropertyControlListeners(objectArray);
        }
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        for (PropertyControl propertyControl : this.fControls) {
            propertyControl.addCellEditorListener(cellEditorListener);
        }
    }

    public void clearPropertyControlListeners() {
        for (PropertyControl propertyControl : this.fControls) {
            propertyControl.clearPropertyControlListeners();
        }
    }

    public void registerControl(PropertyControl propertyControl) {
        if (propertyControl != null) {
            this.fControls.add(propertyControl);
        }
    }

    protected static GridBagConstraints createLabelGBC() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(VERT_SPACE, HORIZ_SPACE, VERT_SPACE, HORIZ_SPACE);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        return gridBagConstraints;
    }

    protected static GridBagConstraints createControlGBC() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(VERT_SPACE, HORIZ_SPACE, VERT_SPACE, HORIZ_SPACE);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        return gridBagConstraints;
    }

    protected static GridBagConstraints createBottomSpacerGBC() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        return gridBagConstraints;
    }

    protected static GridBagConstraints createRightSpacerGBC() {
        GridBagConstraints gridBagConstraints = PropertyPanel.createBottomSpacerGBC();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        return gridBagConstraints;
    }

    protected static GridBagConstraints createSeparatorGBC() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(LG_VERT_SPACE, 0, 0, 0);
        return gridBagConstraints;
    }

    protected static GridBagConstraints createButtonGBC() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 1);
        return gridBagConstraints;
    }

    protected JPanel createButtonPanel() {
        return this.createButtonPanel(false);
    }

    protected JPanel createButtonPanel(boolean bl) {
        this.fOptionsBtn = this.createButton(PropertyEditorResources.getBundle().getString("button.inspector"), "InspectorButton");
        PropertyPanel.protectSizeFromGridBag((JComponent)this.fOptionsBtn);
        this.fOptionsBtn.setToolTipText(PropertyEditorResources.getBundle().getString("tooltip.inspector"));
        this.fOptionsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Matlab.whenMatlabIdle((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                MLInspectorServices.inspectObjectArray((Object[])PropertyPanel.this.fObjects);
                            }
                        });
                    }
                });
            }
        });
        this.fRefreshBtn = null;
        if (bl) {
            this.fRefreshBtn = this.createButton(PropertyEditorResources.getBundle().getString("button.refreshdata"), "RefreshButton");
            this.fRefreshBtn.setToolTipText(PropertyEditorResources.getBundle().getString("tooltip.refreshdata"));
            this.fRefreshBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PropertyPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                    PropertyPanel.this.fMatlab.feval("plottoolfunc", new Object[]{"doRefreshData", PropertyPanel.this.fObjects}, 0, PropertyPanel.this.fRefreshLsnr);
                }
            });
        }
        this.fOptionsBtnPanel = new ButtonPanel();
        this.doButtonLayout();
        return this.fOptionsBtnPanel;
    }

    protected void doButtonLayout() {
        if (this.fOptionsBtn == null) {
            return;
        }
        this.fOptionsBtnPanel.removeAll();
        if (this.fPropertyEditor == null || this.fPropertyEditor.isShowInspectorButton()) {
            this.fOptionsBtnPanel.add((Component)this.fOptionsBtn);
        }
        if (this.fRefreshBtn != null && (this.fPropertyEditor == null || this.fPropertyEditor.isShowRefreshDataButton())) {
            this.fOptionsBtnPanel.add((Component)this.fRefreshBtn);
        }
        Vector<MJButton> vector = this.fOptionsBtnPanel.getAdditionalButtons();
        for (MJButton mJButton : vector) {
            this.fOptionsBtnPanel.add((Component)mJButton);
        }
        this.fOptionsBtnPanel.validate();
    }

    public void setShowInspectorButton(boolean bl) {
        this.doButtonLayout();
    }

    public void setShowRefreshDataButton(boolean bl) {
        this.doButtonLayout();
    }

    protected MJButton createButton(String string, String string2) {
        String string3 = this.getName();
        MJButton mJButton = new MJButton(string);
        mJButton.setDefaultCapable(false);
        mJButton.setName(string3.substring(0, string3.indexOf("PropPanel")) + string2);
        Insets insets = mJButton.getMargin();
        if (PlatformInfo.isWindows()) {
            mJButton.setMargin(new Insets(insets.top, insets.left - 3, insets.bottom, insets.right - 3));
        }
        return mJButton;
    }

    public void addAdditionalButton(MJButton mJButton) {
        this.fOptionsBtnPanel.addAdditionalButton(mJButton);
    }

    public static void protectSizeFromGridBag(JComponent jComponent) {
        Dimension dimension = jComponent.getPreferredSize();
        jComponent.setMinimumSize(dimension);
    }

    protected MJPanel createFontPanel(CellEditorListener cellEditorListener, String string, String string2) {
        ComboControl comboControl = PropertyEditor.isHGUsingMATLABClasses() ? new FontComboControl("FontName", cellEditorListener, string2) : new FontFamilyControl("FontName", cellEditorListener, string2);
        return PropertyPanel.createFontPanel(cellEditorListener, string, string2, comboControl);
    }

    public static MJPanel createFontPanel(CellEditorListener cellEditorListener, String string, String string2, ComboControl comboControl, ComboControl comboControl2, ComboControl comboControl3) {
        FontSizeControl fontSizeControl = new FontSizeControl("FontSize", cellEditorListener, string2);
        ColorControl colorControl = null;
        if (string != null) {
            colorControl = new ColorControl(string, cellEditorListener, ColorPicker.NO_OPTIONS, ColorPicker.TEXT_ICON, PropertyEditorResources.getBundle().getString("ColorControl.caption.textcolor"), string2);
        }
        fontSizeControl.setWidth(70);
        PropertyPanel.protectSizeFromGridBag((JComponent)((Object)comboControl));
        PropertyPanel.protectSizeFromGridBag((JComponent)((Object)fontSizeControl));
        PropertyPanel.protectSizeFromGridBag((JComponent)((Object)comboControl2));
        PropertyPanel.protectSizeFromGridBag((JComponent)((Object)comboControl3));
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridLayout(1, 2, HORIZ_SPACE, VERT_SPACE));
        mJPanel.add((Component)((Object)comboControl2));
        mJPanel.add((Component)((Object)comboControl3));
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = PropertyPanel.createControlGBC();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        GridBagConstraints gridBagConstraints2 = PropertyPanel.createControlGBC();
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        mJPanel2.add((Component)((Object)comboControl), (Object)gridBagConstraints);
        gridBagConstraints2.gridx = 2;
        mJPanel2.add((Component)((Object)fontSizeControl), (Object)gridBagConstraints2);
        gridBagConstraints2.gridy = 1;
        gridBagConstraints.gridy = 1;
        if (string != null) {
            gridBagConstraints2.gridx = 0;
            mJPanel2.add((Component)((Object)colorControl), (Object)gridBagConstraints2);
            gridBagConstraints.gridx = 1;
            mJPanel2.add((Component)mJPanel, (Object)gridBagConstraints);
        } else {
            gridBagConstraints.gridx = 0;
            mJPanel2.add((Component)mJPanel, (Object)gridBagConstraints);
        }
        return mJPanel2;
    }

    public static MJPanel createFontPanel(CellEditorListener cellEditorListener, String string, String string2, ComboControl comboControl) {
        if (PropertyEditor.isHGUsingMATLABClasses()) {
            return PropertyPanel.createMCOSFontPanel(cellEditorListener, string, string2, comboControl);
        }
        return PropertyPanel.createNonMCOSFontPanel(cellEditorListener, string, string2, comboControl);
    }

    public static MJPanel createMCOSFontPanel(CellEditorListener cellEditorListener, String string, String string2, ComboControl comboControl) {
        CategoricalVariableComboControl categoricalVariableComboControl = new CategoricalVariableComboControl("FontWeight", cellEditorListener, string2);
        CategoricalVariableComboControl categoricalVariableComboControl2 = new CategoricalVariableComboControl("FontAngle", cellEditorListener, string2);
        return PropertyPanel.createFontPanel(cellEditorListener, string, string2, comboControl, categoricalVariableComboControl, categoricalVariableComboControl2);
    }

    public static MJPanel createNonMCOSFontPanel(CellEditorListener cellEditorListener, String string, String string2, ComboControl comboControl) {
        FontWeightControl fontWeightControl = new FontWeightControl("FontWeight", cellEditorListener, string2);
        FontAngleControl fontAngleControl = new FontAngleControl("FontAngle", cellEditorListener, string2);
        return PropertyPanel.createFontPanel(cellEditorListener, string, string2, comboControl, fontWeightControl, fontAngleControl);
    }

    public static class AlignmentControl
    extends RadioControl {
        public AlignmentControl(String string, CellEditorListener cellEditorListener, String string2) {
            super(string, cellEditorListener, new EnumPair[]{new EnumPair(PropertyEditorResources.getBundle().getString("value.left"), 0), new EnumPair(PropertyEditorResources.getBundle().getString("value.center"), 1), new EnumPair(PropertyEditorResources.getBundle().getString("value.right"), 2)}, new String[]{"align-left.gif", "align-center.gif", "align-right.gif"}, 0, string2);
            this.setMinimumSize(new Dimension(this.getPreferredSize().width, this.getPreferredSize().height));
        }
    }

    public static class InterpreterControl
    extends ComboControl {
        public InterpreterControl(String string, CellEditorListener cellEditorListener, String string2) {
            super(string, cellEditorListener, new EnumPair[]{new EnumPair(PropertyEditorResources.getBundle().getString("value.tex"), 0), new EnumPair(PropertyEditorResources.getBundle().getString("value.latex"), 1), new EnumPair(PropertyEditorResources.getBundle().getString("value.none"), 2)}, string2);
            this.setEditable(false);
            this.setMaximumRowCount(3);
        }
    }

    public static class FontSizeControl
    extends SizeControl {
        public FontSizeControl(String string, CellEditorListener cellEditorListener, String string2) {
            super(string, cellEditorListener, string2, new EnumPair[]{new EnumPair("5.0", 5.0), new EnumPair("6.0", 6.0), new EnumPair("7.0", 7.0), new EnumPair("8.0", 8.0), new EnumPair("9.0", 9.0), new EnumPair("10.0", 10.0), new EnumPair("11.0", 11.0), new EnumPair("12.0", 12.0), new EnumPair("14.0", 14.0), new EnumPair("16.0", 16.0), new EnumPair("20.0", 20.0), new EnumPair("24.0", 24.0), new EnumPair("30.0", 30.0)});
            this.setMaximumRowCount(13);
            this.setWidth(70);
        }
    }

    public static class FontUnitsControl
    extends ComboControl {
        public FontUnitsControl(String string, CellEditorListener cellEditorListener, String string2) {
            super(string, cellEditorListener, new EnumPair[]{new EnumPair(PropertyEditorResources.getBundle().getString("value.inches"), 0), new EnumPair(PropertyEditorResources.getBundle().getString("value.centimeters"), 1), new EnumPair(PropertyEditorResources.getBundle().getString("value.normalized"), 2), new EnumPair(PropertyEditorResources.getBundle().getString("value.points"), 3), new EnumPair(PropertyEditorResources.getBundle().getString("value.pixels"), 4)}, string2);
            this.setEditable(false);
            this.setMaximumRowCount(5);
        }
    }

    public static class FontAngleControl
    extends ComboControl {
        public FontAngleControl(String string, CellEditorListener cellEditorListener, String string2) {
            super(string, cellEditorListener, new EnumPair[]{new EnumPair(PropertyEditorResources.getBundle().getString("value.normal"), 0), new EnumPair(PropertyEditorResources.getBundle().getString("value.italic"), 1), new EnumPair(PropertyEditorResources.getBundle().getString("value.oblique"), 2)}, string2);
            this.setEditable(false);
            this.setMaximumRowCount(3);
        }
    }

    public static class FontWeightControl
    extends ComboControl {
        public FontWeightControl(String string, CellEditorListener cellEditorListener, String string2) {
            super(string, cellEditorListener, new EnumPair[]{new EnumPair(PropertyEditorResources.getBundle().getString("value.light"), 0), new EnumPair(PropertyEditorResources.getBundle().getString("value.normal"), 1), new EnumPair(PropertyEditorResources.getBundle().getString("value.demi"), 2), new EnumPair(PropertyEditorResources.getBundle().getString("value.bold"), 3)}, string2);
            this.setEditable(false);
            this.setMaximumRowCount(4);
        }
    }

    public static class FontFamilyControl
    extends ComboControl {
        protected static volatile String[] availableFonts = null;
        protected static String[] hgFonts = new String[]{"AvantGarde", "Bookman", "Courier", "Helvetica", "Helvetica-Narrow", "MS Sans Serif", "New Century Schoolbook", "Palatino", "Symbol", "Times", "ZapfChancery", "ZapfDingbats"};

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FontFamilyControl(String string, CellEditorListener cellEditorListener, String string2) {
            super(string, cellEditorListener, string2);
            this.setEditable(false);
            FontFamilyControl fontFamilyControl = this;
            synchronized (fontFamilyControl) {
                if (availableFonts == null) {
                    List list = FontUtils.getFontNames();
                    Vector<String> vector = new Vector<String>(list);
                    if (!PlatformInfo.isMacintosh()) {
                        for (String string3 : hgFonts) {
                            if (vector.contains(string3)) continue;
                            vector.add(string3);
                        }
                    }
                    availableFonts = new String[vector.size()];
                    vector.copyInto(availableFonts);
                    Arrays.sort(availableFonts);
                }
            }
            this.setOptions(availableFonts, availableFonts);
        }
    }

    public static class AlphaControl
    extends SliderControl {
        public AlphaControl(String string, CellEditorListener cellEditorListener, String string2) {
            super(string, cellEditorListener, 0, 100, string2);
            this.setMultiplier(0.01f);
        }
    }

    public static class ArrowheadControl
    extends ComboControl {
        public ArrowheadControl(String string, CellEditorListener cellEditorListener, String string2) {
            super(string, cellEditorListener, new EnumPair[]{new EnumPair(PropertyEditorResources.getBundle().getString("arrowhead.none"), 0), new EnumPair(PropertyEditorResources.getBundle().getString("arrowhead.plain"), 1), new EnumPair(PropertyEditorResources.getBundle().getString("arrowhead.vback1"), 3), new EnumPair(PropertyEditorResources.getBundle().getString("arrowhead.vback2"), 4), new EnumPair(PropertyEditorResources.getBundle().getString("arrowhead.vback3"), 5), new EnumPair(PropertyEditorResources.getBundle().getString("arrowhead.cback1"), 6), new EnumPair(PropertyEditorResources.getBundle().getString("arrowhead.cback2"), 7), new EnumPair(PropertyEditorResources.getBundle().getString("arrowhead.cback3"), 8), new EnumPair(PropertyEditorResources.getBundle().getString("arrowhead.diamond"), 11), new EnumPair(PropertyEditorResources.getBundle().getString("arrowhead.star4"), 9), new EnumPair(PropertyEditorResources.getBundle().getString("arrowhead.rectangle"), 10), new EnumPair(PropertyEditorResources.getBundle().getString("arrowhead.ellipse"), 2), new EnumPair(PropertyEditorResources.getBundle().getString("arrowhead.rose"), 12), new EnumPair(PropertyEditorResources.getBundle().getString("arrowhead.hypocycloid"), 13), new EnumPair(PropertyEditorResources.getBundle().getString("arrowhead.astroid"), 14), new EnumPair(PropertyEditorResources.getBundle().getString("arrowhead.deltoid"), 15)}, string2);
            this.setEditable(false);
            this.setMaximumRowCount(16);
        }
    }

    public static class MarkerStyleControl
    extends ComboControl {
        public MarkerStyleControl(String string, CellEditorListener cellEditorListener, String string2) {
            super(string, cellEditorListener, new EnumPair[]{new EnumPair(PropertyEditorResources.getBundle().getString("marker.none"), 13), new EnumPair(PropertyEditorResources.getBundle().getString("marker.circle"), 1), new EnumPair(PropertyEditorResources.getBundle().getString("marker.square"), 5), new EnumPair(PropertyEditorResources.getBundle().getString("marker.x"), 4), new EnumPair(PropertyEditorResources.getBundle().getString("marker.point"), 3), new EnumPair(PropertyEditorResources.getBundle().getString("marker.plus"), 0), new EnumPair(PropertyEditorResources.getBundle().getString("marker.asterisk"), 2), new EnumPair(PropertyEditorResources.getBundle().getString("marker.diamond"), 6), new EnumPair(PropertyEditorResources.getBundle().getString("marker.triangle"), 7), new EnumPair(PropertyEditorResources.getBundle().getString("marker.pyramid"), 8), new EnumPair(PropertyEditorResources.getBundle().getString("marker.left"), 10), new EnumPair(PropertyEditorResources.getBundle().getString("marker.right"), 9), new EnumPair(PropertyEditorResources.getBundle().getString("marker.ptstar5"), 11), new EnumPair(PropertyEditorResources.getBundle().getString("marker.ptstar6"), 12)}, new String[]{null, "marker-circle.gif", "marker-square.gif", "marker-x.gif", "marker-point.gif", "marker-plus.gif", "marker-asterisk.gif", "marker-diamond.gif", "marker-triangle.gif", "marker-pyramid.gif", "marker-left.gif", "marker-right.gif", "marker-pentoid.gif", "marker-hexoid.gif"}, string2);
            this.setEditable(false);
            this.setMaximumRowCount(14);
            this.setWidth(PlatformInfo.isMacintosh() ? 80 : 70);
        }
    }

    public static class LineStyleControl
    extends ComboControl {
        public LineStyleControl(String string, CellEditorListener cellEditorListener, String string2) {
            super(string, cellEditorListener, new EnumPair[]{new EnumPair(PropertyEditorResources.getBundle().getString("linestyle.solid"), 0), new EnumPair(PropertyEditorResources.getBundle().getString("linestyle.dashed"), 1), new EnumPair(PropertyEditorResources.getBundle().getString("linestyle.dotted"), 2), new EnumPair(PropertyEditorResources.getBundle().getString("linestyle.dashdot"), 3), new EnumPair(PropertyEditorResources.getBundle().getString("linestyle.noline"), 4)}, new String[]{"linestyle-solid.gif", "linestyle-dash.gif", "linestyle-dot.gif", "linestyle-dashdot.gif", null}, string2);
            this.setWidth(PlatformInfo.isMacintosh() ? 80 : 70);
        }
    }

    public static class SizeControl
    extends ComboControl {
        public SizeControl(String string, CellEditorListener cellEditorListener, String string2) {
            this(string, cellEditorListener, string2, new EnumPair[]{new EnumPair("0.5", 0.5), new EnumPair("1.0", 1.0), new EnumPair("2.0", 2.0), new EnumPair("3.0", 3.0), new EnumPair("4.0", 4.0), new EnumPair("6.0", 6.0), new EnumPair("8.0", 8.0), new EnumPair("10.0", 10.0), new EnumPair("15.0", 15.0), new EnumPair("20.0", 20.0), new EnumPair("25.0", 25.0), new EnumPair("30.0", 30.0)});
        }

        public SizeControl(String string, CellEditorListener cellEditorListener, String string2, EnumPair[] enumPairArray) {
            super(string, cellEditorListener, enumPairArray, string2);
            this.setCanBeEmpty(false);
            this.setCanBeNegative(false);
            this.setCanBeNAN(false);
            this.setEditable(true);
            this.setMaximumRowCount(12);
            this.setWidth(PlatformInfo.isMacintosh() ? 80 : 70);
        }

        @Override
        public void setDisplayedValue(Object object) {
            if (object instanceof HGDouble) {
                super.setDisplayedValue(((HGDouble)object).getValue());
            } else {
                super.setDisplayedValue(object);
            }
        }

        @Override
        public Object getDisplayedValue() {
            if (this.getPropertyType() == HGDouble.class) {
                double d;
                Object object = this.fCombo.getSelectedItem();
                String string = (String)object;
                if (string.isEmpty()) {
                    this.errorAndCleanup(string, "PropertyControl.error.empty");
                    return null;
                }
                if (string.equalsIgnoreCase("nan")) {
                    this.errorAndCleanup(string, "PropertyControl.error.parse");
                    return null;
                }
                try {
                    d = Double.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.errorAndCleanup(string, "PropertyControl.error.parse");
                    return null;
                }
                if (d <= 0.0) {
                    this.errorAndCleanup(string, "PropertyControl.error.negative");
                    return null;
                }
                return new HGDouble(d);
            }
            return super.getDisplayedValue();
        }
    }

    static class ButtonPanel
    extends MJPanel {
        MJPanel innerPanel;
        Vector<MJButton> fAdditionalButtons = new Vector();

        public ButtonPanel() {
            this.setBorder(BorderFactory.createEmptyBorder(3, 2, 3, 2));
            this.setLayout(new BorderLayout());
            this.innerPanel = new MJPanel((LayoutManager)new GridLayout(3, 1, 5, 5));
            this.add((Component)this.innerPanel, "East");
        }

        public Vector<MJButton> getAdditionalButtons() {
            return this.fAdditionalButtons;
        }

        public void addAdditionalButton(MJButton mJButton) {
            this.fAdditionalButtons.add(mJButton);
            this.innerPanel.add((Component)mJButton);
        }

        public Component add(Component component) {
            return this.innerPanel.add(component);
        }

        public void removeAll() {
            this.innerPanel.removeAll();
        }
    }
}

