/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool.propertyeditor.controls;

import com.mathworks.hg.types.HGPoint;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.page.plottool.ErrorHandler;
import com.mathworks.page.plottool.propertyeditor.PropertyEditorResources;
import com.mathworks.page.plottool.propertyeditor.controls.AbstractMultiFieldControl;
import com.mathworks.page.plottool.propertyeditor.controls.PropertyControl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.im.InputContext;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.CellEditorListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class LimitsControl
extends AbstractMultiFieldControl {
    protected final MJTextField fLowTF = new MJTextField();
    protected final MJTextField fHighTF = new MJTextField();
    protected final double[] fCurrentLimits = new double[2];
    protected final Matlab fMatlab = new Matlab();
    private final NumberFormat formatter;
    private volatile boolean fIsMin;
    private String fPrevLowText;
    private String fPrevHighText;
    private final TransferHandler fTransferHandler = new TextControlTransferHandler();

    public LimitsControl(String string, CellEditorListener cellEditorListener, String string2) {
        super(string, cellEditorListener);
        this.constructorHelper();
        this.setName(string2 + "." + string);
        this.formatter = NumberFormat.getInstance(Locale.US);
        this.formatter.setGroupingUsed(false);
    }

    private String format(double d) {
        if (Double.isInfinite(d)) {
            return d >= 0.0 ? "inf" : "-inf";
        }
        if (this.formatter instanceof DecimalFormat) {
            String string;
            DecimalFormat decimalFormat = (DecimalFormat)this.formatter;
            String string2 = ".###########E0";
            if (Math.abs(d) < Math.abs(1.0E-5) && Math.abs(d) != 0.0 || Math.abs(d) > Math.abs(1.0E7)) {
                decimalFormat.applyPattern(string2);
                string = decimalFormat.format(d);
            } else {
                decimalFormat.applyPattern("");
                decimalFormat.setMinimumFractionDigits(0);
                decimalFormat.setMinimumIntegerDigits(0);
                string = decimalFormat.format(d);
            }
            return string;
        }
        return this.formatter.format(d);
    }

    private static double parseDouble(String string) {
        if ("inf".equalsIgnoreCase(string)) {
            return Double.POSITIVE_INFINITY;
        }
        if ("-inf".equalsIgnoreCase(string)) {
            return Double.NEGATIVE_INFINITY;
        }
        return Double.parseDouble(string);
    }

    public void setName(String string) {
        if (this.fLowTF != null && this.fHighTF != null) {
            this.fLowTF.setName(string + "Min");
            this.fHighTF.setName(string + "Max");
        }
    }

    private void constructorHelper() {
        this.fLowTF.addFocusListener(this.focusLsnr);
        this.fHighTF.addFocusListener(this.focusLsnr);
        this.fLowTF.addActionListener(this.actionLsnr);
        this.fHighTF.addActionListener(this.actionLsnr);
        this.fLowTF.addKeyListener((KeyListener)this.enterLsnr);
        this.fHighTF.addKeyListener((KeyListener)this.enterLsnr);
        GridBagLayout gridBagLayout = new GridBagLayout();
        MJPanel mJPanel = new MJPanel((LayoutManager)gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 15;
        gridBagConstraints2.insets = new Insets(0, 5, 3, 5);
        gridBagConstraints.gridx = 0;
        mJPanel.add((Component)this.fLowTF, (Object)gridBagConstraints);
        gridBagConstraints2.gridx = 1;
        mJPanel.add((Component)new MJLabel(PropertyEditorResources.getBundle().getString("LimitsControl.infix")), (Object)gridBagConstraints2);
        gridBagConstraints.gridx = 2;
        mJPanel.add((Component)this.fHighTF, (Object)gridBagConstraints);
        this.setCustomEditor((JComponent)mJPanel);
        this.fLowTF.setToolTipText(this.getPropertyName());
        this.fHighTF.setToolTipText(this.getPropertyName());
        this.fLowTF.setTransferHandler(this.fTransferHandler);
        this.fHighTF.setTransferHandler(this.fTransferHandler);
    }

    @Override
    protected void doEventResponse(JTextField jTextField) {
        boolean bl;
        String string = jTextField.getText().trim();
        this.fIsMin = bl = jTextField.getName().endsWith("Min");
        if (string == null || string.length() == 0) {
            if (bl) {
                this.fLowTF.setText(this.fPrevLowText);
            } else {
                this.fHighTF.setText(this.fPrevHighText);
            }
            return;
        }
        if (!string.equals(PropertyControl.MIXED_VALUES)) {
            if (string.toLowerCase().equals("nan")) {
                this.showErrorAndResetFields(PropertyEditorResources.getBundle().getString("PropertyControl.error.empty"));
            } else {
                try {
                    double d = LimitsControl.parseDouble(string);
                    this.fCurrentLimits[bl ? 0 : 1] = d;
                }
                catch (NumberFormatException numberFormatException) {
                    this.fMatlab.eval("disp(" + string + ")", (CompletionObserver)new LimitsInputCompletionObserver(string));
                }
            }
        }
    }

    private void showErrorAndResetFields(String string) {
        assert (string != null);
        int n = string.indexOf("\n\n");
        String string2 = n > 0 ? string.substring(0, n) : string;
        final String string3 = string2;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ErrorHandler.showSimpleError(string3, LimitsControl.this.getTopLevelAncestor());
                if (LimitsControl.this.fIsMin) {
                    LimitsControl.this.fLowTF.setText(LimitsControl.this.fPrevLowText);
                    LimitsControl.this.fLowTF.selectAll();
                    LimitsControl.this.fLowTF.requestFocusInWindow();
                } else {
                    LimitsControl.this.fHighTF.setText(LimitsControl.this.fPrevHighText);
                    LimitsControl.this.fHighTF.selectAll();
                    LimitsControl.this.fHighTF.requestFocusInWindow();
                }
                LimitsControl.this.fIgnoreEvents = false;
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public void setDisplayedValue(Object object) {
        String string = null;
        String string2 = null;
        if (object == null) {
            string = this.fPrevLowText;
            string2 = this.fPrevHighText;
        } else if (object == PropertyControl.MIXED_VALUES) {
            string = string2 = (String)PropertyControl.MIXED_VALUES;
        } else if (object instanceof HGPoint) {
            HGPoint hGPoint = (HGPoint)object;
            this.fCurrentLimits[0] = hGPoint.getX();
            this.fCurrentLimits[1] = hGPoint.getY();
            string = this.format(hGPoint.getX());
            string2 = this.format(hGPoint.getY());
        }
        this.fPrevLowText = string;
        this.fPrevHighText = string2;
        this.fLowTF.setText(string);
        this.fHighTF.setText(string2);
    }

    @Override
    public Object getDisplayedValue() {
        return new HGPoint(this.fCurrentLimits[0], this.fCurrentLimits[1]);
    }

    @Override
    public void addEditStoppedSupport() {
        this.fLowTF.addActionListener(this.action);
        this.fLowTF.addFocusListener((FocusListener)this.focus);
        this.fLowTF.addKeyListener((KeyListener)this.enterKey);
        this.fHighTF.addActionListener(this.action);
        this.fHighTF.addFocusListener((FocusListener)this.focus);
        this.fHighTF.addKeyListener((KeyListener)this.enterKey);
    }

    public void setEnabled(boolean bl) {
        this.fLowTF.setEnabled(bl);
        this.fHighTF.setEnabled(bl);
    }

    @Override
    protected void propertyEditStopped() {
        if (!this.fLowTF.getText().equals(PropertyControl.MIXED_VALUES) && !this.fHighTF.getText().equals(PropertyControl.MIXED_VALUES)) {
            if (this.fCurrentLimits[0] >= this.fCurrentLimits[1]) {
                try {
                    this.fCurrentLimits[0] = LimitsControl.parseDouble(this.fPrevLowText);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    this.fCurrentLimits[1] = LimitsControl.parseDouble(this.fPrevHighText);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.fLowTF.setText(this.fPrevLowText);
                this.fHighTF.setText(this.fPrevHighText);
                ErrorHandler.showSimpleError(PropertyEditorResources.getBundle().getString("PropertyControl.error.badorder"), this.getTopLevelAncestor());
            } else {
                super.propertyEditStopped();
            }
        }
    }

    private class LimitsInputCompletionObserver
    implements CompletionObserver {
        private String iText = "";

        LimitsInputCompletionObserver(String string) {
            this.iText = string;
        }

        public void completed(int n, Object object) {
            LimitsControl.this.fIgnoreEvents = true;
            int n2 = Matlab.getExecutionStatus((int)n);
            String string = ((String)object).trim();
            switch (n2) {
                case 0: {
                    Double d;
                    try {
                        d = LimitsControl.parseDouble(string);
                        LimitsControl.this.fCurrentLimits[((LimitsControl)LimitsControl.this).fIsMin ? 0 : 1] = d;
                    }
                    catch (NumberFormatException numberFormatException) {
                        LimitsControl.this.showErrorAndResetFields(PropertyEditorResources.getBundle().getString("PropertyControl.error.empty"));
                        return;
                    }
                    LimitsControl.this.fCurrentLimits[((LimitsControl)LimitsControl.this).fIsMin ? 0 : 1] = d;
                    LimitsControl.this.propertyEditStopped();
                    LimitsControl.this.fIgnoreEvents = false;
                    break;
                }
                case 1: {
                    LimitsControl.this.showErrorAndResetFields(PropertyEditorResources.getBundle().getString("PropertyControl.error.empty"));
                    break;
                }
                case 2: {
                    StringBuilder stringBuilder = new StringBuilder(PropertyEditorResources.getBundle().getString("PropertyControl.error.invVarOrFunc"));
                    if (this.iText != null && this.iText.trim().length() > 0) {
                        stringBuilder.append(": ");
                        stringBuilder.append(this.iText);
                    }
                    LimitsControl.this.showErrorAndResetFields(stringBuilder.toString());
                }
            }
        }
    }

    class TextControlTransferHandler
    extends TransferHandler {
        TextControlTransferHandler() {
        }

        @Override
        public boolean importData(JComponent jComponent, Transferable transferable) {
            DataFlavor dataFlavor = this.getFlavor(transferable.getTransferDataFlavors());
            if (dataFlavor != null) {
                InputContext inputContext = jComponent.getInputContext();
                if (inputContext != null) {
                    inputContext.endComposition();
                }
                try {
                    String string = (String)transferable.getTransferData(dataFlavor);
                    ((JTextComponent)jComponent).setText(string);
                    LimitsControl.this.doEventResponse((JTextField)jComponent);
                    LimitsControl.this.propertyEditStopped();
                    LimitsControl.this.fLowTF.setText(LimitsControl.this.format(LimitsControl.this.fCurrentLimits[0]));
                    LimitsControl.this.fHighTF.setText(LimitsControl.this.format(LimitsControl.this.fCurrentLimits[1]));
                    return true;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                return false;
            }
            return this.getFlavor(dataFlavorArray) != null;
        }

        @Override
        public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) {
            int n2;
            JTextComponent jTextComponent;
            int n3;
            if (jComponent instanceof JTextComponent && (n3 = (jTextComponent = (JTextComponent)jComponent).getSelectionStart()) != (n2 = jTextComponent.getSelectionEnd())) {
                try {
                    Document document = jTextComponent.getDocument();
                    String string = document.getText(n3, n2 - n3);
                    StringSelection stringSelection = new StringSelection(string);
                    clipboard.setContents(stringSelection, null);
                    if (n == 2) {
                        document.remove(n3, n2 - n3);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        private DataFlavor getFlavor(DataFlavor[] dataFlavorArray) {
            if (dataFlavorArray != null) {
                for (int i = 0; i < dataFlavorArray.length; ++i) {
                    if (!dataFlavorArray[i].equals(DataFlavor.stringFlavor)) continue;
                    return dataFlavorArray[i];
                }
            }
            return null;
        }
    }
}

