/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.datamgr.linkedplots;

import com.mathworks.hg.peer.FigurePeer;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTable;
import com.mathworks.page.plottool.plotbrowser.ChartObjectProxyFactory;
import com.mathworks.page.plottool.plotbrowser.LegendIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class DataSourceDialog
extends MJDialog {
    protected volatile MJTable fSourceTable;
    protected MJButton fOkBtn;
    protected MJButton fApplyBtn;
    protected MJButton fCancelBtn;
    protected Object fFigure;
    private boolean fValidatingInput = false;
    private boolean fCancelling = false;
    private DataSourceDialogButtonWorker fPendingButtonWorker = null;
    private static final String resStr = "com.mathworks.page.datamgr.resources.RES_LinkedPlots";
    private static final String key = "DataSourceDialog.";
    private ResourceBundle resources = ResourceBundle.getBundle("com.mathworks.page.datamgr.resources.RES_LinkedPlots");
    private static int ROW_HEIGHT = 22;
    private static int PRIMARY_COL_WIDTH = 30;

    public static SourceDialogTableEntry[][] createSourceDialogTableEntryArray(int n, int n2, String[] stringArray) {
        int n3;
        SourceDialogTableEntry[][] sourceDialogTableEntryArray = new SourceDialogTableEntry[n][n2];
        Vector<String> vector = new Vector<String>();
        vector.add(" ");
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            n3 = stringArray2.length;
            for (int i = 0; i < n3; ++i) {
                String string = stringArray2[i];
                vector.add(string);
            }
        }
        for (int i = 0; i < n; ++i) {
            for (n3 = 0; n3 < n2; ++n3) {
                sourceDialogTableEntryArray[i][n3] = new SourceDialogTableEntry(vector);
            }
        }
        return sourceDialogTableEntryArray;
    }

    public static SourceDialogTableEntry[][] createSourceDialogTableEntryArray(int n, int n2) {
        SourceDialogTableEntry[][] sourceDialogTableEntryArray = new SourceDialogTableEntry[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                sourceDialogTableEntryArray[i][j] = new SourceDialogTableEntry();
            }
        }
        return sourceDialogTableEntryArray;
    }

    public DataSourceDialog(Object object, FigurePeer figurePeer, String string, String string2, ChartObjectProxyFactory.SeriesProxy[] seriesProxyArray, String[] stringArray, SourceDialogTableEntry[][] sourceDialogTableEntryArray) {
        super((Frame)MJFrame.getFrame((Component)figurePeer.getAxisComponent()), "", true);
        this.setTitle(string);
        this.setLocationRelativeTo((Component)MJFrame.getFrame((Component)figurePeer.getAxisComponent()));
        this.fFigure = object;
        this.setName("DataSourceDialog");
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        mJPanel.add((Component)new MJLabel(string2), (Object)"West");
        Object[][] objectArray = this.makeTableData(seriesProxyArray, stringArray, sourceDialogTableEntryArray);
        this.fSourceTable = new MJTable((TableModel)new IconTableModel(objectArray, new String[]{" ", "DisplayName", "XDataSource", "YDataSource", "ZDataSource"}));
        this.fSourceTable.setSelectionMode(0);
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fSourceTable);
        this.setupTable();
        this.fSourceTable.setName("DataSource.Table");
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new BorderLayout(5, 5));
        mJPanel2.add((Component)mJScrollPane, (Object)"Center");
        mJPanel2.add((Component)mJPanel, (Object)"North");
        mJPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.fOkBtn = new MJButton(this.resources.getString("DataSourceDialog.OK"));
        this.fOkBtn.setName("DataSource.OK");
        this.fOkBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                if (DataSourceDialog.this.fSourceTable.isEditing()) {
                    object = DataSourceDialog.this.fSourceTable.getCellEditor();
                    object.stopCellEditing();
                }
                object = new DataSourceDialogButtonWorker(true, "ok");
                if (!DataSourceDialog.this.fValidatingInput) {
                    DataSourceDialog.this.fOkBtn.setEnabled(false);
                    DataSourceDialog.this.fApplyBtn.setEnabled(false);
                    object.start();
                } else {
                    DataSourceDialog.this.fPendingButtonWorker = (DataSourceDialogButtonWorker)((Object)object);
                }
            }
        });
        this.fApplyBtn = new MJButton(this.resources.getString("DataSourceDialog.Apply"));
        this.fApplyBtn.setName("DataSource.Apply");
        this.fApplyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                if (DataSourceDialog.this.fSourceTable.isEditing()) {
                    object = DataSourceDialog.this.fSourceTable.getCellEditor();
                    object.stopCellEditing();
                }
                object = new DataSourceDialogButtonWorker(false, "ok");
                if (!DataSourceDialog.this.fValidatingInput) {
                    DataSourceDialog.this.fOkBtn.setEnabled(false);
                    DataSourceDialog.this.fApplyBtn.setEnabled(false);
                    object.start();
                } else {
                    DataSourceDialog.this.fPendingButtonWorker = (DataSourceDialogButtonWorker)((Object)object);
                }
            }
        });
        this.fCancelBtn = new MJButton(this.resources.getString("DataSourceDialog.Cancel"));
        this.fCancelBtn.setName("DataSource.Cancel");
        this.fCancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                if (DataSourceDialog.this.fSourceTable.isEditing()) {
                    object = DataSourceDialog.this.fSourceTable.getCellEditor();
                    object.cancelCellEditing();
                }
                DataSourceDialog.this.fCancelling = true;
                object = new DataSourceDialogButtonWorker(true, "cancel");
                object.start();
            }
        });
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new BorderLayout(5, 5));
        MJPanel mJPanel4 = new MJPanel();
        mJPanel4.add((Component)this.fOkBtn);
        mJPanel4.add((Component)this.fCancelBtn);
        mJPanel4.add((Component)this.fApplyBtn);
        mJPanel3.add((Component)mJPanel4, (Object)"East");
        this.getContentPane().add((Component)mJPanel2, "Center");
        this.getContentPane().add((Component)mJPanel3, "South");
        this.setSize(new Dimension(438, 204));
    }

    private Object[][] makeTableData(ChartObjectProxyFactory.SeriesProxy[] seriesProxyArray, String[] stringArray, SourceDialogTableEntry[][] sourceDialogTableEntryArray) {
        Object[][] objectArray = new Object[stringArray.length][5];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i][0] = seriesProxyArray[i];
            objectArray[i][1] = stringArray[i];
            for (int j = 2; j < 5; ++j) {
                objectArray[i][j] = sourceDialogTableEntryArray[i][j - 2];
            }
        }
        return objectArray;
    }

    private void validateCellEditInMATLAB(final String string) {
        this.fValidatingInput = true;
        final int n = this.fSourceTable.getEditingRow();
        final int n2 = this.fSourceTable.getEditingColumn();
        if (n == -1 || n2 < 2) {
            this.fValidatingInput = false;
            return;
        }
        final String string2 = this.fSourceTable.getValueAt(n, n2).toString().trim();
        if (string == null || string.length() == 0) {
            this.fValidatingInput = false;
            return;
        }
        if (string.length() > 0 && !string.equals(string2)) {
            MatlabWorker matlabWorker = new MatlabWorker(){

                public void runOnAWTEventDispatchThread(Object object) {
                    if (object instanceof String) {
                        DataSourceDialog.this.utSetValueAt((String)object, n, 1);
                        if (DataSourceDialog.this.fPendingButtonWorker != null) {
                            DataSourceDialog.this.fOkBtn.setEnabled(false);
                            DataSourceDialog.this.fApplyBtn.setEnabled(false);
                            DataSourceDialog.this.fValidatingInput = false;
                            DataSourceDialog.this.fPendingButtonWorker.start();
                            DataSourceDialog.this.fPendingButtonWorker = null;
                        } else {
                            DataSourceDialog.this.fValidatingInput = false;
                        }
                    } else {
                        DataSourceDialog.this.openMsgDialog(string + " " + DataSourceDialog.this.resources.getString("DataSourceDialog.InvSourceMsg"), n, n2, string2);
                        DataSourceDialog.this.fPendingButtonWorker = null;
                        DataSourceDialog.this.fValidatingInput = false;
                    }
                }

                public Object runOnMatlabThread() {
                    Object[] objectArray = new Object[]{DataSourceDialog.this.fFigure, "edit", n, n2, string, DataSourceDialog.this};
                    try {
                        return Matlab.mtFeval((String)"datamanager.sourceDialogBuilder", (Object[])objectArray, (int)0);
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
            };
            matlabWorker.start();
        } else {
            this.fValidatingInput = false;
        }
    }

    private void init(ChartObjectProxyFactory.SeriesProxy[] seriesProxyArray, String[] stringArray, SourceDialogTableEntry[][] sourceDialogTableEntryArray) {
        this.fSourceTable.setModel((TableModel)new IconTableModel(this.makeTableData(seriesProxyArray, stringArray, sourceDialogTableEntryArray), new String[]{" ", "DisplayName", "XDataSource", "YDataSource", "ZDataSource"}));
        this.setupTable();
        this.setVisible(true);
    }

    private void setupTable() {
        this.fSourceTable.getColumnModel().getColumn(0).setMaxWidth(PRIMARY_COL_WIDTH);
        this.fSourceTable.getColumnModel().getColumn(0).setCellEditor(null);
        this.fSourceTable.getColumnModel().getColumn(0).setCellRenderer(new IconRenderer());
        this.fSourceTable.getColumnModel().getColumn(2).setCellRenderer(new ComboCellRenderer());
        this.fSourceTable.getColumnModel().getColumn(3).setCellRenderer(new ComboCellRenderer());
        this.fSourceTable.getColumnModel().getColumn(4).setCellRenderer(new ComboCellRenderer());
        DataSourceComboBoxEditor dataSourceComboBoxEditor = new DataSourceComboBoxEditor(this);
        for (int i = 2; i < 5; ++i) {
            this.fSourceTable.getColumnModel().getColumn(i).setCellEditor(dataSourceComboBoxEditor);
        }
        this.fSourceTable.setRowHeight(ROW_HEIGHT);
    }

    private void utSetValueAt(String string, int n, int n2) {
        Object object = this.fSourceTable.getValueAt(n, n2);
        if (object instanceof SourceDialogTableEntry) {
            ((SourceDialogTableEntry)object).setCurrentValue(string);
            this.fSourceTable.setValueAt(object, n, n2);
        } else {
            this.fSourceTable.setValueAt((Object)string, n, n2);
        }
    }

    public ListSelectionModel getSelectionModel() {
        return this.fSourceTable.getSelectionModel();
    }

    public void initialize(final ChartObjectProxyFactory.SeriesProxy[] seriesProxyArray, final String[] stringArray, final SourceDialogTableEntry[][] sourceDialogTableEntryArray) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.init(seriesProxyArray, stringArray, sourceDialogTableEntryArray);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DataSourceDialog.this.init(seriesProxyArray, stringArray, sourceDialogTableEntryArray);
                }
            });
        }
    }

    public Object[][] getTableData() {
        Object[][] objectArray = new String[this.fSourceTable.getRowCount()][this.fSourceTable.getColumnCount()];
        for (int i = 0; i < this.fSourceTable.getRowCount(); ++i) {
            for (int j = 0; j < this.fSourceTable.getColumnCount(); ++j) {
                Object object = this.fSourceTable.getValueAt(i, j);
                objectArray[i][j] = object != null ? this.fSourceTable.getValueAt(i, j).toString() : null;
            }
        }
        return objectArray;
    }

    private void openMsgDialog(String string, int n, int n2, String string2) {
        MJOptionPane.showMessageDialog((Component)((Object)this), (Object)string, (String)this.resources.getString("DataSourceDialog.Error"), (int)0);
        this.fSourceTable.setValueAt((Object)string2, n, n2);
        this.fSourceTable.repaint();
    }

    static class DataSourceComboBoxEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JComboBox iComboBox;
        private DataSourceDialog iDataSourceDialog;

        public DataSourceComboBoxEditor(DataSourceDialog dataSourceDialog) {
            this.iDataSourceDialog = dataSourceDialog;
            this.iComboBox = new JComboBox();
            this.iComboBox.setEditable(true);
            this.iComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DataSourceComboBoxEditor.this.stopCellEditing();
                }
            });
        }

        boolean superStopCellEditing() {
            return super.stopCellEditing();
        }

        @Override
        public boolean stopCellEditing() {
            if (this.iDataSourceDialog.fCancelling || this.iDataSourceDialog.fValidatingInput) {
                this.fireEditingStopped();
                return false;
            }
            this.iDataSourceDialog.validateCellEditInMATLAB(this.getCellEditorValue().toString().trim());
            return super.stopCellEditing();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object instanceof SourceDialogTableEntry) {
                SourceDialogTableEntry sourceDialogTableEntry = (SourceDialogTableEntry)object;
                this.iComboBox.setModel(new DefaultComboBoxModel<String>(sourceDialogTableEntry.getContentVector()));
                this.iComboBox.setSelectedItem(object);
            } else {
                this.iComboBox.removeAllItems();
            }
            return this.iComboBox;
        }

        @Override
        public Object getCellEditorValue() {
            String string = ((JTextField)this.iComboBox.getEditor().getEditorComponent()).getText();
            if (string == null) {
                return this.iComboBox.getSelectedItem();
            }
            return string;
        }
    }

    static class SourceDialogTableEntry {
        protected String fCurrentValue = "";
        protected Vector<String> fContents = new Vector();

        public SourceDialogTableEntry() {
        }

        public SourceDialogTableEntry(String[] stringArray) {
            this.setContent(stringArray);
        }

        public SourceDialogTableEntry(Vector<String> vector) {
            this.fContents = vector;
        }

        public void setCurrentValue(String string) {
            this.fCurrentValue = string;
        }

        public Vector<String> getContentVector() {
            return this.fContents;
        }

        public void setContent(String[] stringArray) {
            for (String string : stringArray) {
                this.fContents.add(string);
            }
        }

        public String toString() {
            return this.fCurrentValue;
        }

        public boolean isEditable() {
            return this.fContents != null && this.fContents.size() > 0;
        }
    }

    class DataSourceDialogButtonWorker
    extends MatlabWorker {
        private Boolean fCloseOnSuccess = true;
        private String fActionString;

        public DataSourceDialogButtonWorker(boolean bl, String string) {
            this.fCloseOnSuccess = bl;
            this.fActionString = string;
        }

        public Object runOnMatlabThread() throws Exception {
            Boolean bl;
            try {
                Matlab.mtFeval((String)"datamanager.sourceDialogBuilder", (Object[])new Object[]{DataSourceDialog.this.fFigure, this.fActionString, DataSourceDialog.this}, (int)0);
                bl = this.fCloseOnSuccess;
            }
            catch (Exception exception) {
                return true;
            }
            return bl;
        }

        public void runOnAWTEventDispatchThread(Object object) {
            DataSourceDialog.this.fOkBtn.setEnabled(true);
            DataSourceDialog.this.fApplyBtn.setEnabled(true);
            if (((Boolean)object).booleanValue()) {
                DataSourceDialog.this.setVisible(false);
            }
            DataSourceDialog.this.fCancelling = false;
        }
    }

    private class IconTableModel
    extends DefaultTableModel {
        public IconTableModel(Object[][] objectArray, Object[] objectArray2) {
            super(objectArray, objectArray2);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0) {
                return false;
            }
            if (n2 == 1) {
                return true;
            }
            if (this.getValueAt(n, n2) instanceof SourceDialogTableEntry) {
                Object object = this.getValueAt(n, n2);
                return object != null && ((SourceDialogTableEntry)object).isEditable();
            }
            return false;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 >= 2) {
                ((SourceDialogTableEntry)this.getValueAt(n, n2)).setCurrentValue(object.toString());
            } else {
                super.setValueAt(object, n, n2);
            }
        }
    }

    private class ComboCellRenderer
    implements TableCellRenderer {
        public MJComboBox fComboBox = new MJComboBox();

        private ComboCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.fComboBox.removeAllItems();
            if (object == null) {
                this.fComboBox.setEnabled(false);
                return this.fComboBox;
            }
            this.fComboBox.setEnabled(jTable.isCellEditable(n, n2));
            this.fComboBox.addItem((Object)object.toString());
            return this.fComboBox;
        }
    }

    private class IconRenderer
    implements TableCellRenderer {
        private LegendIcon fLegendIcon = new LegendIcon();
        private MJPanel fPanel = new MJPanel();

        public IconRenderer() {
            this.fPanel.setLayout((LayoutManager)new BoxLayout((Container)this.fPanel, 1));
            this.fPanel.setOpaque(false);
            this.fPanel.add((Component)((Object)this.fLegendIcon));
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.fLegendIcon.setSeriesProxy((ChartObjectProxyFactory.SeriesProxy)object);
            return this.fPanel;
        }
    }
}

