/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.parallel.mapreduce;

import com.mathworks.toolbox.parallel.mapreduce.Endpoint;
import com.mathworks.toolbox.parallel.mapreduce.KeyValueMessage;
import com.mathworks.toolbox.parallel.mapreduce.PairSocket;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;

public final class KeyValueSocket
implements Closeable {
    private final PairSocket fSocket = new PairSocket();

    public void bind(Endpoint endpoint) throws IOException {
        try {
            this.fSocket.bind(endpoint);
        }
        catch (IOException iOException) {
            throw this.translateException(iOException);
        }
    }

    public void connect(Endpoint endpoint) throws IOException {
        try {
            this.fSocket.connect(endpoint);
        }
        catch (IOException iOException) {
            throw this.translateException(iOException);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.fSocket.close();
        }
        catch (IOException iOException) {
            throw this.translateException(iOException);
        }
    }

    public boolean isClosed() {
        return this.fSocket.isClosed();
    }

    public KeyValueMessage recv(long l, TimeUnit timeUnit) throws IOException {
        try {
            ByteBuffer byteBuffer = this.fSocket.recv(l, timeUnit);
            return byteBuffer == null ? null : new KeyValueMessage(byteBuffer);
        }
        catch (IOException iOException) {
            throw this.translateException(iOException);
        }
    }

    public boolean send(KeyValueMessage keyValueMessage, long l, TimeUnit timeUnit) throws IOException {
        try {
            return this.fSocket.send(keyValueMessage.toByteBuffer(), l, timeUnit);
        }
        catch (IOException iOException) {
            throw this.translateException(iOException);
        }
    }

    public boolean sendClose(long l, TimeUnit timeUnit) throws IOException {
        return this.send(KeyValueMessage.createCloseMessage(), l, timeUnit);
    }

    private IOException translateException(IOException iOException) throws IOException {
        try {
            throw iOException;
        }
        catch (PairSocket.AddressInUseException addressInUseException) {
            return new AddressInUseException(addressInUseException.getMessage());
        }
        catch (IOException iOException2) {
            return new OtherIOException(iOException2.getMessage());
        }
    }

    public static class OtherIOException
    extends IOException {
        public OtherIOException(String string) {
            super(string);
        }
    }

    public static class AddressInUseException
    extends IOException {
        public AddressInUseException(String string) {
            super(string);
        }
    }
}

