/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.Descriptor;
import org.eclipse.jetty.webapp.IterativeDescriptorProcessor;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.eclipse.jetty.xml.XmlParser;

public class TagLibConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(TagLibConfiguration.class);
    public static final String TLD_RESOURCES = "org.eclipse.jetty.tlds";

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
        try {
            Class jsp_page = Loader.loadClass(WebXmlConfiguration.class, "javax.servlet.jsp.JspPage");
        }
        catch (Exception e2) {
            return;
        }
        TagLibListener tagLibListener = new TagLibListener(context);
        context.addEventListener(tagLibListener);
    }

    @Override
    public void configure(WebAppContext context) throws Exception {
    }

    @Override
    public void postConfigure(WebAppContext context) throws Exception {
    }

    @Override
    public void cloneConfigure(WebAppContext template, WebAppContext context) throws Exception {
    }

    @Override
    public void deconfigure(WebAppContext context) throws Exception {
    }

    public class TldProcessor
    extends IterativeDescriptorProcessor {
        public static final String TAGLIB_PROCESSOR = "org.eclipse.jetty.tagLibProcessor";
        XmlParser _parser;
        List<XmlParser.Node> _roots = new ArrayList<XmlParser.Node>();
        List<EventListener> _listeners = new ArrayList<EventListener>();

        public TldProcessor() throws Exception {
            this.registerVisitor("listener", this.getClass().getDeclaredMethod("visitListener", __signature));
        }

        public void visitListener(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
            String className = node.getString("listener-class", false, true);
            if (LOG.isDebugEnabled()) {
                LOG.debug("listener=" + className, new Object[0]);
            }
            try {
                Class<?> listenerClass = context.loadClass(className);
                EventListener l2 = (EventListener)listenerClass.newInstance();
                this._listeners.add(l2);
            }
            catch (Exception e2) {
                LOG.warn("Could not instantiate listener " + className + ": " + e2, new Object[0]);
                LOG.debug(e2);
            }
            catch (Error e3) {
                LOG.warn("Could not instantiate listener " + className + ": " + e3, new Object[0]);
                LOG.debug(e3);
            }
        }

        @Override
        public void end(WebAppContext context, Descriptor descriptor) {
        }

        @Override
        public void start(WebAppContext context, Descriptor descriptor) {
        }

        public List<EventListener> getListeners() {
            return this._listeners;
        }
    }

    public static class TldDescriptor
    extends Descriptor {
        protected static XmlParser __parserSingleton;

        public TldDescriptor(Resource xml) {
            super(xml);
        }

        @Override
        public void ensureParser() throws ClassNotFoundException {
            if (__parserSingleton == null) {
                __parserSingleton = this.newParser();
            }
            this._parser = __parserSingleton;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public XmlParser newParser() throws ClassNotFoundException {
            XmlParser parser = new XmlParser(false);
            URL taglib11 = null;
            URL taglib12 = null;
            URL taglib20 = null;
            URL taglib21 = null;
            try {
                Class jsp_page = Loader.loadClass(WebXmlConfiguration.class, "javax.servlet.jsp.JspPage");
                taglib11 = jsp_page.getResource("javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd");
                taglib12 = jsp_page.getResource("javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd");
                taglib20 = jsp_page.getResource("javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd");
                taglib21 = jsp_page.getResource("javax/servlet/jsp/resources/web-jsptaglibrary_2_1.xsd");
            }
            catch (Exception e2) {
                LOG.ignore(e2);
            }
            finally {
                if (taglib11 == null) {
                    taglib11 = Loader.getResource(Servlet.class, "javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd", true);
                }
                if (taglib12 == null) {
                    taglib12 = Loader.getResource(Servlet.class, "javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd", true);
                }
                if (taglib20 == null) {
                    taglib20 = Loader.getResource(Servlet.class, "javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd", true);
                }
                if (taglib21 == null) {
                    taglib21 = Loader.getResource(Servlet.class, "javax/servlet/jsp/resources/web-jsptaglibrary_2_1.xsd", true);
                }
            }
            if (taglib11 != null) {
                this.redirect(parser, "web-jsptaglib_1_1.dtd", taglib11);
                this.redirect(parser, "web-jsptaglibrary_1_1.dtd", taglib11);
            }
            if (taglib12 != null) {
                this.redirect(parser, "web-jsptaglib_1_2.dtd", taglib12);
                this.redirect(parser, "web-jsptaglibrary_1_2.dtd", taglib12);
            }
            if (taglib20 != null) {
                this.redirect(parser, "web-jsptaglib_2_0.xsd", taglib20);
                this.redirect(parser, "web-jsptaglibrary_2_0.xsd", taglib20);
            }
            if (taglib21 != null) {
                this.redirect(parser, "web-jsptaglib_2_1.xsd", taglib21);
                this.redirect(parser, "web-jsptaglibrary_2_1.xsd", taglib21);
            }
            parser.setXpath("/taglib/listener/listener-class");
            return parser;
        }

        @Override
        public void parse() throws Exception {
            this.ensureParser();
            try {
                this._root = this._parser.parse(this._xml.getInputStream());
            }
            catch (Exception e2) {
                this._root = this._parser.parse(this._xml.getURL().toString());
            }
            if (this._root == null) {
                LOG.warn("No TLD root in {}", this._xml);
            }
        }
    }

    public class TagLibListener
    implements ServletContextListener {
        private List<EventListener> _tldListeners;
        private WebAppContext _context;

        public TagLibListener(WebAppContext context) {
            this._context = context;
        }

        @Override
        public void contextDestroyed(ServletContextEvent sce) {
            if (this._tldListeners == null) {
                return;
            }
            for (int i2 = this._tldListeners.size() - 1; i2 >= 0; --i2) {
                EventListener l2 = this._tldListeners.get(i2);
                if (!(l2 instanceof ServletContextListener)) continue;
                ((ServletContextListener)l2).contextDestroyed(sce);
            }
        }

        @Override
        public void contextInitialized(ServletContextEvent sce) {
            try {
                try {
                    ClassLoader loader = this._context.getClassLoader();
                    loader = loader == null || loader.getParent() == null ? this.getClass().getClassLoader() : loader.getParent();
                    Class<?> clazz = loader.loadClass("org.apache.jasper.compiler.TldLocationsCache");
                    assert (clazz != null);
                    Collection tld_resources = (Collection)this._context.getAttribute(TagLibConfiguration.TLD_RESOURCES);
                    HashMap tldMap = new HashMap();
                    if (tld_resources != null) {
                        for (Resource r : tld_resources) {
                            Resource jarResource = this.extractJarResource(r);
                            if (tldMap.containsKey(jarResource.getURI())) continue;
                            tldMap.put(jarResource.getURI(), null);
                        }
                        sce.getServletContext().setAttribute("com.sun.appserv.tld.map", tldMap);
                    }
                }
                catch (ClassNotFoundException e2) {
                    LOG.ignore(e2);
                }
                Set<Resource> tlds = this.findTldResources();
                List<TldDescriptor> descriptors = this.parseTlds(tlds);
                this.processTlds(descriptors);
                if (this._tldListeners == null) {
                    return;
                }
                for (EventListener l2 : this._tldListeners) {
                    if (l2 instanceof ServletContextListener) {
                        ((ServletContextListener)l2).contextInitialized(sce);
                        continue;
                    }
                    this._context.addEventListener(l2);
                }
            }
            catch (Exception e3) {
                LOG.warn(e3);
            }
        }

        private Resource extractJarResource(Resource r) {
            if (r == null) {
                return null;
            }
            try {
                String url = r.getURI().toURL().toString();
                int idx = url.lastIndexOf("!/");
                if (idx >= 0) {
                    url = url.substring(0, idx);
                }
                if (url.startsWith("jar:")) {
                    url = url.substring(4);
                }
                return Resource.newResource(url);
            }
            catch (IOException e2) {
                LOG.warn(e2);
                return null;
            }
        }

        private Set<Resource> findTldResources() throws IOException {
            Collection tld_resources;
            Resource web_inf_tlds;
            Resource web_inf;
            HashSet<Resource> tlds = new HashSet<Resource>();
            if (this._context.getResourceAliases() != null && this._context.getBaseResource() != null && this._context.getBaseResource().exists()) {
                for (String location : this._context.getResourceAliases().values()) {
                    if (location == null || !location.toLowerCase(Locale.ENGLISH).endsWith(".tld")) continue;
                    if (!location.startsWith("/")) {
                        location = "/WEB-INF/" + location;
                    }
                    Resource l2 = this._context.getBaseResource().addPath(location);
                    tlds.add(l2);
                }
            }
            if ((web_inf = this._context.getWebInf()) != null) {
                String[] contents = web_inf.list();
                for (int i2 = 0; contents != null && i2 < contents.length; ++i2) {
                    if (contents[i2] == null || !contents[i2].toLowerCase(Locale.ENGLISH).endsWith(".tld")) continue;
                    Resource l3 = web_inf.addPath(contents[i2]);
                    tlds.add(l3);
                }
            }
            if (web_inf != null && (web_inf_tlds = this._context.getWebInf().addPath("/tlds/")).exists() && web_inf_tlds.isDirectory()) {
                String[] contents = web_inf_tlds.list();
                for (int i3 = 0; contents != null && i3 < contents.length; ++i3) {
                    if (contents[i3] == null || !contents[i3].toLowerCase(Locale.ENGLISH).endsWith(".tld")) continue;
                    Resource l4 = web_inf_tlds.addPath(contents[i3]);
                    tlds.add(l4);
                }
            }
            if ((tld_resources = (Collection)this._context.getAttribute(TagLibConfiguration.TLD_RESOURCES)) != null) {
                tlds.addAll(tld_resources);
            }
            return tlds;
        }

        private List<TldDescriptor> parseTlds(Set<Resource> tlds) {
            ArrayList<TldDescriptor> descriptors = new ArrayList<TldDescriptor>();
            Resource tld = null;
            Iterator<Resource> iter = tlds.iterator();
            while (iter.hasNext()) {
                try {
                    tld = iter.next();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("TLD=" + tld, new Object[0]);
                    }
                    TldDescriptor d2 = new TldDescriptor(tld);
                    d2.parse();
                    descriptors.add(d2);
                }
                catch (Exception e2) {
                    LOG.warn("Unable to parse TLD: " + tld, e2);
                }
            }
            return descriptors;
        }

        private void processTlds(List<TldDescriptor> descriptors) throws Exception {
            TldProcessor processor = new TldProcessor();
            for (TldDescriptor d2 : descriptors) {
                processor.process(this._context, d2);
            }
            this._tldListeners = new ArrayList<EventListener>(processor.getListeners());
        }
    }
}

