/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

public class TarUtils {
    private static final int BYTE_MASK = 255;

    private TarUtils() {
    }

    public static long parseOctal(byte[] buffer, int offset, int length) {
        long result = 0L;
        int end = offset + length;
        int start = offset;
        if (length < 2) {
            throw new IllegalArgumentException("Length " + length + " must be at least 2");
        }
        boolean allNUL = true;
        for (int i2 = start; i2 < end; ++i2) {
            if (buffer[i2] == 0) continue;
            allNUL = false;
            break;
        }
        if (allNUL) {
            return 0L;
        }
        while (start < end && buffer[start] == 32) {
            ++start;
        }
        byte trailer = buffer[end - 1];
        if (trailer != 0 && trailer != 32) {
            throw new IllegalArgumentException(TarUtils.exceptionMessage(buffer, offset, length, end - 1, trailer));
        }
        trailer = buffer[--end - 1];
        if (trailer == 0 || trailer == 32) {
            --end;
        }
        while (start < end) {
            byte currentByte = buffer[start];
            if (currentByte < 48 || currentByte > 55) {
                throw new IllegalArgumentException(TarUtils.exceptionMessage(buffer, offset, length, start, currentByte));
            }
            result = (result << 3) + (long)(currentByte - 48);
            ++start;
        }
        return result;
    }

    private static String exceptionMessage(byte[] buffer, int offset, int length, int current, byte currentByte) {
        String string = new String(buffer, offset, length);
        string = string.replaceAll("\u0000", "{NUL}");
        String s = "Invalid byte " + currentByte + " at offset " + (current - offset) + " in '" + string + "' len=" + length;
        return s;
    }

    public static String parseName(byte[] buffer, int offset, int length) {
        byte b2;
        StringBuffer result = new StringBuffer(length);
        int end = offset + length;
        for (int i2 = offset; i2 < end && (b2 = buffer[i2]) != 0; ++i2) {
            result.append((char)(b2 & 0xFF));
        }
        return result.toString();
    }

    public static int formatNameBytes(String name, byte[] buf, int offset, int length) {
        int i2;
        for (i2 = 0; i2 < length && i2 < name.length(); ++i2) {
            buf[offset + i2] = (byte)name.charAt(i2);
        }
        while (i2 < length) {
            buf[offset + i2] = 0;
            ++i2;
        }
        return offset + length;
    }

    public static void formatUnsignedOctalString(long value, byte[] buffer, int offset, int length) {
        int remaining = length;
        --remaining;
        if (value == 0L) {
            buffer[offset + remaining--] = 48;
        } else {
            long val;
            for (val = value; remaining >= 0 && val != 0L; val >>>= 3, --remaining) {
                buffer[offset + remaining] = (byte)(48 + (byte)(val & 7L));
            }
            if (val != 0L) {
                throw new IllegalArgumentException(value + "=" + Long.toOctalString(value) + " will not fit in octal number buffer of length " + length);
            }
        }
        while (remaining >= 0) {
            buffer[offset + remaining] = 48;
            --remaining;
        }
    }

    public static int formatOctalBytes(long value, byte[] buf, int offset, int length) {
        int idx = length - 2;
        TarUtils.formatUnsignedOctalString(value, buf, offset, idx);
        buf[offset + idx++] = 32;
        buf[offset + idx] = 0;
        return offset + length;
    }

    public static int formatLongOctalBytes(long value, byte[] buf, int offset, int length) {
        int idx = length - 1;
        TarUtils.formatUnsignedOctalString(value, buf, offset, idx);
        buf[offset + idx] = 32;
        return offset + length;
    }

    public static int formatCheckSumOctalBytes(long value, byte[] buf, int offset, int length) {
        int idx = length - 2;
        TarUtils.formatUnsignedOctalString(value, buf, offset, idx);
        buf[offset + idx++] = 0;
        buf[offset + idx] = 32;
        return offset + length;
    }

    public static long computeCheckSum(byte[] buf) {
        long sum = 0L;
        for (int i2 = 0; i2 < buf.length; ++i2) {
            sum += (long)(0xFF & buf[i2]);
        }
        return sum;
    }
}

