/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.BadCommandException;
import com.sun.mail.iap.CommandFailedException;
import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.iap.ResponseHandler;
import com.sun.mail.imap.ACL;
import com.sun.mail.imap.AppendUID;
import com.sun.mail.imap.DefaultFolder;
import com.sun.mail.imap.IMAPMessage;
import com.sun.mail.imap.IMAPStore;
import com.sun.mail.imap.MessageLiteral;
import com.sun.mail.imap.Rights;
import com.sun.mail.imap.Utility;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.imap.protocol.IMAPResponse;
import com.sun.mail.imap.protocol.ListInfo;
import com.sun.mail.imap.protocol.MailboxInfo;
import com.sun.mail.imap.protocol.MessageSet;
import com.sun.mail.imap.protocol.Status;
import com.sun.mail.imap.protocol.UID;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.FolderNotFoundException;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.Quota;
import javax.mail.ReadOnlyFolderException;
import javax.mail.StoreClosedException;
import javax.mail.UIDFolder;
import javax.mail.internet.MimeMessage;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchException;
import javax.mail.search.SearchTerm;

public class IMAPFolder
extends Folder
implements UIDFolder,
ResponseHandler {
    protected String fullName;
    protected String name;
    protected int type;
    protected char separator;
    protected Flags availableFlags;
    protected Flags permanentFlags;
    protected boolean exists = false;
    protected boolean isNamespace = false;
    protected String[] attributes;
    protected IMAPProtocol protocol;
    protected Vector messageCache;
    protected Object messageCacheLock;
    protected Hashtable uidTable;
    protected static final char UNKNOWN_SEPARATOR = '\uffff';
    private boolean opened = false;
    private boolean reallyClosed = true;
    private int total = -1;
    private int recent = -1;
    private int realTotal = -1;
    private int uidvalidity = -1;
    private int uidnext = -1;
    private boolean doExpungeNotification = true;
    private Status cachedStatus = null;
    private long cachedStatusTime = 0L;
    private boolean debug = false;
    private PrintStream out;
    private boolean connectionPoolDebug;

    protected IMAPFolder(String fullName, char separator, IMAPStore store) {
        this(fullName, separator, store, false);
    }

    protected IMAPFolder(String fullName, char separator, IMAPStore store, boolean isNamespace) {
        super(store);
        if (fullName == null) {
            throw new NullPointerException("Folder name is null");
        }
        this.fullName = fullName;
        this.separator = separator;
        this.isNamespace = isNamespace;
        this.messageCacheLock = new Object();
        this.debug = store.getSession().getDebug();
        this.connectionPoolDebug = store.getConnectionPoolDebug();
        this.out = store.getSession().getDebugOut();
        if (this.out == null) {
            this.out = System.out;
        }
    }

    protected IMAPFolder(ListInfo li, IMAPStore store) {
        this(li.name, li.separator, store);
        if (li.hasInferiors) {
            this.type |= 2;
        }
        if (li.canOpen) {
            this.type |= 1;
        }
        this.exists = true;
        this.attributes = li.attrs;
    }

    private void checkExists() throws MessagingException {
        if (!this.exists && !this.exists()) {
            throw new FolderNotFoundException(this, this.fullName + " not found");
        }
    }

    private void checkClosed() {
        if (this.opened) {
            throw new IllegalStateException("This operation is not allowed on an open folder");
        }
    }

    private void checkOpened() throws FolderClosedException {
        if (!this.opened) {
            if (this.reallyClosed) {
                throw new IllegalStateException("This operation is not allowed on a closed folder");
            }
            throw new FolderClosedException(this, "Lost folder connection to server");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRange(int msgno) throws MessagingException {
        if (msgno < 1) {
            throw new IndexOutOfBoundsException();
        }
        if (msgno <= this.total) {
            return;
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.keepConnectionAlive(false);
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException(this, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), pex);
            }
        }
        if (msgno > this.total) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void checkFlags(Flags flags) throws MessagingException {
        if (this.mode != 2) {
            throw new IllegalStateException("Cannot change flags on READ_ONLY folder: " + this.fullName);
        }
        if (!this.availableFlags.contains(flags)) {
            throw new MessagingException("These flags are not supported by this implementation");
        }
    }

    public String getName() {
        if (this.name == null) {
            try {
                this.name = this.fullName.substring(this.fullName.lastIndexOf(this.getSeparator()) + 1);
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public Folder getParent() throws MessagingException {
        char c2 = this.getSeparator();
        int index = this.fullName.lastIndexOf(c2);
        if (index != -1) {
            return new IMAPFolder(this.fullName.substring(0, index), c2, (IMAPStore)this.store);
        }
        return new DefaultFolder((IMAPStore)this.store);
    }

    public boolean exists() throws MessagingException {
        ListInfo[] li = null;
        final String lname = this.isNamespace && this.separator != '\u0000' ? this.fullName + this.separator : this.fullName;
        li = (ListInfo[])this.doCommand(new ProtocolCommand(){

            public Object doCommand(IMAPProtocol p2) throws ProtocolException {
                return p2.list("", lname);
            }
        });
        if (li != null) {
            int i2 = this.findName(li, lname);
            this.fullName = li[i2].name;
            this.separator = li[i2].separator;
            int len = this.fullName.length();
            if (this.separator != '\u0000' && len > 0 && this.fullName.charAt(len - 1) == this.separator) {
                this.fullName = this.fullName.substring(0, len - 1);
            }
            this.type = 0;
            if (li[i2].hasInferiors) {
                this.type |= 2;
            }
            if (li[i2].canOpen) {
                this.type |= 1;
            }
            this.exists = true;
            this.attributes = li[i2].attrs;
        } else {
            this.exists = false;
        }
        return this.exists;
    }

    private int findName(ListInfo[] li, String lname) {
        int i2;
        for (i2 = 0; i2 < li.length && !li[i2].name.equals(lname); ++i2) {
        }
        if (i2 >= li.length) {
            i2 = 0;
        }
        return i2;
    }

    public Folder[] list(String pattern) throws MessagingException {
        return this.doList(pattern, false);
    }

    public Folder[] listSubscribed(String pattern) throws MessagingException {
        return this.doList(pattern, true);
    }

    private Folder[] doList(final String pattern, final boolean subscribed) throws MessagingException {
        this.checkExists();
        if (!this.isDirectory()) {
            return new Folder[0];
        }
        final char c2 = this.getSeparator();
        ListInfo[] li = (ListInfo[])this.doCommandIgnoreFailure(new ProtocolCommand(){

            public Object doCommand(IMAPProtocol p2) throws ProtocolException {
                if (subscribed) {
                    return p2.lsub("", IMAPFolder.this.fullName + c2 + pattern);
                }
                return p2.list("", IMAPFolder.this.fullName + c2 + pattern);
            }
        });
        if (li == null) {
            return new Folder[0];
        }
        int start = 0;
        if (li.length > 0 && li[0].name.equals(this.fullName + c2)) {
            start = 1;
        }
        Folder[] folders = new IMAPFolder[li.length - start];
        for (int i2 = start; i2 < li.length; ++i2) {
            folders[i2 - start] = new IMAPFolder(li[i2], (IMAPStore)this.store);
        }
        return folders;
    }

    public synchronized char getSeparator() throws MessagingException {
        if (this.separator == '\uffff') {
            ListInfo[] li = null;
            li = (ListInfo[])this.doCommand(new ProtocolCommand(){

                public Object doCommand(IMAPProtocol p2) throws ProtocolException {
                    if (p2.isREV1()) {
                        return p2.list(IMAPFolder.this.fullName, "");
                    }
                    return p2.list("", IMAPFolder.this.fullName);
                }
            });
            this.separator = li != null ? li[0].separator : (char)47;
        }
        return this.separator;
    }

    public int getType() throws MessagingException {
        this.checkExists();
        return this.type;
    }

    public boolean isSubscribed() {
        ListInfo[] li = null;
        final String lname = this.isNamespace && this.separator != '\u0000' ? this.fullName + this.separator : this.fullName;
        try {
            li = (ListInfo[])this.doProtocolCommand(new ProtocolCommand(){

                public Object doCommand(IMAPProtocol p2) throws ProtocolException {
                    return p2.lsub("", lname);
                }
            });
        }
        catch (ProtocolException pex) {
            // empty catch block
        }
        if (li != null) {
            int i2 = this.findName(li, lname);
            return li[i2].canOpen;
        }
        return false;
    }

    public void setSubscribed(final boolean subscribe) throws MessagingException {
        this.doCommandIgnoreFailure(new ProtocolCommand(){

            public Object doCommand(IMAPProtocol p2) throws ProtocolException {
                if (subscribe) {
                    p2.subscribe(IMAPFolder.this.fullName);
                } else {
                    p2.unsubscribe(IMAPFolder.this.fullName);
                }
                return null;
            }
        });
    }

    public synchronized boolean create(final int type) throws MessagingException {
        char sep;
        Object ret;
        char c2 = '\u0000';
        if ((type & 1) == 0) {
            c2 = this.getSeparator();
        }
        if ((ret = this.doCommandIgnoreFailure(new ProtocolCommand(sep = c2){
            private final /* synthetic */ char val$sep;
            {
                this.val$sep = c2;
            }

            public Object doCommand(IMAPProtocol p2) throws ProtocolException {
                if ((type & 1) == 0) {
                    p2.create(IMAPFolder.this.fullName + this.val$sep);
                } else {
                    ListInfo[] li;
                    p2.create(IMAPFolder.this.fullName);
                    if ((type & 2) != 0 && (li = p2.list("", IMAPFolder.this.fullName)) != null && !li[0].hasInferiors) {
                        p2.delete(IMAPFolder.this.fullName);
                        throw new ProtocolException("Unsupported type");
                    }
                }
                return Boolean.TRUE;
            }
        })) == null) {
            return false;
        }
        boolean retb = this.exists();
        this.notifyFolderListeners(1);
        return retb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean hasNewMessages() throws MessagingException {
        this.checkExists();
        if (this.opened) {
            Object object = this.messageCacheLock;
            synchronized (object) {
                try {
                    this.keepConnectionAlive(true);
                }
                catch (ConnectionException cex) {
                    throw new FolderClosedException(this, cex.getMessage());
                }
                catch (ProtocolException pex) {
                    throw new MessagingException(pex.getMessage(), pex);
                }
            }
            return this.recent > 0;
        }
        Boolean b2 = (Boolean)this.doCommandIgnoreFailure(new ProtocolCommand(){

            public Object doCommand(IMAPProtocol p2) throws ProtocolException {
                ListInfo[] li = p2.list("", IMAPFolder.this.fullName);
                if (li != null) {
                    if (li[0].changeState == 1) {
                        return Boolean.TRUE;
                    }
                    if (li[0].changeState == 2) {
                        return Boolean.FALSE;
                    }
                }
                Status status = IMAPFolder.this.getStatus();
                if (status.recent > 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        if (b2 == null) {
            return false;
        }
        return b2;
    }

    public Folder getFolder(String name) throws MessagingException {
        if (this.exists && !this.isDirectory()) {
            throw new MessagingException("Cannot contain subfolders");
        }
        char c2 = this.getSeparator();
        return new IMAPFolder(this.fullName + c2 + name, c2, (IMAPStore)this.store);
    }

    public synchronized boolean delete(boolean recurse) throws MessagingException {
        Object ret;
        this.checkClosed();
        if (recurse) {
            Folder[] f2 = this.list();
            for (int i2 = 0; i2 < f2.length; ++i2) {
                f2[i2].delete(recurse);
            }
        }
        if ((ret = this.doCommandIgnoreFailure(new ProtocolCommand(){

            public Object doCommand(IMAPProtocol p2) throws ProtocolException {
                p2.delete(IMAPFolder.this.fullName);
                return Boolean.TRUE;
            }
        })) == null) {
            return false;
        }
        this.exists = false;
        this.notifyFolderListeners(2);
        return true;
    }

    public synchronized boolean renameTo(final Folder f2) throws MessagingException {
        this.checkClosed();
        this.checkExists();
        if (f2.getStore() != this.store) {
            throw new MessagingException("Can't rename across Stores");
        }
        Object ret = this.doCommandIgnoreFailure(new ProtocolCommand(){

            public Object doCommand(IMAPProtocol p2) throws ProtocolException {
                p2.rename(IMAPFolder.this.fullName, f2.getFullName());
                return Boolean.TRUE;
            }
        });
        if (ret == null) {
            return false;
        }
        this.exists = false;
        this.notifyFolderRenamedListeners(f2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void open(int mode) throws MessagingException {
        CommandFailedException exc;
        block24: {
            this.checkClosed();
            MailboxInfo mi = null;
            this.protocol = ((IMAPStore)this.store).getProtocol(this);
            exc = null;
            Object object = this.messageCacheLock;
            synchronized (object) {
                this.protocol.addResponseHandler(this);
                try {
                    mi = mode == 1 ? this.protocol.examine(this.fullName) : this.protocol.select(this.fullName);
                }
                catch (CommandFailedException cex) {
                    this.releaseProtocol(true);
                    this.protocol = null;
                    exc = cex;
                    break block24;
                }
                catch (ProtocolException pex) {
                    try {
                        this.protocol.logout();
                    }
                    catch (ProtocolException pex2) {}
                    finally {
                        this.releaseProtocol(false);
                        this.protocol = null;
                        throw new MessagingException(pex.getMessage(), pex);
                    }
                }
                if (!(mi.mode == mode || mode == 2 && mi.mode == 1 && ((IMAPStore)this.store).allowReadOnlySelect())) {
                    try {
                        this.protocol.close();
                        this.releaseProtocol(true);
                    }
                    catch (ProtocolException pex) {
                        try {
                            this.protocol.logout();
                            this.releaseProtocol(false);
                        }
                        catch (ProtocolException pex2) {
                            this.releaseProtocol(false);
                            catch (Throwable throwable) {
                                this.releaseProtocol(false);
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        this.protocol = null;
                        throw new ReadOnlyFolderException(this, "Cannot open in desired mode");
                    }
                }
                this.opened = true;
                this.reallyClosed = false;
                this.mode = mi.mode;
                this.availableFlags = mi.availableFlags;
                this.permanentFlags = mi.permanentFlags;
                this.total = this.realTotal = mi.total;
                this.recent = mi.recent;
                this.uidvalidity = mi.uidvalidity;
                this.uidnext = mi.uidnext;
                this.messageCache = new Vector(this.total);
                for (int i2 = 0; i2 < this.total; ++i2) {
                    this.messageCache.addElement(new IMAPMessage(this, i2 + 1, i2 + 1));
                }
            }
        }
        if (exc != null) {
            this.checkExists();
            if ((this.type & 1) == 0) {
                throw new MessagingException("folder cannot contain messages");
            }
            throw new MessagingException(exc.getMessage(), exc);
        }
        this.notifyConnectionListeners(1);
    }

    public synchronized void fetch(Message[] msgs, FetchProfile fp) throws MessagingException {
        this.checkOpened();
        IMAPMessage.fetch(this, msgs, fp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setFlags(Message[] msgs, Flags flag, boolean value) throws MessagingException {
        this.checkOpened();
        this.checkFlags(flag);
        if (msgs.length == 0) {
            return;
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                MessageSet[] ms = Utility.toMessageSet(msgs, null);
                if (ms == null) {
                    throw new MessageRemovedException("Messages have been removed");
                }
                this.protocol.storeFlags(ms, flag, value);
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException(this, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), pex);
            }
        }
    }

    public synchronized void close(boolean expunge) throws MessagingException {
        this.close(expunge, false);
    }

    public synchronized void forceClose() throws MessagingException {
        this.close(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean expunge, boolean force) throws MessagingException {
        Object object = this.messageCacheLock;
        synchronized (object) {
            block22: {
                if (!this.opened && this.reallyClosed) {
                    throw new IllegalStateException("This operation is not allowed on a closed folder");
                }
                this.reallyClosed = true;
                if (!this.opened) {
                    return;
                }
                try {
                    block23: {
                        if (force) {
                            if (this.debug) {
                                this.out.println("DEBUG: forcing folder " + this.fullName + " to close");
                            }
                            if (this.protocol != null) {
                                this.protocol.disconnect();
                            }
                            break block22;
                        }
                        if (((IMAPStore)this.store).isConnectionPoolFull()) {
                            if (this.debug) {
                                this.out.println("DEBUG: pool is full, not adding an Authenticated connection");
                            }
                            if (expunge) {
                                this.protocol.close();
                            }
                            if (this.protocol != null) {
                                this.protocol.logout();
                            }
                            break block22;
                        }
                        if (!expunge && this.mode == 2) {
                            try {
                                MailboxInfo mi = this.protocol.examine(this.fullName);
                            }
                            catch (ProtocolException pex2) {
                                if (this.protocol == null) break block23;
                                this.protocol.disconnect();
                            }
                        }
                    }
                    if (this.protocol != null) {
                        this.protocol.close();
                    }
                }
                catch (ProtocolException pex) {
                    throw new MessagingException(pex.getMessage(), pex);
                }
                finally {
                    if (this.opened) {
                        this.cleanup(true);
                    }
                }
            }
        }
    }

    private void cleanup(boolean returnToPool) {
        this.releaseProtocol(returnToPool);
        this.protocol = null;
        this.messageCache = null;
        this.uidTable = null;
        this.exists = false;
        this.opened = false;
        this.notifyConnectionListeners(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isOpen() {
        Object object = this.messageCacheLock;
        synchronized (object) {
            if (this.opened) {
                try {
                    this.keepConnectionAlive(false);
                }
                catch (ProtocolException protocolException) {
                    // empty catch block
                }
            }
        }
        return this.opened;
    }

    public Flags getPermanentFlags() {
        return this.permanentFlags;
    }

    public synchronized int getMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            try {
                Status status = this.getStatus();
                return status.total;
            }
            catch (BadCommandException bex) {
                IMAPProtocol p2 = null;
                try {
                    p2 = this.getStoreProtocol();
                    MailboxInfo minfo = p2.examine(this.fullName);
                    p2.close();
                    int n2 = minfo.total;
                    return n2;
                }
                catch (ProtocolException pex) {
                    throw new MessagingException(pex.getMessage(), pex);
                }
                finally {
                    this.releaseStoreProtocol(p2);
                }
            }
            catch (ConnectionException cex) {
                throw new StoreClosedException(this.store, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), pex);
            }
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.keepConnectionAlive(true);
                return this.total;
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException(this, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), pex);
            }
        }
    }

    public synchronized int getNewMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            try {
                Status status = this.getStatus();
                return status.recent;
            }
            catch (BadCommandException bex) {
                IMAPProtocol p2 = null;
                try {
                    p2 = this.getStoreProtocol();
                    MailboxInfo minfo = p2.examine(this.fullName);
                    p2.close();
                    int n2 = minfo.recent;
                    return n2;
                }
                catch (ProtocolException pex) {
                    throw new MessagingException(pex.getMessage(), pex);
                }
                finally {
                    this.releaseStoreProtocol(p2);
                }
            }
            catch (ConnectionException cex) {
                throw new StoreClosedException(this.store, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), pex);
            }
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.keepConnectionAlive(true);
                return this.recent;
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException(this, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), pex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getUnreadMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            try {
                Status status = this.getStatus();
                return status.unseen;
            }
            catch (BadCommandException bex) {
                return -1;
            }
            catch (ConnectionException cex) {
                throw new StoreClosedException(this.store, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), pex);
            }
        }
        Flags f2 = new Flags();
        f2.add(Flags.Flag.SEEN);
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] matches = this.protocol.search(new FlagTerm(f2, false));
                return matches.length;
            }
        }
        catch (ConnectionException cex) {
            throw new FolderClosedException(this, cex.getMessage());
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), pex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getDeletedMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            return -1;
        }
        Flags f2 = new Flags();
        f2.add(Flags.Flag.DELETED);
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] matches = this.protocol.search(new FlagTerm(f2, true));
                return matches.length;
            }
        }
        catch (ConnectionException cex) {
            throw new FolderClosedException(this, cex.getMessage());
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), pex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status getStatus() throws ProtocolException {
        int statusCacheTimeout = ((IMAPStore)this.store).getStatusCacheTimeout();
        if (statusCacheTimeout > 0 && this.cachedStatus != null && System.currentTimeMillis() - this.cachedStatusTime < (long)statusCacheTimeout) {
            return this.cachedStatus;
        }
        IMAPProtocol p2 = null;
        try {
            p2 = this.getStoreProtocol();
            Status s = p2.status(this.fullName, null);
            if (statusCacheTimeout > 0) {
                this.cachedStatus = s;
                this.cachedStatusTime = System.currentTimeMillis();
            }
            Status status = s;
            return status;
        }
        finally {
            this.releaseStoreProtocol(p2);
        }
    }

    public synchronized Message getMessage(int msgnum) throws MessagingException {
        this.checkOpened();
        this.checkRange(msgnum);
        return (Message)this.messageCache.elementAt(msgnum - 1);
    }

    public void appendMessages(Message[] msgs) throws MessagingException {
        this.checkExists();
        int maxsize = ((IMAPStore)this.store).getAppendBufferSize();
        for (int i2 = 0; i2 < msgs.length; ++i2) {
            MessageLiteral mos;
            Message m2 = msgs[i2];
            try {
                mos = new MessageLiteral(m2, m2.getSize() > maxsize ? 0 : maxsize);
            }
            catch (IOException ex) {
                throw new MessagingException("IOException while appending messages", ex);
            }
            catch (MessageRemovedException mrex) {
                continue;
            }
            Date d2 = m2.getReceivedDate();
            if (d2 == null) {
                d2 = m2.getSentDate();
            }
            final Date dd = d2;
            final Flags f2 = m2.getFlags();
            this.doCommand(new ProtocolCommand(){

                public Object doCommand(IMAPProtocol p2) throws ProtocolException {
                    p2.append(IMAPFolder.this.fullName, f2, dd, mos);
                    return null;
                }
            });
        }
    }

    public AppendUID[] appendUIDMessages(Message[] msgs) throws MessagingException {
        this.checkExists();
        int maxsize = ((IMAPStore)this.store).getAppendBufferSize();
        AppendUID[] uids = new AppendUID[msgs.length];
        for (int i2 = 0; i2 < msgs.length; ++i2) {
            AppendUID auid;
            MessageLiteral mos;
            Message m2 = msgs[i2];
            try {
                mos = new MessageLiteral(m2, m2.getSize() > maxsize ? 0 : maxsize);
            }
            catch (IOException ex) {
                throw new MessagingException("IOException while appending messages", ex);
            }
            catch (MessageRemovedException mrex) {
                continue;
            }
            Date d2 = m2.getReceivedDate();
            if (d2 == null) {
                d2 = m2.getSentDate();
            }
            final Date dd = d2;
            final Flags f2 = m2.getFlags();
            uids[i2] = auid = (AppendUID)this.doCommand(new ProtocolCommand(){

                public Object doCommand(IMAPProtocol p2) throws ProtocolException {
                    return p2.appenduid(IMAPFolder.this.fullName, f2, dd, mos);
                }
            });
        }
        return uids;
    }

    public Message[] addMessages(Message[] msgs) throws MessagingException {
        this.checkOpened();
        Message[] rmsgs = new MimeMessage[msgs.length];
        AppendUID[] uids = this.appendUIDMessages(msgs);
        for (int i2 = 0; i2 < uids.length; ++i2) {
            AppendUID auid = uids[i2];
            if (auid == null || auid.uidvalidity != (long)this.uidvalidity) continue;
            try {
                rmsgs[i2] = this.getMessageByUID(auid.uid);
                continue;
            }
            catch (MessagingException mex) {
                // empty catch block
            }
        }
        return rmsgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void copyMessages(Message[] msgs, Folder folder) throws MessagingException {
        this.checkOpened();
        if (msgs.length == 0) {
            return;
        }
        if (folder.getStore() == this.store) {
            Object object = this.messageCacheLock;
            synchronized (object) {
                try {
                    MessageSet[] ms = Utility.toMessageSet(msgs, null);
                    if (ms == null) {
                        throw new MessageRemovedException("Messages have been removed");
                    }
                    this.protocol.copy(ms, folder.getFullName());
                }
                catch (CommandFailedException cfx) {
                    if (cfx.getMessage().indexOf("TRYCREATE") != -1) {
                        throw new FolderNotFoundException(folder, folder.getFullName() + " does not exist");
                    }
                    throw new MessagingException(cfx.getMessage(), cfx);
                }
                catch (ConnectionException cex) {
                    throw new FolderClosedException(this, cex.getMessage());
                }
                catch (ProtocolException pex) {
                    throw new MessagingException(pex.getMessage(), pex);
                }
            }
        }
        super.copyMessages(msgs, folder);
    }

    public synchronized Message[] expunge() throws MessagingException {
        return this.expunge(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] expunge(Message[] msgs) throws MessagingException {
        Object fp;
        this.checkOpened();
        Vector<IMAPMessage> v = new Vector<IMAPMessage>();
        if (msgs != null) {
            fp = new FetchProfile();
            ((FetchProfile)fp).add(UIDFolder.FetchProfileItem.UID);
            this.fetch(msgs, (FetchProfile)fp);
        }
        fp = this.messageCacheLock;
        synchronized (fp) {
            this.doExpungeNotification = false;
            try {
                if (msgs != null) {
                    this.protocol.uidexpunge(Utility.toUIDSet(msgs));
                } else {
                    this.protocol.expunge();
                }
            }
            catch (CommandFailedException cfx) {
                if (this.mode != 2) {
                    throw new IllegalStateException("Cannot expunge READ_ONLY folder: " + this.fullName);
                }
                throw new MessagingException(cfx.getMessage(), cfx);
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException(this, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), pex);
            }
            finally {
                this.doExpungeNotification = true;
            }
            int i2 = 0;
            while (i2 < this.messageCache.size()) {
                IMAPMessage m2 = (IMAPMessage)this.messageCache.elementAt(i2);
                if (m2.isExpunged()) {
                    long uid;
                    v.addElement(m2);
                    this.messageCache.removeElementAt(i2);
                    if (this.uidTable == null || (uid = m2.getUID()) == -1L) continue;
                    this.uidTable.remove(new Long(uid));
                    continue;
                }
                m2.setMessageNumber(m2.getSequenceNumber());
                ++i2;
            }
        }
        this.total = this.messageCache.size();
        Object[] rmsgs = new Message[v.size()];
        v.copyInto(rmsgs);
        if (rmsgs.length > 0) {
            this.notifyMessageRemovedListeners(true, (Message[])rmsgs);
        }
        return rmsgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] search(SearchTerm term) throws MessagingException {
        this.checkOpened();
        try {
            Message[] matchMsgs = null;
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] matches = this.protocol.search(term);
                if (matches != null) {
                    matchMsgs = new IMAPMessage[matches.length];
                    for (int i2 = 0; i2 < matches.length; ++i2) {
                        matchMsgs[i2] = this.getMessageBySeqNumber(matches[i2]);
                    }
                }
            }
            return matchMsgs;
        }
        catch (CommandFailedException cfx) {
            return super.search(term);
        }
        catch (SearchException sex) {
            return super.search(term);
        }
        catch (ConnectionException cex) {
            throw new FolderClosedException(this, cex.getMessage());
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), pex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] search(SearchTerm term, Message[] msgs) throws MessagingException {
        this.checkOpened();
        if (msgs.length == 0) {
            return msgs;
        }
        try {
            Message[] matchMsgs = null;
            Object object = this.messageCacheLock;
            synchronized (object) {
                MessageSet[] ms = Utility.toMessageSet(msgs, null);
                if (ms == null) {
                    throw new MessageRemovedException("Messages have been removed");
                }
                int[] matches = this.protocol.search(ms, term);
                if (matches != null) {
                    matchMsgs = new IMAPMessage[matches.length];
                    for (int i2 = 0; i2 < matches.length; ++i2) {
                        matchMsgs[i2] = this.getMessageBySeqNumber(matches[i2]);
                    }
                }
            }
            return matchMsgs;
        }
        catch (CommandFailedException cfx) {
            return super.search(term, msgs);
        }
        catch (SearchException sex) {
            return super.search(term, msgs);
        }
        catch (ConnectionException cex) {
            throw new FolderClosedException(this, cex.getMessage());
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), pex);
        }
    }

    public synchronized long getUIDValidity() throws MessagingException {
        if (this.opened) {
            return this.uidvalidity;
        }
        IMAPProtocol p2 = null;
        Status status = null;
        try {
            p2 = this.getStoreProtocol();
            String[] item = new String[]{"UIDVALIDITY"};
            status = p2.status(this.fullName, item);
        }
        catch (BadCommandException bex) {
            throw new MessagingException("Cannot obtain UIDValidity", bex);
        }
        catch (ConnectionException cex) {
            this.throwClosedException(cex);
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), pex);
        }
        finally {
            this.releaseStoreProtocol(p2);
        }
        return status.uidvalidity;
    }

    public synchronized long getUIDNext() throws MessagingException {
        if (this.opened) {
            return this.uidnext;
        }
        IMAPProtocol p2 = null;
        Status status = null;
        try {
            p2 = this.getStoreProtocol();
            String[] item = new String[]{"UIDNEXT"};
            status = p2.status(this.fullName, item);
        }
        catch (BadCommandException bex) {
            throw new MessagingException("Cannot obtain UIDNext", bex);
        }
        catch (ConnectionException cex) {
            this.throwClosedException(cex);
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), pex);
        }
        finally {
            this.releaseStoreProtocol(p2);
        }
        return status.uidnext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message getMessageByUID(long uid) throws MessagingException {
        this.checkOpened();
        Long l2 = new Long(uid);
        IMAPMessage m2 = null;
        if (this.uidTable != null) {
            m2 = (IMAPMessage)this.uidTable.get(l2);
            if (m2 != null) {
                return m2;
            }
        } else {
            this.uidTable = new Hashtable();
        }
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                UID u = this.protocol.fetchSequenceNumber(uid);
                if (u != null && u.msgno <= this.total) {
                    m2 = (IMAPMessage)this.messageCache.elementAt(u.msgno - 1);
                    m2.setUID(u.uid);
                    this.uidTable.put(l2, m2);
                }
            }
        }
        catch (ConnectionException cex) {
            throw new FolderClosedException(this, cex.getMessage());
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), pex);
        }
        return m2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] getMessagesByUID(long start, long end) throws MessagingException {
        Message[] msgs;
        this.checkOpened();
        if (this.uidTable == null) {
            this.uidTable = new Hashtable();
        }
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                UID[] ua = this.protocol.fetchSequenceNumbers(start, end);
                msgs = new Message[ua.length];
                for (int i2 = 0; i2 < ua.length; ++i2) {
                    IMAPMessage m2 = (IMAPMessage)this.messageCache.elementAt(ua[i2].msgno - 1);
                    m2.setUID(ua[i2].uid);
                    msgs[i2] = m2;
                    this.uidTable.put(new Long(ua[i2].uid), m2);
                }
            }
        }
        catch (ConnectionException cex) {
            throw new FolderClosedException(this, cex.getMessage());
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), pex);
        }
        return msgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] getMessagesByUID(long[] uids) throws MessagingException {
        int i2;
        Object v;
        this.checkOpened();
        long[] unavailUids = uids;
        if (this.uidTable != null) {
            v = new Vector();
            for (int i3 = 0; i3 < uids.length; ++i3) {
                Long l2 = new Long(uids[i3]);
                if (this.uidTable.containsKey(l2)) continue;
                ((Vector)v).addElement(l2);
            }
            int vsize = ((Vector)v).size();
            unavailUids = new long[vsize];
            for (i2 = 0; i2 < vsize; ++i2) {
                unavailUids[i2] = (Long)((Vector)v).elementAt(i2);
            }
        } else {
            this.uidTable = new Hashtable();
        }
        if (unavailUids.length > 0) {
            try {
                v = this.messageCacheLock;
                synchronized (v) {
                    UID[] ua = this.protocol.fetchSequenceNumbers(unavailUids);
                    for (i2 = 0; i2 < ua.length; ++i2) {
                        IMAPMessage m2 = (IMAPMessage)this.messageCache.elementAt(ua[i2].msgno - 1);
                        m2.setUID(ua[i2].uid);
                        this.uidTable.put(new Long(ua[i2].uid), m2);
                    }
                }
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException(this, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), pex);
            }
        }
        Message[] msgs = new Message[uids.length];
        for (int i4 = 0; i4 < uids.length; ++i4) {
            msgs[i4] = (Message)this.uidTable.get(new Long(uids[i4]));
        }
        return msgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getUID(Message message) throws MessagingException {
        if (message.getFolder() != this) {
            throw new NoSuchElementException("Message does not belong to this folder");
        }
        this.checkOpened();
        IMAPMessage m2 = (IMAPMessage)message;
        long uid = m2.getUID();
        if (uid != -1L) {
            return uid;
        }
        UID u = null;
        Object object = this.messageCacheLock;
        synchronized (object) {
            m2.checkExpunged();
            try {
                u = this.protocol.fetchUID(m2.getSequenceNumber());
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException(this, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), pex);
            }
        }
        if (u != null) {
            uid = u.uid;
            m2.setUID(uid);
            if (this.uidTable == null) {
                this.uidTable = new Hashtable();
            }
            this.uidTable.put(new Long(uid), m2);
        }
        return uid;
    }

    public Quota[] getQuota() throws MessagingException {
        return (Quota[])this.doOptionalCommand("QUOTA not supported", new ProtocolCommand(){

            public Object doCommand(IMAPProtocol p2) throws ProtocolException {
                return p2.getQuotaRoot(IMAPFolder.this.fullName);
            }
        });
    }

    public void setQuota(final Quota quota) throws MessagingException {
        this.doOptionalCommand("QUOTA not supported", new ProtocolCommand(){

            public Object doCommand(IMAPProtocol p2) throws ProtocolException {
                p2.setQuota(quota);
                return null;
            }
        });
    }

    public ACL[] getACL() throws MessagingException {
        return (ACL[])this.doOptionalCommand("ACL not supported", new ProtocolCommand(){

            public Object doCommand(IMAPProtocol p2) throws ProtocolException {
                return p2.getACL(IMAPFolder.this.fullName);
            }
        });
    }

    public void addACL(ACL acl) throws MessagingException {
        this.setACL(acl, '\u0000');
    }

    public void removeACL(final String name) throws MessagingException {
        this.doOptionalCommand("ACL not supported", new ProtocolCommand(){

            public Object doCommand(IMAPProtocol p2) throws ProtocolException {
                p2.deleteACL(IMAPFolder.this.fullName, name);
                return null;
            }
        });
    }

    public void addRights(ACL acl) throws MessagingException {
        this.setACL(acl, '+');
    }

    public void removeRights(ACL acl) throws MessagingException {
        this.setACL(acl, '-');
    }

    public Rights[] listRights(final String name) throws MessagingException {
        return (Rights[])this.doOptionalCommand("ACL not supported", new ProtocolCommand(){

            public Object doCommand(IMAPProtocol p2) throws ProtocolException {
                return p2.listRights(IMAPFolder.this.fullName, name);
            }
        });
    }

    public Rights myRights() throws MessagingException {
        return (Rights)this.doOptionalCommand("ACL not supported", new ProtocolCommand(){

            public Object doCommand(IMAPProtocol p2) throws ProtocolException {
                return p2.myRights(IMAPFolder.this.fullName);
            }
        });
    }

    private void setACL(final ACL acl, final char mod) throws MessagingException {
        this.doOptionalCommand("ACL not supported", new ProtocolCommand(){

            public Object doCommand(IMAPProtocol p2) throws ProtocolException {
                p2.setACL(IMAPFolder.this.fullName, mod, acl);
                return null;
            }
        });
    }

    public String[] getAttributes() throws MessagingException {
        if (this.attributes == null) {
            this.exists();
        }
        return (String[])this.attributes.clone();
    }

    public void handleResponse(Response r) {
        if (r.isOK() || r.isNO() || r.isBAD() || r.isBYE()) {
            ((IMAPStore)this.store).handleResponseCode(r);
        }
        if (r.isBYE()) {
            if (this.opened) {
                this.cleanup(false);
            }
            return;
        }
        if (r.isOK()) {
            return;
        }
        if (!r.isUnTagged()) {
            return;
        }
        if (!(r instanceof IMAPResponse)) {
            this.out.println("UNEXPECTED RESPONSE : " + r.toString());
            this.out.println("CONTACT javamail@sun.com");
            return;
        }
        IMAPResponse ir = (IMAPResponse)r;
        if (ir.keyEquals("EXISTS")) {
            int exists = ir.getNumber();
            if (exists <= this.realTotal) {
                return;
            }
            int count = exists - this.realTotal;
            Message[] msgs = new Message[count];
            for (int i2 = 0; i2 < count; ++i2) {
                IMAPMessage msg = new IMAPMessage(this, ++this.total, ++this.realTotal);
                msgs[i2] = msg;
                this.messageCache.addElement(msg);
            }
            this.notifyMessageAddedListeners(msgs);
        } else if (ir.keyEquals("EXPUNGE")) {
            IMAPMessage msg = this.getMessageBySeqNumber(ir.getNumber());
            msg.setExpunged(true);
            for (int i3 = msg.getMessageNumber(); i3 < this.total; ++i3) {
                IMAPMessage m2 = (IMAPMessage)this.messageCache.elementAt(i3);
                if (m2.isExpunged()) continue;
                m2.setSequenceNumber(m2.getSequenceNumber() - 1);
            }
            --this.realTotal;
            if (this.doExpungeNotification) {
                Message[] msgs = new Message[]{msg};
                this.notifyMessageRemovedListeners(false, msgs);
            }
        } else if (ir.keyEquals("FETCH")) {
            IMAPMessage msg;
            FetchResponse f2 = (FetchResponse)ir;
            Flags flags = (Flags)((Object)f2.getItem(Flags.class));
            if (flags != null && (msg = this.getMessageBySeqNumber(f2.getNumber())) != null) {
                msg._setFlags(flags);
                this.notifyMessageChangedListeners(1, msg);
            }
        } else if (ir.keyEquals("RECENT")) {
            this.recent = ir.getNumber();
        }
    }

    void handleResponses(Response[] r) {
        for (int i2 = 0; i2 < r.length; ++i2) {
            if (r[i2] == null) continue;
            this.handleResponse(r[i2]);
        }
    }

    protected synchronized IMAPProtocol getStoreProtocol() throws ProtocolException {
        if (this.connectionPoolDebug) {
            this.out.println("DEBUG: getStoreProtocol() - borrowing a connection");
        }
        return ((IMAPStore)this.store).getStoreProtocol();
    }

    private synchronized void throwClosedException(ConnectionException cex) throws FolderClosedException, StoreClosedException {
        if (this.protocol != null && cex.getProtocol() == this.protocol || this.protocol == null && !this.reallyClosed) {
            throw new FolderClosedException(this, cex.getMessage());
        }
        throw new StoreClosedException(this.store, cex.getMessage());
    }

    public IMAPProtocol getProtocol() {
        return this.protocol;
    }

    public Object doCommand(ProtocolCommand cmd) throws MessagingException {
        try {
            return this.doProtocolCommand(cmd);
        }
        catch (ConnectionException cex) {
            this.throwClosedException(cex);
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), pex);
        }
        return null;
    }

    public Object doOptionalCommand(String err, ProtocolCommand cmd) throws MessagingException {
        try {
            return this.doProtocolCommand(cmd);
        }
        catch (BadCommandException bex) {
            throw new MessagingException(err, bex);
        }
        catch (ConnectionException cex) {
            this.throwClosedException(cex);
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), pex);
        }
        return null;
    }

    public Object doCommandIgnoreFailure(ProtocolCommand cmd) throws MessagingException {
        try {
            return this.doProtocolCommand(cmd);
        }
        catch (CommandFailedException cfx) {
            return null;
        }
        catch (ConnectionException cex) {
            this.throwClosedException(cex);
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), pex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doProtocolCommand(ProtocolCommand cmd) throws ProtocolException {
        IMAPFolder iMAPFolder = this;
        synchronized (iMAPFolder) {
            if (this.opened && !((IMAPStore)this.store).hasSeparateStoreConnection()) {
                Object object = this.messageCacheLock;
                synchronized (object) {
                    return cmd.doCommand(this.getProtocol());
                }
            }
        }
        IMAPProtocol p2 = null;
        try {
            p2 = this.getStoreProtocol();
            Object object = cmd.doCommand(p2);
            return object;
        }
        finally {
            this.releaseStoreProtocol(p2);
        }
    }

    protected synchronized void releaseStoreProtocol(IMAPProtocol p2) {
        if (p2 != this.protocol) {
            ((IMAPStore)this.store).releaseStoreProtocol(p2);
        }
    }

    private void releaseProtocol(boolean returnToPool) {
        if (this.protocol != null) {
            this.protocol.removeResponseHandler(this);
            if (returnToPool) {
                ((IMAPStore)this.store).releaseProtocol(this, this.protocol);
            } else {
                ((IMAPStore)this.store).releaseProtocol(this, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void keepConnectionAlive(boolean keepStoreAlive) throws ProtocolException {
        if (System.currentTimeMillis() - this.protocol.getTimestamp() > 1000L) {
            this.protocol.noop();
        }
        if (keepStoreAlive && ((IMAPStore)this.store).hasSeparateStoreConnection()) {
            IMAPProtocol p2 = null;
            try {
                p2 = ((IMAPStore)this.store).getStoreProtocol();
                if (System.currentTimeMillis() - p2.getTimestamp() > 1000L) {
                    p2.noop();
                }
            }
            finally {
                ((IMAPStore)this.store).releaseStoreProtocol(p2);
            }
        }
    }

    IMAPMessage getMessageBySeqNumber(int seqnum) {
        for (int i2 = seqnum - 1; i2 < this.total; ++i2) {
            IMAPMessage msg = (IMAPMessage)this.messageCache.elementAt(i2);
            if (msg.getSequenceNumber() != seqnum) continue;
            return msg;
        }
        return null;
    }

    private boolean isDirectory() {
        return (this.type & 2) != 0;
    }

    public static interface ProtocolCommand {
        public Object doCommand(IMAPProtocol var1) throws ProtocolException;
    }

    public static class FetchProfileItem
    extends FetchProfile.Item {
        public static final FetchProfileItem HEADERS = new FetchProfileItem("HEADERS");
        public static final FetchProfileItem SIZE = new FetchProfileItem("SIZE");

        protected FetchProfileItem(String name) {
            super(name);
        }
    }
}

