/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.messageservice;

import com.mathworks.messageservice.Message;
import com.mathworks.messageservice.MessageUtils;
import com.mathworks.messageservice.Subscriber;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractMessageService {
    protected final Map<String, List<Subscriber>> subscriptions = new ConcurrentHashMap<String, List<Subscriber>>();

    public void subscribe(String channel, Subscriber subscriber) {
        if (!MessageUtils.isChannelValid(channel)) {
            throw new IllegalArgumentException("Invalid channel");
        }
        if (!this.subscriptions.containsKey(channel)) {
            Vector<Subscriber> subscribers = new Vector<Subscriber>();
            subscribers.add(subscriber);
            this.subscriptions.put(channel, subscribers);
        } else {
            this.subscriptions.get(channel).add(subscriber);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unsubscribe(String channel, Subscriber subscriber) {
        if (!this.subscriptions.containsKey(channel)) throw new IllegalArgumentException("Channel does not exist");
        if (!this.subscriptions.get(channel).contains(subscriber)) throw new IllegalArgumentException("Subscriber does not exist");
        this.subscriptions.get(channel).remove(subscriber);
        if (this.subscriptions.get(channel).size() != 0) return;
        this.subscriptions.remove(channel);
    }

    protected boolean doesSubscriptionChannelMatchMessage(String channel, Message message) {
        String[] subChannelPath;
        boolean matches = true;
        String[] channelPath = StringUtils.split(message.getChannel(), "/");
        if (channelPath.length >= (subChannelPath = StringUtils.split(channel, "/")).length) {
            int lastPathIndex = subChannelPath.length - 1;
            for (int i2 = 0; i2 < lastPathIndex; ++i2) {
                if (subChannelPath[i2].equals(channelPath[i2])) continue;
                matches = false;
                break;
            }
            boolean isSameLength = channelPath.length == subChannelPath.length;
            boolean isWildCard = subChannelPath[lastPathIndex].equals("*");
            boolean isDoubleWildCard = subChannelPath[lastPathIndex].equals("**");
            boolean isSamePath = subChannelPath[lastPathIndex].equals(channelPath[lastPathIndex]);
            if (!(isDoubleWildCard || isSameLength && (isSamePath || isWildCard))) {
                matches = false;
            }
        } else {
            matches = false;
        }
        return matches;
    }
}

