/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jsonconverter.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.mathworks.matlabserver.internalservices.common.MessageContainerDO;
import com.mathworks.matlabserver.internalservices.message.MLSMessage;
import com.mathworks.matlabserver.jsonconverter.ClassLookupService;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConvertUtils {
    public static final String UUID = "uuid";

    public static MessageContainerDO convertToMessageContainer(Map<String, MLSMessage[]> map) {
        MessageContainerDO result = new MessageContainerDO();
        if (map != null) {
            Collection<MLSMessage[]> values = map.values();
            for (MLSMessage[] array : values) {
                if (array == null) continue;
                List<MLSMessage> list = Arrays.asList(array);
                Class<?> theClass = array.getClass().getComponentType();
                result.addMessages(theClass, list);
            }
        }
        return result;
    }

    public static Map<String, MLSMessage[]> convertToMap(ClassLookupService classLookupService, MessageContainerDO messageContainer) {
        ArrayList<MLSMessage> list;
        HashMap<String, MLSMessage[]> retval = new HashMap<String, MLSMessage[]>();
        HashMap<String, ArrayList<MLSMessage>> intermediate = new HashMap<String, ArrayList<MLSMessage>>();
        Collection<MLSMessage> messageCollection = messageContainer.getAllMessages();
        for (MLSMessage message : messageCollection) {
            if (message == null) continue;
            String id = classLookupService.getIdFromClass(message.getClass());
            list = (ArrayList<MLSMessage>)intermediate.get(id);
            if (list != null) {
                list.add(message);
                continue;
            }
            list = new ArrayList<MLSMessage>();
            list.add(message);
            intermediate.put(id, list);
        }
        Set set = intermediate.keySet();
        for (String key : set) {
            list = (List)intermediate.get(key);
            MLSMessage[] rawList = new MLSMessage[list.size()];
            rawList = list.toArray(rawList);
            retval.put(key, rawList);
        }
        return retval;
    }

    public static String getUuid(JsonObject jsonObject) {
        String uuid = null;
        JsonElement element = jsonObject.get(UUID);
        if (element != null && !element.isJsonNull()) {
            uuid = element.getAsString();
        }
        return uuid;
    }

    public static Map<String, String> getProperties(JsonObject jsonObject, String fieldName) {
        Map map = null;
        if (jsonObject != null) {
            JsonElement element = jsonObject.get(fieldName);
            element.getAsJsonObject();
            Gson gson = new Gson();
            Type mapType = new TypeToken<Map<String, String>>(){}.getType();
            map = (Map)gson.fromJson(element, mapType);
        }
        return map;
    }
}

