/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.internalservices.filesharing;

public final class PathBuilder {
    private static final String SEPARATOR = "/";
    private static final String SHARE_NAME = "Shared";
    private final StringBuilder sb;

    public PathBuilder() {
        this.sb = new StringBuilder();
    }

    public PathBuilder(String path) {
        this(path, false);
    }

    public PathBuilder(String path, boolean skipSeparatorPrefix) {
        String notnull = this.emptyIfNull(path);
        String mod = notnull.replace("\\", SEPARATOR);
        if (!skipSeparatorPrefix & !mod.startsWith(SEPARATOR)) {
            mod = SEPARATOR + mod;
        }
        this.sb = new StringBuilder(mod);
    }

    public void add(String ... path) {
        this.add(false, path);
    }

    private void add(boolean skipSeparatorPrefix, String ... path) {
        for (String item : path) {
            if (item == null) continue;
            if (!skipSeparatorPrefix) {
                this.sb.append(SEPARATOR);
            }
            this.sb.append(item);
        }
    }

    public void addSharedFolder() {
        this.addSharedFolder(false);
    }

    public void addSharedFolder(boolean skipSeparatorPrefix) {
        this.add(skipSeparatorPrefix, SHARE_NAME);
    }

    public String getPath() {
        return this.sb.toString();
    }

    private String emptyIfNull(String string) {
        return string == null ? "" : string;
    }
}

