/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.fileservices.decorator;

import com.mathworks.matlabserver.common.fileservice.FileUtils;
import com.mathworks.matlabserver.fileservices.decorator.FileServiceAbstractDecorator;
import com.mathworks.matlabserver.internalservices.faults.MLSException;
import com.mathworks.matlabserver.internalservices.file.FileDO;
import com.mathworks.matlabserver.internalservices.file.FileInfoDO;
import com.mathworks.matlabserver.internalservices.file.FileService;
import com.mathworks.matlabserver.internalservices.path.PathManager;
import com.mathworks.matlabserver.internalservices.path.PathStatusDO;
import com.mathworks.matlabserver.internalservices.security.UserTokenDO;

public class FileServiceUniquenessDecorator
extends FileServiceAbstractDecorator {
    private PathManager pathManager = null;

    public FileServiceUniquenessDecorator(PathManager pathManager, FileService fileService) {
        super(fileService);
        this.pathManager = pathManager;
    }

    @Override
    public FileInfoDO create(UserTokenDO userToken, FileDO file) throws MLSException {
        this.checkUniqueness(file.getFileInfo());
        return super.create(userToken, file);
    }

    @Override
    public FileInfoDO rename(UserTokenDO userToken, FileInfoDO originalFileInfo, FileInfoDO newFileInfo) throws MLSException {
        if (!originalFileInfo.isDirectory()) {
            newFileInfo.setDirectory(false);
            this.checkUniqueness(newFileInfo);
        }
        return super.rename(userToken, originalFileInfo, newFileInfo);
    }

    @Override
    public FileInfoDO[] move(UserTokenDO userToken, FileInfoDO[] sourceFileInfoArray, FileInfoDO destinationFileInfo) throws MLSException {
        return super.move(userToken, sourceFileInfoArray, destinationFileInfo);
    }

    private void checkUniqueness(FileInfoDO fileInfo) {
        if (!fileInfo.isDirectory() && FileUtils.isValidMFile(fileInfo.getName())) {
            FileInfoDO parentFolder = new FileInfoDO(fileInfo.getLocation());
            FileInfoDO testFile = new FileInfoDO("", fileInfo.getName());
            PathStatusDO[] pathStatus = this.getPathManager().getPathStatus(new FileInfoDO[]{parentFolder, testFile});
            if (pathStatus[0] != null && pathStatus[1] != null && pathStatus[0].isOnPath() && pathStatus[1].isOnPath()) {
                throw new MLSException("PathManager.FilenameAlreadyOnPath", "The chosen filename is already on the path");
            }
        }
    }

    private PathManager getPathManager() {
        return this.pathManager;
    }
}

