/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.common.service.taskdispatch;

import com.mathworks.matlabserver.common.service.taskdispatch.TaskDispatchServiceRMI;
import com.mathworks.matlabserver.common.task.TaskInput;
import com.mathworks.matlabserver.common.task.TaskOutput;
import com.mathworks.matlabserver.common.util.TaskDispatchServiceUtil;
import com.mathworks.matlabserver.internalservices.common.MessageContainerDO;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.concurrent.atomic.AtomicReference;

public class CachingWorkerProxy
implements Serializable,
TaskDispatchServiceRMI {
    private static final long serialVersionUID = 1L;
    private final TaskDispatchServiceRMI delegate;
    private final AtomicReference<String> cachedWorkerId = new AtomicReference();

    public CachingWorkerProxy(TaskDispatchServiceRMI delegate) throws RemoteException {
        this.delegate = delegate;
        this.getWorkerId();
    }

    @Override
    public TaskOutput execute(TaskInput in) throws RemoteException {
        return this.delegate.execute(in);
    }

    @Override
    public boolean isAlive() throws RemoteException {
        return this.delegate.isAlive();
    }

    @Override
    public TaskOutput evalc(TaskInput taskInput) throws RemoteException {
        return this.delegate.evalc(taskInput);
    }

    @Override
    public MessageContainerDO sendMessages(MessageContainerDO messageContainer) throws RemoteException {
        return this.delegate.sendMessages(messageContainer);
    }

    @Override
    public void exit() throws RemoteException {
        this.delegate.exit();
    }

    @Override
    public String getWorkerId() {
        if (this.cachedWorkerId.get() == null) {
            String workerId = TaskDispatchServiceUtil.getWorkerId(this.delegate);
            this.cachedWorkerId.compareAndSet(null, workerId);
        }
        return this.cachedWorkerId.get();
    }

    public int hashCode() {
        return this.getWorkerId().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CachingWorkerProxy)) {
            return false;
        }
        CachingWorkerProxy other = (CachingWorkerProxy)obj;
        return TaskDispatchServiceUtil.getWorkerId(this).equals(TaskDispatchServiceUtil.getWorkerId(other));
    }

    public String toString() {
        return this.delegate.toString();
    }
}

