/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.common.retrystrategies;

import com.mathworks.matlabserver.common.retrystrategies.RetryStrategy;

public class RetryWithExponentialBackoff
implements RetryStrategy {
    private final int maxTries;
    private final long initialDelayMs;
    private final long maxDelayMs;

    public RetryWithExponentialBackoff(int maxTries, long initialDelayMs, long maxDelayMs) {
        this.maxTries = maxTries;
        this.initialDelayMs = initialDelayMs;
        this.maxDelayMs = maxDelayMs;
    }

    @Override
    public boolean shouldRetry(int tries) {
        return tries < this.maxTries;
    }

    @Override
    public void sleepBetweenRetries(int tries) throws InterruptedException {
        if (tries < this.maxTries) {
            long delayMs = this.calculateDelay(tries);
            Thread.sleep(delayMs);
        }
    }

    private long calculateDelay(int tries) {
        return Math.min(this.maxDelayMs, Math.round(Math.pow(2.0, tries - 1) * (double)this.initialDelayMs * (Math.random() + 1.0)));
    }

    public String toString() {
        return String.format("Exponential Retry Strategy configuration: maxTries=[%d], initialDelayMs=[%d], maxDelayMs=[%d]", this.maxTries, this.initialDelayMs, this.maxDelayMs);
    }
}

