/*
 * Decompiled with CFR 0.152.
 */
package net.jini.security.policy;

import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import net.jini.security.GrantPermission;
import net.jini.security.policy.PolicyInitializationException;
import net.jini.security.policy.UmbrellaGrantPermission;

public class PolicyFileProvider
extends Policy {
    private static final String basePolicyClassProperty = "net.jini.security.policy.PolicyFileProvider.basePolicyClass";
    private static final String defaultBasePolicyClass = "sun.security.provider.PolicyFile";
    private static final String policyProperty = "java.security.policy";
    private static final Object propertyLock = new Object();
    private final String policyFile;
    private final Policy basePolicy;

    public PolicyFileProvider() throws PolicyInitializationException {
        this.policyFile = null;
        String string = Security.getProperty(basePolicyClassProperty);
        if (string == null) {
            string = defaultBasePolicyClass;
        }
        try {
            this.basePolicy = (Policy)Class.forName(string).newInstance();
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Exception exception) {
            throw new PolicyInitializationException("unable to construct base policy", exception);
        }
        this.ensureDependenciesResolved();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolicyFileProvider(String string) throws PolicyInitializationException {
        if (string == null) {
            throw new NullPointerException();
        }
        this.policyFile = string;
        String string2 = Security.getProperty(basePolicyClassProperty);
        if (string2 == null) {
            string2 = defaultBasePolicyClass;
        }
        try {
            Class<?> clazz = Class.forName(string2);
            Object object = propertyLock;
            synchronized (object) {
                String string3 = System.getProperty(policyProperty);
                try {
                    System.setProperty(policyProperty, string);
                    this.basePolicy = (Policy)clazz.newInstance();
                    Object var7_8 = null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    System.setProperty(policyProperty, string3);
                    throw throwable;
                }
                System.setProperty(policyProperty, string3);
            }
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Exception exception) {
            throw new PolicyInitializationException("unable to construct base policy", exception);
        }
        this.ensureDependenciesResolved();
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection = this.basePolicy.getPermissions(codeSource);
        PolicyFileProvider.expandUmbrella(permissionCollection);
        return permissionCollection;
    }

    public PermissionCollection getPermissions(ProtectionDomain protectionDomain) {
        PermissionCollection permissionCollection = this.basePolicy.getPermissions(protectionDomain);
        PolicyFileProvider.expandUmbrella(permissionCollection);
        return permissionCollection;
    }

    public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
        return this.basePolicy.implies(protectionDomain, permission) || permission instanceof GrantPermission && this.getPermissions(protectionDomain).implies(permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (this.policyFile != null) {
            Object object = propertyLock;
            synchronized (object) {
                String string = System.getProperty(policyProperty);
                try {
                    System.setProperty(policyProperty, this.policyFile);
                    this.basePolicy.refresh();
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    System.setProperty(policyProperty, string);
                    throw throwable;
                }
                System.setProperty(policyProperty, string);
            }
        }
        this.basePolicy.refresh();
    }

    private void ensureDependenciesResolved() {
        new GrantPermission(new UmbrellaGrantPermission());
    }

    private static void expandUmbrella(PermissionCollection permissionCollection) {
        if (permissionCollection.implies(new UmbrellaGrantPermission())) {
            ArrayList<Permission> arrayList = Collections.list(permissionCollection.elements());
            permissionCollection.add(new GrantPermission(arrayList.toArray(new Permission[arrayList.size()])));
        }
    }
}

