/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.border.MatteBorder;

public class IconBorder
extends MatteBorder {
    private static final long serialVersionUID = -5657747462265533365L;
    private int _horizontalIconAlignment = -1;
    private int _verticalIconAlignment = -1;

    public IconBorder(Icon icon) {
        super(0, 0, 0, icon.getIconWidth(), icon);
        this._verticalIconAlignment = 1;
    }

    public IconBorder(Icon icon, int n) {
        super(0, 0, 0, icon.getIconWidth(), icon);
        this._verticalIconAlignment = n;
    }

    public IconBorder(Insets insets, Icon icon) {
        super(insets, icon);
        if (insets.right > 0 || insets.left > 0) {
            this._verticalIconAlignment = 1;
        } else if (insets.top > 0 || insets.bottom > 0) {
            this._horizontalIconAlignment = 11;
        }
    }

    public IconBorder(int n, int n2, int n3, int n4, Icon icon) {
        super(n, n2, n3, n4, icon);
        if (n4 > 0 || n2 > 0) {
            this._verticalIconAlignment = 1;
        } else if (n > 0 || n3 > 0) {
            this._horizontalIconAlignment = 11;
        }
    }

    public int getHorizontalIconAlignment() {
        return this._horizontalIconAlignment;
    }

    public void setHorizontalIconAlignment(int n) {
        this._horizontalIconAlignment = n;
    }

    public int getVerticalIconAlignment() {
        return this._verticalIconAlignment;
    }

    public void setVerticalIconAlignment(int n) {
        this._verticalIconAlignment = n;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.getHorizontalIconAlignment() == -1 && this.getVerticalIconAlignment() == -1 || this.tileIcon == null) {
            super.paintBorder(component, graphics, n, n2, n3, n4);
        } else {
            Insets insets = this.getBorderInsets(component);
            Color color = graphics.getColor();
            graphics.translate(n, n2);
            if (this.tileIcon != null) {
                Color color2 = this.color = this.tileIcon.getIconWidth() == -1 ? Color.gray : null;
            }
            if (this.color != null) {
                graphics.setColor(this.color);
                graphics.fillRect(0, 0, n3 - insets.right, insets.top);
                graphics.fillRect(0, insets.top, insets.left, n4 - insets.top);
                graphics.fillRect(insets.left, n4 - insets.bottom, n3 - insets.left, insets.bottom);
                graphics.fillRect(n3 - insets.right, 0, insets.right, n4 - insets.bottom);
            } else if (this.tileIcon != null) {
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                Graphics graphics2;
                int n10 = this.tileIcon.getIconWidth();
                int n11 = this.tileIcon.getIconHeight();
                if (insets.top > 0) {
                    graphics2 = graphics.create();
                    graphics2.setClip(0, 0, n3, insets.top);
                    n9 = insets.left;
                    n8 = 0;
                    n7 = this.getVerticalIconAlignment();
                    if (!component.getComponentOrientation().isLeftToRight()) {
                        if (n7 == 10) {
                            n7 = 4;
                        } else if (n7 == 11) {
                            n7 = 2;
                        }
                    }
                    switch (n7) {
                        case 2: 
                        case 10: {
                            n6 = n9;
                            n5 = n8;
                            break;
                        }
                        case 0: {
                            n6 = n9 + (n3 - n10) / 2;
                            n5 = n8;
                            break;
                        }
                        default: {
                            n6 = n9 + n3 - n10;
                            n5 = n8;
                        }
                    }
                    this.tileIcon.paintIcon(component, graphics2, n6, n5);
                    graphics2.dispose();
                }
                if (insets.left > 0) {
                    graphics2 = graphics.create();
                    graphics2.setClip(0, insets.top, insets.left, n4 - insets.top);
                    n8 = insets.top;
                    n9 = 0;
                    switch (this.getVerticalIconAlignment()) {
                        case 1: 
                        case 10: {
                            n6 = n9;
                            n5 = n8;
                            break;
                        }
                        case 0: {
                            n6 = n9;
                            n5 = n8 + (n4 - n11) / 2;
                            break;
                        }
                        default: {
                            n6 = n9;
                            n5 = n8 + n4 - n11;
                        }
                    }
                    this.tileIcon.paintIcon(component, graphics2, n6, n5);
                    graphics2.dispose();
                }
                if (insets.bottom > 0) {
                    graphics2 = graphics.create();
                    graphics2.setClip(insets.left, n4 - insets.bottom, n3 - insets.left, insets.bottom);
                    n8 = n4 - insets.bottom;
                    n9 = insets.left;
                    n7 = this.getHorizontalIconAlignment();
                    if (!component.getComponentOrientation().isLeftToRight()) {
                        if (n7 == 10) {
                            n7 = 4;
                        } else if (n7 == 11) {
                            n7 = 2;
                        }
                    }
                    switch (n7) {
                        case 2: 
                        case 10: {
                            n6 = n9;
                            n5 = n8;
                            break;
                        }
                        case 0: {
                            n6 = n9 + (n3 - n10) / 2;
                            n5 = n8;
                            break;
                        }
                        default: {
                            n6 = n9 + n3 - n10;
                            n5 = n8;
                        }
                    }
                    this.tileIcon.paintIcon(component, graphics2, n6, n5);
                    graphics2.dispose();
                }
                if (insets.right > 0) {
                    graphics2 = graphics.create();
                    graphics2.setClip(n3 - insets.right, insets.top, insets.right, n4 - insets.top - insets.bottom);
                    n8 = insets.top;
                    n9 = n3 - insets.right;
                    switch (this.getVerticalIconAlignment()) {
                        case 1: 
                        case 10: {
                            n6 = n9;
                            n5 = n8;
                            break;
                        }
                        case 0: {
                            n6 = n9;
                            n5 = n8 + (n4 - n11) / 2;
                            break;
                        }
                        default: {
                            n6 = n9;
                            n5 = n8 + n4 - n11;
                        }
                    }
                    this.tileIcon.paintIcon(component, graphics2, n6, n5);
                    graphics2.dispose();
                }
            }
            graphics.translate(-n, -n2);
            graphics.setColor(color);
        }
    }
}

