/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.Item;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public class SQLConnect
extends ExtensionInstruction {
    Expression database;
    Expression driver;
    Expression user;
    Expression password;

    public boolean mayContainSequenceConstructor() {
        return false;
    }

    public void prepareAttributes() throws XPathException {
        String dbAtt = this.attributeList.getValue("", "database");
        if (dbAtt == null) {
            this.reportAbsence("database");
            dbAtt = "";
        }
        this.database = this.makeAttributeValueTemplate(dbAtt);
        String dbDriver = this.attributeList.getValue("", "driver");
        if (dbDriver == null) {
            if (dbAtt.length() > 9 && dbAtt.substring(0, 9).equals("jdbc:odbc")) {
                dbDriver = "sun.jdbc.odbc.JdbcOdbcDriver";
            } else {
                this.reportAbsence("driver");
            }
        }
        this.driver = this.makeAttributeValueTemplate(dbDriver);
        String userAtt = this.attributeList.getValue("", "user");
        this.user = userAtt == null ? new StringLiteral(StringValue.EMPTY_STRING) : this.makeAttributeValueTemplate(userAtt);
        String pwdAtt = this.attributeList.getValue("", "password");
        this.password = pwdAtt == null ? new StringLiteral(StringValue.EMPTY_STRING) : this.makeAttributeValueTemplate(pwdAtt);
    }

    public void validate() throws XPathException {
        super.validate();
        this.database = this.typeCheck("database", this.database);
        this.driver = this.typeCheck("driver", this.driver);
        this.user = this.typeCheck("user", this.user);
        this.password = this.typeCheck("password", this.password);
    }

    public Expression compile(Executable exec) throws XPathException {
        return new ConnectInstruction(this.database, this.driver, this.user, this.password);
    }

    private static class ConnectInstruction
    extends SimpleExpression {
        public static final int DATABASE = 0;
        public static final int DRIVER = 1;
        public static final int USER = 2;
        public static final int PASSWORD = 3;

        public ConnectInstruction(Expression database, Expression driver, Expression user, Expression password) {
            Expression[] subs = new Expression[]{database, driver, user, password};
            this.setArguments(subs);
        }

        public int getImplementationMethod() {
            return 1;
        }

        public int computeCardinality() {
            return 16384;
        }

        public String getExpressionType() {
            return "sql:connect";
        }

        public Item evaluateItem(XPathContext context) throws XPathException {
            Connection connection = null;
            String dbString = ((Object)this.arguments[0].evaluateAsString(context)).toString();
            String dbDriverString = ((Object)this.arguments[1].evaluateAsString(context)).toString();
            String userString = ((Object)this.arguments[2].evaluateAsString(context)).toString();
            String pwdString = ((Object)this.arguments[3].evaluateAsString(context)).toString();
            try {
                Class.forName(dbDriverString);
                connection = DriverManager.getConnection(dbString, userString, pwdString);
            }
            catch (Exception ex) {
                this.dynamicError("JDBC Connection Failure: " + ex.getMessage(), "SXSQ0003", context);
            }
            return new ObjectValue((Object)connection);
        }
    }
}

