/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.parallel.pctutil.concurrent;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class ObjectCountDownLatch<T> {
    private final Set<T> fObjects;
    private final CountDownLatch fCompleteSignal;
    private boolean fComplete;

    public ObjectCountDownLatch(Set<? extends T> set) {
        int n = set.size();
        this.fComplete = false;
        this.fCompleteSignal = new CountDownLatch(n);
        this.fObjects = new HashSet<T>(set);
    }

    public ObjectCountDownLatch(List<? extends T> list) {
        this(new HashSet<T>(list));
        if (this.fObjects.size() != list.size()) {
            throw new IllegalArgumentException("ObjectCountDownLatch requires a list of unique objects");
        }
    }

    public synchronized boolean complete() {
        return this.fComplete;
    }

    public synchronized void countDown(T t) throws IllegalArgumentException {
        if (this.fComplete) {
            return;
        }
        boolean bl = this.fObjects.remove(t);
        if (!bl) {
            throw new IllegalArgumentException("Invalid object removed from ObjectCountDownLatch");
        }
        if (this.fObjects.isEmpty()) {
            this.fComplete = true;
        }
        this.fCompleteSignal.countDown();
    }

    public boolean awaitInterruptibly(long l, TimeUnit timeUnit) throws InterruptedException {
        assert (l >= 0L) : "Wait time must be positive.";
        return this.fCompleteSignal.await(l, timeUnit);
    }

    public boolean await(long l, TimeUnit timeUnit) {
        assert (l >= 0L) : "Wait time must be positive.";
        l = timeUnit.toMillis(l);
        long l2 = System.currentTimeMillis();
        long l3 = 0L;
        while (l3 <= l) {
            try {
                return this.fCompleteSignal.await(l - l3, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                l3 = System.currentTimeMillis() - l2;
            }
        }
        return false;
    }

    public void awaitInterruptibly() throws InterruptedException {
        this.fCompleteSignal.await();
    }

    public void await() {
        while (true) {
            try {
                this.fCompleteSignal.await();
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

