/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.net.Cache;
import ice.net.CacheCallback;
import ice.net.CacheManagerSettings;
import ice.net.CachedObject;
import ice.net.HttpSession;
import ice.util.ParseDate;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CacheManager {
    Hashtable theCaches = new Hashtable();
    Vector theCachesP = new Vector();
    boolean useCache = false;
    long clockskew = -1L;
    private boolean OEAB;
    private HttpSession addElement;

    public CacheManager() {
        this(new CacheManagerSettings());
    }

    public CacheManager(CacheManagerSettings cacheManagerSettings) {
        this.OEAB = cacheManagerSettings.shouldAlwaysRevalidate();
    }

    public CacheManager(HttpSession httpSession) {
        this.addElement = httpSession;
    }

    public boolean shouldAlwaysRevalidate() {
        if (this.addElement == null) {
            return this.OEAB;
        }
        return this.addElement.alwaysRevalidate;
    }

    HttpSession getSession() {
        return this.addElement;
    }

    int getMaxCacheable(URLConnection uRLConnection) {
        String string = uRLConnection.getContentType();
        if (string != null && string.equalsIgnoreCase("application/x-shockwave-flash")) {
            return 0;
        }
        if (this.theCachesP.size() > 0) {
            return (int)((Cache)this.theCachesP.elementAt(0)).getMaxSize();
        }
        return 0;
    }

    public Cache getCache(int n) {
        if (n < 0 || n >= this.theCachesP.size()) {
            return null;
        }
        return (Cache)this.theCachesP.elementAt(n);
    }

    public void addCache(Cache cache) {
        cache.setManager(this);
        this.theCaches.put(cache.getName(), cache);
        this.theCachesP.addElement(cache);
    }

    public Cache removeCache(String string) {
        Cache cache = (Cache)this.theCaches.get(string);
        this.theCaches.remove(string);
        this.theCachesP.removeElementAt(this.getPriority(cache));
        return cache;
    }

    public int getPriority(Cache cache) {
        if (cache == null) {
            return -1;
        }
        String string = cache.getName();
        int n = this.theCachesP.size();
        int n2 = 0;
        while (n2 < n) {
            if (string.equals(((Cache)this.theCachesP.elementAt(n2)).getName())) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public Cache getCache(String string) {
        Cache cache = (Cache)this.theCaches.get(string);
        return cache;
    }

    public void useCache(boolean bl) {
        this.useCache = bl;
    }

    public boolean isCacheOn() {
        return this.useCache;
    }

    public boolean clearCache(String string) {
        if (!this.theCaches.containsKey(string)) {
            return false;
        }
        Cache cache = (Cache)this.theCaches.get(string);
        cache.clear();
        return true;
    }

    public void clearAllCaches() {
        Enumeration enumeration = this.theCaches.elements();
        while (enumeration.hasMoreElements()) {
            ((Cache)enumeration.nextElement()).clear();
        }
    }

    public boolean clearExpired(String string) {
        if (!this.theCaches.containsKey(string)) {
            return false;
        }
        Cache cache = (Cache)this.theCaches.get(string);
        cache.clearExpired();
        return true;
    }

    public void clearAllExpired() {
        Enumeration enumeration = this.theCaches.elements();
        while (enumeration.hasMoreElements()) {
            ((Cache)enumeration.nextElement()).clearExpired();
        }
    }

    protected void removeURL(URL uRL) {
        Enumeration enumeration = this.theCaches.elements();
        while (enumeration.hasMoreElements()) {
            ((Cache)enumeration.nextElement()).delete(uRL.toString(), false);
        }
    }

    CachedObject getCachedObject(URL uRL, CacheCallback cacheCallback) {
        int n;
        String string = uRL.toString();
        String string2 = null;
        string2 = cacheCallback.getRequestProperty("Cache-Control");
        if (string2 == null) {
            string2 = cacheCallback.getRequestProperty("Pragma");
        }
        if (string2 != null && "no-cache".equalsIgnoreCase(string2)) {
            this.removeURL(uRL);
            return null;
        }
        boolean bl = false;
        Cache cache = null;
        CachedObject cachedObject = null;
        if (string.indexOf(35) != -1) {
            n = string.indexOf(35);
            string = string.substring(0, n);
        }
        n = this.theCachesP.size();
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            cache = (Cache)this.theCachesP.elementAt(n3);
            if (cache.has(string) && (cachedObject = cache.get(string)) != null) {
                n2 = n3;
                bl = true;
                break;
            }
            ++n3;
        }
        if (n2 > 0) {
            cache.delete(string, false);
            Cache cache2 = (Cache)this.theCachesP.elementAt(0);
            cache2.submit(cachedObject);
        }
        if (!bl) {
            return null;
        }
        return cachedObject;
    }

    public InputStream getCachedContent(URL uRL, CacheCallback cacheCallback) {
        CachedObject cachedObject = this.getCachedObject(uRL, cacheCallback);
        if (cachedObject == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(cachedObject.data);
        int n = 0;
        while (n < cachedObject.headerKeys.length) {
            cacheCallback.parseHeaderLine(cachedObject.headerKeys[n] + ":" + cachedObject.headers[n]);
            ++n;
        }
        return byteArrayInputStream;
    }

    public synchronized void submit(byte[] byArray, HttpURLConnection httpURLConnection) {
        if (this.useCache) {
            CachedObject cachedObject = this.alwaysRevalidate(byArray, httpURLConnection);
            int n = 0;
            try {
                n = httpURLConnection.getResponseCode();
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = true;
            if (httpURLConnection.getRequestMethod().equalsIgnoreCase("post")) {
                bl = false;
            }
            if (n == 401) {
                bl = false;
            }
            if (httpURLConnection.getURL().getFile().indexOf(63) != -1) {
                String string = httpURLConnection.getHeaderField("Expires");
                String string2 = httpURLConnection.getHeaderField("max-age");
                if (string == null && string2 == null) {
                    bl = false;
                }
            }
            if (bl && this.OEAB(cachedObject, "Pragma", "no-cache")) {
                bl = false;
            }
            if (bl && this.OEAB(cachedObject, "Cache-Control", "no-cache")) {
                bl = false;
            }
            if (bl && this.OEAB(cachedObject, "Cache-Control", "no-store")) {
                bl = false;
            }
            if (bl && this.OEAB(cachedObject, "Cache-Control", "private")) {
                bl = false;
            }
            if (bl && this.OEAB(cachedObject, "Cache-Control", "must-revalidate")) {
                bl = false;
            }
            if (bl) {
                int n2 = this.theCachesP.size();
                int n3 = 1;
                Cache cache = null;
                int n4 = CacheManager.append(cachedObject);
                boolean bl2 = false;
                while (n3 <= n2 && !bl2) {
                    cache = (Cache)this.theCachesP.elementAt(n3 - 1);
                    if (cache.getMaxSize() > (long)n4) {
                        cache.submit(cachedObject);
                        bl2 = true;
                    }
                    ++n3;
                }
            }
        }
    }

    private boolean OEAB(CachedObject cachedObject, String string, String string2) {
        int n = 0;
        while (n < cachedObject.headerKeys.length) {
            if (cachedObject.headerKeys[n].equalsIgnoreCase(string) && cachedObject.headers[n].equalsIgnoreCase(string2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void status() {
        Enumeration enumeration = this.theCaches.elements();
        while (enumeration.hasMoreElements()) {
            Cache cache = (Cache)enumeration.nextElement();
            System.out.println("Cache is " + cache.getName() + " Max" + cache.getMaxSize() + " Used " + cache.getCurrentSize());
        }
    }

    public boolean isExpired(CachedObject cachedObject) {
        if (cachedObject != null) {
            String string = cachedObject.findHeader("max-age");
            long l = 0L;
            l = string == null ? -1L : new Long(string);
            return this.addElement(cachedObject.expires, cachedObject.recieved, cachedObject.lastModified, l);
        }
        return true;
    }

    public boolean isExpired(long l, long l2, long l3, long l4) {
        return this.addElement(l, l2, l3, l4);
    }

    private boolean addElement(long l, long l2, long l3, long l4) {
        if (l2 < l3) {
            return false;
        }
        if (l != -1L) {
            return l <= System.currentTimeMillis();
        }
        if (l4 != -1L && System.currentTimeMillis() - l2 > l4) {
            return false;
        }
        long l5 = l2 - l3;
        long l6 = System.currentTimeMillis() - l2;
        return l6 > l5;
    }

    private final CachedObject alwaysRevalidate(byte[] byArray, HttpURLConnection httpURLConnection) {
        Object object;
        Object object2;
        int n = 0;
        while (((URLConnection)httpURLConnection).getHeaderField(n) != null) {
            ++n;
        }
        String[] stringArray = new String[n - 1];
        String[] stringArray2 = new String[n - 1];
        int n2 = 0;
        while (n2 < n - 1) {
            stringArray[n2] = ((URLConnection)httpURLConnection).getHeaderFieldKey(n2 + 1);
            stringArray2[n2] = ((URLConnection)httpURLConnection).getHeaderField(n2 + 1);
            ++n2;
        }
        CachedObject cachedObject = this.addElement == null ? new CachedObject(this) : new CachedObject(this.addElement);
        cachedObject.url = httpURLConnection.getURL().toString();
        if (cachedObject.url.indexOf(35) != -1) {
            int n3 = cachedObject.url.indexOf(35);
            cachedObject.url = cachedObject.url.substring(0, n3);
        }
        cachedObject.data = byArray;
        cachedObject.headerKeys = stringArray;
        cachedObject.headers = stringArray2;
        cachedObject.lastAccessed = 0L;
        if (this.clockskew == -1L) {
            Date date = ParseDate.parseDate((String)cachedObject.findHeader("Date"));
            if (date != null) {
                this.clockskew = System.currentTimeMillis() - date.getTime();
            }
            if (this.clockskew == -1L) {
                ++this.clockskew;
            }
        }
        cachedObject.skew = this.clockskew;
        cachedObject.recieved = System.currentTimeMillis();
        String string = cachedObject.findHeader("Last-Modified");
        if (string == null) {
            cachedObject.lastModified = cachedObject.recieved - 86000000L;
        } else {
            cachedObject.lastModified = -1L;
            object2 = ParseDate.parseDate((String)string);
            if (object2 != null) {
                cachedObject.lastModified = ((Date)object2).getTime();
            }
        }
        object2 = cachedObject.findHeader("Expires");
        if (object2 == null) {
            cachedObject.expires = -1L;
        } else {
            cachedObject.expires = -1L;
            object = ParseDate.parseDate((String)object2);
            if (object != null) {
                cachedObject.expires = ((Date)object).getTime();
            }
        }
        object = cachedObject.findHeader("max-age");
        if (object == null) {
            cachedObject.maxAge = -1L;
        } else {
            cachedObject.maxAge = -1L;
            try {
                cachedObject.maxAge = Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return cachedObject;
    }

    public void wasDeleted(CachedObject cachedObject, Cache cache) {
        int n;
        int n2 = this.getPriority(cache) + 1;
        if (n2 < this.theCachesP.size() && (n = this.getPriority(cache)) < this.theCachesP.size() - 1) {
            ((Cache)this.theCachesP.elementAt(n + 1)).submit(cachedObject);
        }
    }

    private static int append(CachedObject cachedObject) {
        int n = 0;
        n = cachedObject.data.length;
        int n2 = 0;
        while (n2 < cachedObject.headers.length) {
            n += cachedObject.headers[n2].length() * 2;
            ++n2;
        }
        return n;
    }
}

