/*
 * Decompiled with CFR 0.152.
 */
package org.openxml4j.opc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.openxml4j.exceptions.InvalidFormatException;
import org.openxml4j.exceptions.InvalidOperationException;
import org.openxml4j.exceptions.OpenXML4JException;
import org.openxml4j.opc.Package;
import org.openxml4j.opc.PackagePartName;
import org.openxml4j.opc.PackageRelationship;
import org.openxml4j.opc.PackageRelationshipCollection;
import org.openxml4j.opc.RelationshipSource;
import org.openxml4j.opc.TargetMode;
import org.openxml4j.opc.ZipPackage;
import org.openxml4j.opc.ZipPackagePart;
import org.openxml4j.opc.internal.ContentType;

public abstract class PackagePart
implements RelationshipSource {
    protected Package container;
    protected PackagePartName partName;
    protected ContentType contentType;
    private boolean isRelationshipPart;
    private boolean isDeleted;
    private PackageRelationshipCollection relationships;

    protected PackagePart(Package pack, PackagePartName partName, ContentType contentType) throws InvalidFormatException {
        this(pack, partName, contentType, true);
    }

    protected PackagePart(Package pack, PackagePartName partName, ContentType contentType, boolean loadRelationships) throws InvalidFormatException {
        this.partName = partName;
        this.contentType = contentType;
        this.container = (ZipPackage)pack;
        this.isRelationshipPart = this.partName.isRelationshipPartURI();
        if (loadRelationships) {
            this.loadRelationships();
        }
    }

    public PackagePart(Package pack, PackagePartName partName, String contentType) throws InvalidFormatException {
        this(pack, partName, new ContentType(contentType));
    }

    public PackageRelationship addExternalRelationship(String target, String relationshipType) {
        return this.addExternalRelationship(target, relationshipType, null);
    }

    public PackageRelationship addExternalRelationship(String target, String relationshipType, String id) {
        URI targetURI;
        if (target == null) {
            throw new IllegalArgumentException("target");
        }
        if (relationshipType == null) {
            throw new IllegalArgumentException("relationshipType");
        }
        if (this.relationships == null) {
            this.relationships = new PackageRelationshipCollection();
        }
        try {
            targetURI = new URI(target);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid target - " + e);
        }
        return this.relationships.addRelationship(targetURI, TargetMode.EXTERNAL, relationshipType, id);
    }

    public PackageRelationship addRelationship(PackagePartName targetPartName, TargetMode targetMode, String relationshipType) {
        return this.addRelationship(targetPartName, targetMode, relationshipType, null);
    }

    public PackageRelationship addRelationship(PackagePartName targetPartName, TargetMode targetMode, String relationshipType, String id) {
        this.container.throwExceptionIfReadOnly();
        if (targetPartName == null) {
            throw new IllegalArgumentException("targetPartName");
        }
        if (targetMode == null) {
            throw new IllegalArgumentException("targetMode");
        }
        if (relationshipType == null) {
            throw new IllegalArgumentException("relationshipType");
        }
        if (this.isRelationshipPart || targetPartName.isRelationshipPartURI()) {
            throw new InvalidOperationException("Rule M1.25: The Relationships part shall not have relationships to any other part.");
        }
        if (this.relationships == null) {
            this.relationships = new PackageRelationshipCollection();
        }
        return this.relationships.addRelationship(targetPartName.getURI(), targetMode, relationshipType, id);
    }

    public void clearRelationships() {
        if (this.relationships != null) {
            this.relationships.clear();
        }
    }

    public void removeRelationship(String id) {
        this.container.throwExceptionIfReadOnly();
        if (this.relationships != null) {
            this.relationships.removeRelationship(id);
        }
    }

    public PackageRelationshipCollection getRelationships() throws InvalidFormatException {
        return this.getRelationshipsCore(null);
    }

    public PackageRelationship getRelationship(String id) {
        return this.relationships.getRelationshipByID(id);
    }

    public PackageRelationshipCollection getRelationshipsByType(String relationshipType) throws InvalidFormatException {
        this.container.throwExceptionIfWriteOnly();
        return this.getRelationshipsCore(relationshipType);
    }

    private PackageRelationshipCollection getRelationshipsCore(String filter) throws InvalidFormatException {
        this.container.throwExceptionIfWriteOnly();
        if (this.relationships == null) {
            this.throwExceptionIfRelationship();
            this.relationships = new PackageRelationshipCollection(this);
        }
        return new PackageRelationshipCollection(this.relationships, filter);
    }

    public boolean hasRelationships() {
        return !this.isRelationshipPart && this.relationships != null && this.relationships.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRelationshipExists(PackageRelationship rel) {
        try {
            for (PackageRelationship r : this.getRelationships()) {
                if (r != rel) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            return false;
        }
    }

    public InputStream getInputStream() throws IOException {
        InputStream inStream = this.getInputStreamImpl();
        if (inStream == null) {
            throw new IOException("Can't obtain the input stream from " + this.partName.getName());
        }
        return inStream;
    }

    public OutputStream getOutputStream() {
        OutputStream outStream;
        if (this instanceof ZipPackagePart) {
            this.container.removePart(this.partName);
            PackagePart part = this.container.createPart(this.partName, this.contentType.toString(), false);
            part.relationships = this.relationships;
            if (part == null) {
                throw new InvalidOperationException("Can't create a temporary part !");
            }
            outStream = part.getOutputStreamImpl();
        } else {
            outStream = this.getOutputStreamImpl();
        }
        return outStream;
    }

    private void throwExceptionIfRelationship() throws InvalidOperationException {
        if (this.isRelationshipPart) {
            throw new InvalidOperationException("Can do this operation on a relationship part !");
        }
    }

    private void loadRelationships() throws InvalidFormatException {
        if (this.relationships == null && !this.isRelationshipPart) {
            this.throwExceptionIfRelationship();
            this.relationships = new PackageRelationshipCollection(this);
        }
    }

    public PackagePartName getPartName() {
        return this.partName;
    }

    public String getContentType() {
        return this.contentType.toString();
    }

    public void setContentType(String contentType) throws InvalidFormatException {
        if (this.container != null) {
            throw new InvalidOperationException("You can't change the content type of a part.");
        }
        this.contentType = new ContentType(contentType);
    }

    public Package getPackage() {
        return this.container;
    }

    public boolean isRelationshipPart() {
        return this.isRelationshipPart;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public String toString() {
        return "Name: " + this.partName + " - Content Type: " + this.contentType.toString();
    }

    protected abstract InputStream getInputStreamImpl() throws IOException;

    protected abstract OutputStream getOutputStreamImpl();

    public abstract boolean save(OutputStream var1) throws OpenXML4JException;

    public abstract boolean load(InputStream var1) throws InvalidFormatException;

    public abstract void close();

    public abstract void flush();
}

