/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.util;

import com.mathworks.hg.util.DisplayChangeManager;
import com.mathworks.hg.util.HGDisplayChangedEvent;
import java.awt.Rectangle;

public class ScreenDevicesManager
extends DisplayChangeManager {
    public ScreenDevicesManager() {
        this(false);
    }

    public ScreenDevicesManager(boolean bl) {
        super(bl);
    }

    public int getScreenDepth() {
        return this.getSystemScreenInfoProvider().getScreenDepth();
    }

    public Rectangle getPrimaryScreenRect() {
        Rectangle rectangle = this.getSystemScreenInfoProvider().getPrimaryScreenDeviceRectangle();
        return this.translateScreenRelativeToRectangleReference(rectangle, rectangle);
    }

    public int getDPI() {
        return this.getSystemScreenInfoProvider().getSystemDPI();
    }

    public int getNumberOfScreens() {
        return this.getSystemScreenInfoProvider().getNumberOfScreens();
    }

    public Rectangle getCombinedAvailableScreenSize() {
        return this.getSystemScreenInfoProvider().getCombinedAvailableScreenSize();
    }

    public Rectangle getScreenRectAtIndex(int n) {
        Rectangle rectangle = this.getSystemScreenInfoProvider().getScreenDeviceRectangleAt(n);
        Rectangle rectangle2 = this.getSystemScreenInfoProvider().getPrimaryScreenDeviceRectangle();
        return this.translateScreenRelativeToRectangleReference(rectangle, rectangle2);
    }

    private Rectangle translateScreenRelativeToRectangleReference(Rectangle rectangle, Rectangle rectangle2) {
        int n = (int)(rectangle.getX() - rectangle2.getX());
        int n2 = (int)(rectangle.getY() - rectangle2.getY());
        int n3 = (int)rectangle.getWidth();
        int n4 = (int)rectangle.getHeight();
        return new Rectangle(n, n2, n3, n4);
    }

    @Override
    public void fireDisplayChanged(HGDisplayChangedEvent hGDisplayChangedEvent) {
        hGDisplayChangedEvent.fDPI = this.getDPI();
        hGDisplayChangedEvent.fNumScreens = this.getNumberOfScreens();
        hGDisplayChangedEvent.fPrimary = this.getPrimaryScreenRect();
        hGDisplayChangedEvent.fScreenDepth = this.getScreenDepth();
        super.fireDisplayChanged(hGDisplayChangedEvent);
    }
}

