/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.util;

import com.mathworks.hg.util.AbstractSystemScreenInfoProvider;
import com.mathworks.util.PlatformInfo;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.EventListener;
import sun.awt.DisplayChangedListener;
import sun.java2d.SunGraphicsEnvironment;

public class JavaSystemScreenInfoProvider
implements AbstractSystemScreenInfoProvider {
    private static int sDefaultScreenDPI = 0;
    private static int sDefaultScreenDepth = 0;
    private static Rectangle sDefaultScreenRect = new Rectangle(0, 0, 0, 0);
    private static final int DEFAULT_SCREEN_COUNT = 1;
    private boolean fFoundHiddenSunClass = this.attemptFindHiddenSunClass();

    @Override
    public int getScreenDepth() {
        if (JavaSystemScreenInfoProvider.isHeadless()) {
            assert (sDefaultScreenDepth > 0);
            return sDefaultScreenDepth;
        }
        GraphicsConfiguration graphicsConfiguration = JavaSystemScreenInfoProvider.getDefaultGraphicsConfiguration();
        GraphicsDevice graphicsDevice = JavaSystemScreenInfoProvider.getDefaultGraphicsDevice();
        int n = -1;
        try {
            n = graphicsDevice.getDisplayMode().getBitDepth();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return n == -1 ? graphicsConfiguration.getColorModel().getPixelSize() : n;
    }

    @Override
    public Rectangle getPrimaryScreenDeviceRectangle() {
        if (JavaSystemScreenInfoProvider.isHeadless()) {
            assert (sDefaultScreenRect.getWidth() > 0.0);
            assert (sDefaultScreenRect.getHeight() > 0.0);
            return sDefaultScreenRect;
        }
        GraphicsConfiguration graphicsConfiguration = JavaSystemScreenInfoProvider.getDefaultGraphicsConfiguration();
        return graphicsConfiguration.getBounds();
    }

    @Override
    public Rectangle getCombinedAvailableScreenSize() {
        if (JavaSystemScreenInfoProvider.isHeadless()) {
            assert (sDefaultScreenRect.getWidth() > 0.0);
            assert (sDefaultScreenRect.getHeight() > 0.0);
            return sDefaultScreenRect;
        }
        if (PlatformInfo.isLinux()) {
            return new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        }
        return this.getPrimaryScreenDeviceRectangle();
    }

    @Override
    public Rectangle getScreenDeviceRectangleAt(int n) {
        if (JavaSystemScreenInfoProvider.isHeadless()) {
            assert (sDefaultScreenRect.getWidth() > 0.0);
            assert (sDefaultScreenRect.getHeight() > 0.0);
            return sDefaultScreenRect;
        }
        GraphicsDevice[] graphicsDeviceArray = this.getScreenDevices();
        return graphicsDeviceArray[n].getDefaultConfiguration().getBounds();
    }

    public GraphicsDevice[] getScreenDevices() {
        if (!JavaSystemScreenInfoProvider.isHeadless()) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            return graphicsEnvironment.getScreenDevices();
        }
        return null;
    }

    @Override
    public int getSystemDPI() {
        if (JavaSystemScreenInfoProvider.isHeadless()) {
            assert (sDefaultScreenDPI > 0);
            return sDefaultScreenDPI;
        }
        return PlatformInfo.isMacintosh() ? 72 : Toolkit.getDefaultToolkit().getScreenResolution();
    }

    @Override
    public int getNumberOfScreens() {
        if (JavaSystemScreenInfoProvider.isHeadless()) {
            return 1;
        }
        GraphicsDevice[] graphicsDeviceArray = this.getScreenDevices();
        return graphicsDeviceArray == null ? 0 : graphicsDeviceArray.length;
    }

    @Override
    public boolean isDisplayChangeSupported() {
        if (JavaSystemScreenInfoProvider.isHeadless()) {
            return false;
        }
        return this.fFoundHiddenSunClass;
    }

    @Override
    public EventListener addSystemDisplayChangeListener(final Runnable runnable) {
        if (!this.isDisplayChangeSupported()) {
            return null;
        }
        DisplayChangedListener displayChangedListener = new DisplayChangedListener(){

            @Override
            public void displayChanged() {
                runnable.run();
            }

            @Override
            public void paletteChanged() {
            }
        };
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        assert (graphicsEnvironment instanceof SunGraphicsEnvironment);
        SunGraphicsEnvironment sunGraphicsEnvironment = (SunGraphicsEnvironment)graphicsEnvironment;
        sunGraphicsEnvironment.addDisplayChangedListener(displayChangedListener);
        return displayChangedListener;
    }

    @Override
    public void removeSystemDisplayChangeListener(EventListener eventListener) {
        if (!this.isDisplayChangeSupported()) {
            return;
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        assert (graphicsEnvironment instanceof SunGraphicsEnvironment);
        SunGraphicsEnvironment sunGraphicsEnvironment = (SunGraphicsEnvironment)graphicsEnvironment;
        sunGraphicsEnvironment.removeDisplayChangedListener((DisplayChangedListener)eventListener);
    }

    private boolean attemptFindHiddenSunClass() {
        boolean bl = true;
        try {
            Class<?> clazz = Class.forName("sun.awt.DisplayChangedListener");
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        return bl;
    }

    private static GraphicsConfiguration getDefaultGraphicsConfiguration() {
        GraphicsConfiguration graphicsConfiguration;
        block6: {
            graphicsConfiguration = null;
            try {
                if (!JavaSystemScreenInfoProvider.isHeadless()) {
                    GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    assert (graphicsEnvironment != null);
                    GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
                    assert (graphicsDevice != null);
                    graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
                }
            }
            catch (HeadlessException headlessException) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        assert (graphicsConfiguration != null);
        return graphicsConfiguration;
    }

    private static GraphicsDevice getDefaultGraphicsDevice() {
        GraphicsDevice graphicsDevice;
        block4: {
            graphicsDevice = null;
            try {
                if (!JavaSystemScreenInfoProvider.isHeadless()) {
                    graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                }
            }
            catch (HeadlessException headlessException) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        assert (graphicsDevice != null);
        return graphicsDevice;
    }

    private static void setDefaultScreenValues(int n, int n2, int n3, int n4) {
        assert (n > 0);
        assert (n2 > 0);
        assert (n3 > 0);
        assert (n4 > 0);
        sDefaultScreenDPI = n;
        sDefaultScreenDepth = n4;
        sDefaultScreenRect = new Rectangle(0, 0, n2, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isHeadless() {
        if (GraphicsEnvironment.isHeadless()) {
            return true;
        }
        try {
            GraphicsEnvironment.getLocalGraphicsEnvironment();
            return false;
        }
        catch (Exception exception) {}
        finally {
            return true;
        }
    }
}

