/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.util;

import com.mathworks.hg.peer.FigurePanelContainer;
import com.mathworks.hg.peer.OffscreenWindowProvider;
import com.mathworks.hg.print.PrintUtilities;
import com.mathworks.hg.util.GraphicsDeviceUtilities;
import com.mathworks.hg.util.MPrintJob;
import com.mathworks.hg.util.OutputHelper;
import com.mathworks.hg.util.OutputHelperProcessingException;
import com.mathworks.jmi.AWTUtilities;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTTitleBar;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.swing.SwingUtilities;

public class HGGetframeOutputHelper
extends OutputHelper {
    private Exception fException;
    private Container fContainer;
    private BufferedImage fBufferedImage;
    private static ResourceBundle sRasterHelperInfo = ResourceBundle.getBundle("com.mathworks.hg.util.resources.RES_rasterhelper");

    public static BufferedImage getFrameImage(Component component, boolean bl) throws OutputHelperProcessingException {
        if (component == null) {
            return null;
        }
        assert (SwingUtilities.isEventDispatchThread());
        Window window = SwingUtilities.getWindowAncestor(component);
        if (window == null) {
            return null;
        }
        Container container = bl ? window : component.getParent();
        if (container == null) {
            return null;
        }
        HGGetframeOutputHelper hGGetframeOutputHelper = new HGGetframeOutputHelper(container);
        hGGetframeOutputHelper.open(null);
        hGGetframeOutputHelper.generateOutput(null);
        hGGetframeOutputHelper.close();
        BufferedImage bufferedImage = hGGetframeOutputHelper.getBufferedImage();
        hGGetframeOutputHelper.release();
        if (bl && PlatformInfo.isMacintosh()) {
            Object object;
            DTTitleBar dTTitleBar = new DTTitleBar(false, false, false, "GetFrame");
            dTTitleBar.setSize(bufferedImage.getWidth(), 23);
            dTTitleBar.setLocation(0, 0);
            if (window instanceof Frame) {
                object = (Frame)window;
                dTTitleBar.setTitle(((Frame)object).getTitle());
            }
            dTTitleBar.doLayout();
            object = bufferedImage.getGraphics();
            dTTitleBar.paint((Graphics)object);
            ((Graphics)object).dispose();
        }
        if (bl) {
            component.invalidate();
            component.getParent().validate();
        }
        return bufferedImage;
    }

    public HGGetframeOutputHelper(Container container) {
        super(new MPrintJob());
        this.fPrintJob.setDPI(GraphicsDeviceUtilities.getDefaultScreenResolution());
        this.fPrintJob.setScaledDPI(this.fPrintJob.getDPI());
        this.fPrintJob.setDesired_Width(container.getWidth());
        this.fPrintJob.setDesired_Height(container.getHeight());
        this.fPrintJob.setTransparent(false);
        this.fContainer = container;
    }

    @Override
    public void open(FigurePanelContainer figurePanelContainer) throws OutputHelperProcessingException {
    }

    @Override
    public void generateOutput(FigurePanelContainer figurePanelContainer) throws OutputHelperProcessingException {
        assert (figurePanelContainer == null);
        this.validateContainerState(this.fContainer);
        double d = this.fPrintJob.getDPI();
        assert (d > 0.0);
        this.fException = null;
        try {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    assert (GraphicsEnvironment.isHeadless() || HGGetframeOutputHelper.this.fContainer.isDisplayable()) : "Expected the container to be displayable before generating output.";
                    HGGetframeOutputHelper.this.validateContainerSize(HGGetframeOutputHelper.this.fContainer);
                    int n = HGGetframeOutputHelper.this.fContainer.getWidth();
                    int n2 = HGGetframeOutputHelper.this.fContainer.getHeight();
                    HGGetframeOutputHelper.this.fBufferedImage = new BufferedImage(n, n2, 1);
                    assert (HGGetframeOutputHelper.this.fBufferedImage != null) : "Unable to create a buffered image of size " + n + " x " + n2;
                    Graphics2D graphics2D = HGGetframeOutputHelper.this.fBufferedImage.createGraphics();
                    Dimension dimension = HGGetframeOutputHelper.this.fContainer.getSize();
                    Rectangle rectangle = new Rectangle(0, 0, n, n2);
                    PrintUtilities.setGraphicsPosition(graphics2D, dimension, rectangle);
                    HGGetframeOutputHelper.this.prePrint(HGGetframeOutputHelper.this.fContainer);
                    try {
                        HGGetframeOutputHelper.this.fContainer.printAll(graphics2D);
                    }
                    catch (Exception exception) {
                        HGGetframeOutputHelper.this.fException = exception;
                    }
                    finally {
                        HGGetframeOutputHelper.this.postPrint();
                    }
                    graphics2D.dispose();
                }
            };
            AWTUtilities.invokeAndWait((Runnable)runnable);
            if (this.fException != null) {
                throw this.fException;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new OutputHelperProcessingException(new RasterSizeException(outOfMemoryError));
        }
        catch (Throwable throwable) {
            throw new OutputHelperProcessingException(throwable);
        }
    }

    @Override
    public void close() throws OutputHelperProcessingException {
    }

    @Override
    public boolean supportsGettingCDataFromBufferedImage() {
        return true;
    }

    @Override
    public BufferedImage getBufferedImage() {
        return this.fBufferedImage;
    }

    @Override
    public boolean supportsGettingDataForClipboard() {
        return this.supportsGettingCDataFromBufferedImage();
    }

    @Override
    public ByteArrayOutputStream getDataForClipboard() throws OutputHelperProcessingException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        if (this.fBufferedImage != null && this.fBufferedImage.getWidth() > 0 && this.fBufferedImage.getHeight() > 0) {
            byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                String[] stringArray = new String[]{"png", "jpg", "gif", "bmp"};
                String string = "";
                int n = 0;
                do {
                    Iterator<ImageWriter> iterator;
                    if (!(iterator = ImageIO.getImageWritersByFormatName(stringArray[n])).hasNext()) continue;
                    string = stringArray[n];
                } while (string.isEmpty() && n < stringArray.length);
                if (string.isEmpty()) {
                    throw new OutputHelperProcessingException(sRasterHelperInfo.getString("raster.insufficientImageSupportForClipboard"));
                }
                ImageIO.write((RenderedImage)this.fBufferedImage, "png", byteArrayOutputStream);
                byteArrayOutputStream.flush();
            }
            catch (IOException iOException) {
                byteArrayOutputStream = null;
            }
        }
        if (byteArrayOutputStream == null) {
            throw new OutputHelperProcessingException(sRasterHelperInfo.getString("raster.errorRetrievingRasterDataForClipboard"));
        }
        return byteArrayOutputStream;
    }

    @Override
    public void release() throws OutputHelperProcessingException {
        this.fBufferedImage = null;
    }

    public static class BufferedImageGrabber {
        private final Container fContainer;
        private BufferedImage fBufferedImage;
        private OutputHelperProcessingException fOutputHelperProcessingException = null;
        private HGGetframeOutputHelper fHelper = null;

        public BufferedImageGrabber(Container container) {
            this.fContainer = container;
        }

        public BufferedImage getBufferedImage() throws OutputHelperProcessingException {
            this.grab();
            return this.fBufferedImage;
        }

        private void grabOnEDT() {
            try {
                this.fHelper = new HGGetframeOutputHelper(this.fContainer);
                this.fHelper.generateOutput(null);
                this.fBufferedImage = this.fHelper.getBufferedImage();
            }
            catch (OutputHelperProcessingException outputHelperProcessingException) {
                this.fOutputHelperProcessingException = outputHelperProcessingException;
            }
        }

        private void grab() throws OutputHelperProcessingException {
            if (GraphicsEnvironment.isHeadless() || OffscreenWindowProvider.isComponentInOffscreenWindow(this.fContainer)) {
                return;
            }
            this.fOutputHelperProcessingException = null;
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        BufferedImageGrabber.this.grabOnEDT();
                    }
                });
            }
            catch (Throwable throwable) {
                this.fOutputHelperProcessingException = new OutputHelperProcessingException(throwable);
            }
            if (this.fOutputHelperProcessingException != null) {
                throw this.fOutputHelperProcessingException;
            }
        }
    }

    public static class RasterSizeException
    extends Exception {
        public RasterSizeException(Throwable throwable) {
            super(throwable);
        }
    }
}

