/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.util;

import com.mathworks.hg.util.StringScrollListChooser;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class FontChooser
extends MJPanel
implements ActionListener {
    int fontNameColSpan = 8;
    int fontStyleColSpan = 3;
    int fontSizeColSpan = 1;
    int sampleSpan = 12;
    MJPanel c;
    MJPanel labelPanel;
    MJPanel fontPanel;
    GridBagConstraints constraints;
    StringScrollListChooser fontName;
    StringScrollListChooser fontSize;
    StringScrollListChooser fontStyle;
    MJLabel previewLabel;
    SimpleAttributeSet attributes;
    Font selectedFont;
    Color newColor;
    String[] defaultFontNames = new String[]{"TimesRoman", "Helvetica", "Courier"};
    String bundleName = "com.mathworks.hg.util.resources.RES_FontChooserResources";
    String previewText = null;
    String fontLabelString = null;
    String sizeLabelString = null;
    String previewBorderText = null;
    String styleLabelString = null;
    String defaultTitle = null;

    public void setLookAndFeel(String string) {
    }

    public String getDefaultTitle() {
        return this.defaultTitle;
    }

    public void loadStringResources() {
        try {
            PropertyResourceBundle propertyResourceBundle = (PropertyResourceBundle)ResourceBundle.getBundle(this.bundleName);
            this.previewText = propertyResourceBundle.getString("previewText");
            this.previewBorderText = propertyResourceBundle.getString("previewBorderText");
            this.fontLabelString = propertyResourceBundle.getString("fontLabelString");
            this.sizeLabelString = propertyResourceBundle.getString("sizeLabelString");
            this.styleLabelString = propertyResourceBundle.getString("styleLabelString");
            this.defaultTitle = propertyResourceBundle.getString("defaultTitle");
        }
        catch (Exception exception) {
            System.out.println("Error opening dFontChooserResources");
        }
    }

    public FontChooser(String[] stringArray, String string) {
        this.loadStringResources();
        this.setSize(450, 450);
        this.attributes = new SimpleAttributeSet();
        this.setLayout(new BorderLayout());
        if (null == stringArray | 0 == stringArray.length) {
            stringArray = this.defaultFontNames;
        }
        MJPanel mJPanel = new MJPanel();
        mJPanel.setLayout((LayoutManager)new GridBagLayout());
        this.constraints = new GridBagConstraints();
        this.constraints.weightx = 100.0;
        this.constraints.weighty = 100.0;
        this.constraints.fill = 1;
        this.setConstraints(0, 0, this.fontNameColSpan, 1);
        mJPanel.add((Component)new MJLabel(this.fontLabelString), (Object)this.constraints);
        this.setConstraints(0, 8, this.fontStyleColSpan, 1);
        mJPanel.add((Component)new MJLabel(this.styleLabelString), (Object)this.constraints);
        this.setConstraints(0, 11, this.fontSizeColSpan, 1);
        mJPanel.add((Component)new MJLabel(this.sizeLabelString), (Object)this.constraints);
        this.fontName = new StringScrollListChooser(stringArray);
        this.fontName.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.setConstraints(1, 0, this.fontNameColSpan, 9);
        mJPanel.add((Component)this.fontName, (Object)this.constraints);
        this.fontStyle = new StringScrollListChooser(new String[]{"Regular", "Italic", "Bold", "Bold Italic"});
        this.fontStyle.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.setConstraints(1, 8, this.fontStyleColSpan, 9);
        mJPanel.add((Component)this.fontStyle, (Object)this.constraints);
        this.fontSize = new StringScrollListChooser(new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"});
        this.fontSize.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.setConstraints(1, 11, this.fontSizeColSpan, 9);
        mJPanel.add((Component)this.fontSize, (Object)this.constraints);
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new BorderLayout());
        this.previewLabel = new MJLabel(this.previewText, 0);
        this.previewLabel.setBorder((Border)new TitledBorder(this.previewBorderText));
        mJPanel2.add((Component)this.previewLabel, (Object)"Center");
        this.setConstraints(10, 0, 12, 5);
        mJPanel.add((Component)mJPanel2, (Object)this.constraints);
        this.add((Component)mJPanel, "Center");
    }

    public void addSampleTextActionListeners() {
        this.fontName.addListener(this);
        this.fontStyle.addListener(this);
        this.fontSize.addListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.setUpAttributes();
        this.updatePreviewFont();
    }

    public void setUpAttributes() {
        int n = 0;
        String string = "";
        string = this.fontSize.getSelectedValue();
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            MJOptionPane.showMessageDialog((Component)((Object)this), (Object)"Error - font size must be a number.");
            return;
        }
        if (!StyleConstants.getFontFamily(this.attributes).equals(this.fontName.getSelectedValue())) {
            StyleConstants.setFontFamily(this.attributes, this.fontName.getSelectedValue());
        }
        StyleConstants.setFontSize(this.attributes, Integer.parseInt(this.fontSize.getSelectedValue()));
        String string2 = this.fontStyle.getSelectedValue();
        string2 = string2.toLowerCase();
        boolean bl = false;
        boolean bl2 = false;
        if (-1 != string2.indexOf("bold")) {
            bl = true;
        }
        if (-1 != string2.indexOf("italic")) {
            bl2 = true;
        }
        StyleConstants.setBold(this.attributes, bl);
        StyleConstants.setItalic(this.attributes, bl2);
    }

    public void updatePreviewFont() {
        Font font;
        String string = StyleConstants.getFontFamily(this.attributes);
        boolean bl = StyleConstants.isBold(this.attributes);
        boolean bl2 = StyleConstants.isItalic(this.attributes);
        int n = StyleConstants.getFontSize(this.attributes);
        this.selectedFont = font = new Font(string, (bl ? 1 : 0) + (bl2 ? 2 : 0), n);
        this.previewLabel.setFont(font);
    }

    public String getFontName() {
        return this.selectedFont.getName();
    }

    public int getFontSize() {
        return this.selectedFont.getSize();
    }

    public String getFontWeight() {
        if (this.selectedFont.isBold()) {
            return "bold";
        }
        return "normal";
    }

    public String getFontAngle() {
        if (this.selectedFont.isItalic()) {
            return "italic";
        }
        return "normal";
    }

    public AttributeSet getAttributes() {
        return this.attributes;
    }

    public void test(String[] stringArray) {
    }

    public void selectFontName(String string) {
        this.fontName.setSelectedItem(string);
        this.fontName.setSelectedValue(string, true);
    }

    public void selectFontSize(int n) {
        String string = Integer.toString(n);
        this.fontSize.setSelectedItem(string);
        this.fontSize.setSelectedValue(string, true);
    }

    public void selectFontStyle(String string) {
        this.fontStyle.setSelectedItem(string);
        this.fontStyle.setSelectedValue(string, true);
    }

    public void setConstraints(int n, int n2, int n3, int n4) {
        this.constraints.gridx = n2;
        this.constraints.gridy = n;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
    }
}

