/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types.table.panel;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;
import com.mathworks.common.icons.CommonIcon;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.MJEditorPane;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class MessagePanel
extends MJPanel {
    private MJLabel iconLabel;
    private MJEditorPane textEditorPane;
    private MJScrollPane textScrollPane;
    private Icon infoIcon;
    private String infoText;

    public MessagePanel(String string) {
        this(string, CommonIcon.INFO.getIcon());
    }

    public MessagePanel(String string, Icon icon) {
        this.setMessage(string);
        this.setIcon(icon);
        this.buildMessagePanel();
    }

    public void setMessage(String string) {
        this.infoText = string;
        if (this.textEditorPane != null) {
            this.textEditorPane.setText(string);
            this.textEditorPane.setCaretPosition(0);
            this.textScrollPane.getVerticalScrollBar().setValue(0);
        }
    }

    public String getMessage() {
        return this.infoText;
    }

    public void setIcon(Icon icon) {
        this.infoIcon = icon;
        if (this.iconLabel != null) {
            this.iconLabel.setIcon(icon);
            this.iconLabel.setVisible(icon != null);
        }
    }

    public Icon getIcon() {
        return this.infoIcon;
    }

    private void buildMessagePanel() {
        this.iconLabel = new MJLabel(this.getIcon());
        this.textEditorPane = new MJEditorPane();
        this.textEditorPane.setContentType(new HTMLEditorKit().getContentType());
        this.textEditorPane.setOpaque(false);
        this.textEditorPane.setEditable(false);
        this.addHyperlinkListener();
        Font font = UIManager.getFont("Label.font");
        String string = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; }";
        ((HTMLDocument)this.textEditorPane.getDocument()).getStyleSheet().addRule(string);
        this.textEditorPane.setText(this.getMessage());
        int n = Sizes.dialogUnitYAsPixel((int)4, (Component)((Object)this));
        int n2 = n / 2;
        int n3 = n - n2;
        this.textEditorPane.setMargin(new Insets(n2, 0, n3, 0));
        this.textScrollPane = new MJScrollPane((Component)this.textEditorPane, 20, 31);
        this.textScrollPane.setOpaque(false);
        this.textScrollPane.getViewport().setOpaque(false);
        this.textScrollPane.setBorder(null);
        FormLayout formLayout = new FormLayout("4dlu, p, 4dlu, 0dlu:g(1.0)", "0dlu:g(1.0)");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)((Object)this));
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.iconLabel, cellConstraints.xy(2, 1));
        panelBuilder.add((Component)this.textScrollPane, cellConstraints.xywh(4, 1, 1, 1, "fill, fill"));
        this.iconLabel.setVisible(this.getIcon() != null);
        this.setBackground(SystemColor.text);
        this.setForeground(SystemColor.textText);
        this.setBorder(BorderFactory.createLineBorder(SystemColor.controlShadow));
        this.setPreferredSize(new Dimension(10, this.getPanelHeight()));
    }

    private void addHyperlinkListener() {
        HyperlinkListener hyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String string = hyperlinkEvent.getURL().getPath().substring(1);
                    int n = string.indexOf("|");
                    String string2 = string.substring(0, n);
                    string = string.substring(n + 1);
                    String string3 = MLHelpServices.getDocRoot() + "/" + string2;
                    MLHelpServices.cshDisplayTopic((Object)((JComponent)hyperlinkEvent.getSource()).getTopLevelAncestor(), (String)string3, (String)string);
                }
            }
        };
        this.textEditorPane.addHyperlinkListener(hyperlinkListener);
    }

    private int getPanelHeight() {
        JLabel jLabel = new JLabel();
        FontMetrics fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
        int n = fontMetrics.getHeight() * 2;
        n += Sizes.dialogUnitYAsPixel((int)4, (Component)((Object)this));
        return n += this.getBorder().getBorderInsets((Component)((Object)this)).top * 2;
    }
}

