/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types;

import com.mathworks.hg.types.AlphaCategory;
import com.mathworks.hg.types.AlphaEnum;
import com.mathworks.util.InvalidValueException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.math.DoubleRange;

public final class AlphaSpec {
    private final boolean isCategorical;
    private static final DoubleRange range = new DoubleRange(0.0, 1.0);
    private final double value;
    private final AlphaEnum alphaEnum;
    private final AlphaCategory category;

    public AlphaSpec(double d, AlphaCategory alphaCategory) {
        if (alphaCategory == null) {
            throw new IllegalArgumentException("Argument category must not be null.");
        }
        if (!range.containsDouble(d)) {
            throw new IllegalArgumentException("Argument value is out of bounds.");
        }
        this.isCategorical = false;
        this.alphaEnum = AlphaEnum.ALPHA;
        this.value = d;
        this.category = alphaCategory;
    }

    public AlphaSpec(AlphaEnum alphaEnum, AlphaCategory alphaCategory) {
        if (alphaCategory == null) {
            throw new IllegalArgumentException("Argument category must not be null.");
        }
        assert (alphaCategory.getElements().contains((Object)alphaEnum)) : "Invalid alphaEnum argument: " + (Object)((Object)alphaEnum);
        this.isCategorical = true;
        this.alphaEnum = alphaEnum;
        this.value = 1.0;
        this.category = alphaCategory;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (object == this) {
            return true;
        }
        if (!(object instanceof AlphaSpec)) {
            return false;
        }
        AlphaSpec alphaSpec = (AlphaSpec)object;
        boolean bl2 = bl = this.isCategorical == alphaSpec.isCategorical && this.category == alphaSpec.category;
        if (!bl) {
            return false;
        }
        if (this.isCategorical) {
            return this.alphaEnum == alphaSpec.alphaEnum;
        }
        return Double.compare(this.value, alphaSpec.value) == 0;
    }

    public boolean isCategorical() {
        return this.isCategorical;
    }

    public AlphaCategory getCategory() {
        return this.category;
    }

    public DoubleRange getRange() {
        return range;
    }

    public AlphaEnum getCategoricalValue() {
        return this.alphaEnum;
    }

    public double getContinuousValue() {
        return this.value;
    }

    public String toStringRepresentation() {
        if (this.isCategorical) {
            return this.alphaEnum.getSpecification();
        }
        return Double.toString(this.value);
    }

    public static AlphaSpec fromStringRepresentation(String string, AlphaCategory alphaCategory) throws InvalidValueException {
        if (alphaCategory == null) {
            throw new IllegalArgumentException("Argument category must not be null");
        }
        String string2 = StringUtils.stripToNull((String)string);
        if (string2 == null) {
            throw new InvalidValueException((Object)string, "Invalid value");
        }
        String[] stringArray = StringUtils.split((String)string2);
        if (stringArray == null || stringArray.length == 0) {
            throw new InvalidValueException((Object)string, "Invalid value");
        }
        string2 = stringArray[0].toLowerCase();
        string2 = StringUtils.removeStart((String)string2, (String)"'");
        string2 = StringUtils.removeEnd((String)string2, (String)"'");
        try {
            double d = Double.parseDouble(string2);
            if (!range.containsDouble(d)) {
                throw new InvalidValueException((Object)d, "Valid range is [" + range.getMinimumDouble() + "," + range.getMaximumDouble() + "]");
            }
            return new AlphaSpec(d, alphaCategory);
        }
        catch (NumberFormatException numberFormatException) {
            for (AlphaEnum alphaEnum : alphaCategory.getElements()) {
                String string3 = alphaEnum.getSpecification().toLowerCase();
                if (!string3.startsWith(string2)) continue;
                return new AlphaSpec(alphaEnum, alphaCategory);
            }
            throw new InvalidValueException((Object)string2, "Invalid value");
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

