/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.print.metafile;

import com.mathworks.hg.print.metafile.GeomUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.util.Map;

public class GraphicsState {
    private AffineTransform fTransform = new AffineTransform();
    private Shape fClip = null;
    private Font fFont = new Font("Dialog", 0, 12);
    private Color fColor = Color.WHITE;
    private Paint fPaint = Color.WHITE;
    private Color fBackground = Color.BLACK;
    private Stroke fStroke = new BasicStroke();
    private Composite fComposite = AlphaComposite.SrcOver;
    private RenderingHints fHints = new RenderingHints(null);

    public GraphicsState() {
    }

    public GraphicsState(GraphicsState graphicsState) {
        if (graphicsState.fTransform != null) {
            this.fTransform = (AffineTransform)graphicsState.fTransform.clone();
        }
        if (graphicsState.fClip != null) {
            this.fClip = graphicsState.fClip instanceof Rectangle ? new Rectangle((Rectangle)graphicsState.fClip) : new Area(graphicsState.fClip);
        }
        this.fHints = (RenderingHints)graphicsState.fHints.clone();
        this.fComposite = graphicsState.fComposite;
        this.fPaint = graphicsState.fPaint;
        this.fStroke = graphicsState.fStroke;
        this.fFont = graphicsState.fFont;
        this.fColor = graphicsState.fColor;
        this.fBackground = graphicsState.fBackground;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof GraphicsState && this.equals((GraphicsState)object);
    }

    public boolean equals(GraphicsState graphicsState) {
        return this.equalsWithNullEquality(graphicsState.fTransform, this.fTransform) && this.equalsWithNullEquality(graphicsState.fClip, this.fClip) && this.equalsWithNullEquality(graphicsState.fFont, this.fFont) && this.equalsWithNullEquality(graphicsState.fPaint, this.fPaint) && this.equalsWithNullEquality(graphicsState.fColor, this.fColor) && this.equalsWithNullEquality(graphicsState.fBackground, this.fBackground) && this.equalsWithNullEquality(graphicsState.fStroke, this.fStroke) && this.equalsWithNullEquality(graphicsState.fComposite, this.fComposite) && this.equalsWithNullEquality(graphicsState.fHints, this.fHints);
    }

    private boolean equalsWithNullEquality(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    private void alterTransform(Runnable runnable) {
        Shape shape = GeomUtils.transformShape(this.fTransform, this.fClip);
        runnable.run();
        AffineTransform affineTransform = null;
        if (this.fTransform != null) {
            try {
                affineTransform = this.fTransform.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                affineTransform = new AffineTransform();
            }
        }
        this.fClip = GeomUtils.transformShape(affineTransform, shape);
    }

    public void setTransform(final AffineTransform affineTransform) {
        this.alterTransform(new Runnable(){

            @Override
            public void run() {
                GraphicsState.this.fTransform = affineTransform;
            }
        });
    }

    public AffineTransform getTransform() {
        if (this.fTransform != null) {
            return (AffineTransform)this.fTransform.clone();
        }
        return null;
    }

    private void ensureNonNullTransform() {
        if (this.fTransform == null) {
            this.fTransform = new AffineTransform();
        }
    }

    public void transform(final AffineTransform affineTransform) {
        this.ensureNonNullTransform();
        this.alterTransform(new Runnable(){

            @Override
            public void run() {
                GraphicsState.this.fTransform.concatenate(affineTransform);
            }
        });
    }

    public void translate(final int n, final int n2) {
        if (n != 0 || n2 != 0) {
            this.ensureNonNullTransform();
            this.alterTransform(new Runnable(){

                @Override
                public void run() {
                    GraphicsState.this.fTransform.translate(n, n2);
                }
            });
        }
    }

    public void translate(final double d, final double d2) {
        if (d != 0.0 || d2 != 0.0) {
            this.ensureNonNullTransform();
            this.alterTransform(new Runnable(){

                @Override
                public void run() {
                    GraphicsState.this.fTransform.translate(d, d2);
                }
            });
        }
    }

    public void rotate(final double d) {
        this.ensureNonNullTransform();
        this.alterTransform(new Runnable(){

            @Override
            public void run() {
                GraphicsState.this.fTransform.rotate(d);
            }
        });
    }

    public void rotate(final double d, final double d2, final double d3) {
        this.ensureNonNullTransform();
        this.alterTransform(new Runnable(){

            @Override
            public void run() {
                GraphicsState.this.fTransform.rotate(d, d2, d3);
            }
        });
    }

    public void scale(final double d, final double d2) {
        this.ensureNonNullTransform();
        this.alterTransform(new Runnable(){

            @Override
            public void run() {
                GraphicsState.this.fTransform.scale(d, d2);
            }
        });
    }

    public void shear(final double d, final double d2) {
        this.ensureNonNullTransform();
        this.alterTransform(new Runnable(){

            @Override
            public void run() {
                GraphicsState.this.fTransform.shear(d, d2);
            }
        });
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.clip(new Rectangle(n, n2, n3, n4));
    }

    public void clip(Shape shape) {
        if (this.fClip == null) {
            this.setClip(shape);
        } else if (this.fClip instanceof Rectangle2D && shape instanceof Rectangle2D) {
            this.fClip = ((Rectangle2D)this.fClip).createIntersection((Rectangle2D)shape);
        } else {
            if (!(this.fClip instanceof Area)) {
                this.fClip = new Area(this.fClip);
            }
            ((Area)this.fClip).intersect(new Area(shape));
        }
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.setClip(new Rectangle(n, n2, n3, n4));
    }

    public Shape getClip() {
        return this.fClip;
    }

    public void setClip(Shape shape) {
        this.fClip = shape;
    }

    public Rectangle getClipBounds() {
        if (this.fClip == null) {
            return null;
        }
        return this.fClip.getBounds();
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.fHints.put(key, object);
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this.fHints.get(key);
    }

    public void setRenderingHints(Map<?, ?> map) {
        this.fHints.clear();
        this.fHints.putAll(map);
    }

    public void addRenderingHints(Map<?, ?> map) {
        this.fHints.putAll(map);
    }

    public RenderingHints getRenderingHints() {
        return this.fHints;
    }

    public void setPaint(Paint paint) {
        this.fPaint = paint;
        if (paint instanceof Color) {
            this.fColor = (Color)paint;
        }
    }

    public Paint getPaint() {
        return this.fPaint;
    }

    public void setStroke(Stroke stroke) {
        this.fStroke = stroke;
    }

    public Stroke getStroke() {
        return this.fStroke;
    }

    public Color getBackground() {
        return this.fBackground;
    }

    public void setBackground(Color color) {
        this.fBackground = color;
    }

    public Color getColor() {
        return this.fColor;
    }

    public void setColor(Color color) {
        this.fColor = color;
        this.fPaint = color;
    }

    public Font getFont() {
        return this.fFont;
    }

    public void setFont(Font font) {
        if (font != null) {
            this.fFont = font;
        }
    }

    public void setComposite(Composite composite) {
        this.fComposite = composite;
    }

    public Composite getComposite() {
        return this.fComposite;
    }
}

