/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.print.metafile;

import com.mathworks.hg.print.metafile.EMFDocument;
import com.mathworks.hg.print.metafile.GraphicsState;
import com.mathworks.hg.print.metafile.MinimalGraphics2D;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.util.Map;

public class EMFGraphics2D
extends MinimalGraphics2D {
    private GraphicsState fState = new GraphicsState();
    private EMFDocument fDocument;

    public EMFGraphics2D(EMFDocument eMFDocument) {
        this.fDocument = eMFDocument;
        this.fState.setTransform(this.getDeviceConfiguration().getDefaultTransform());
    }

    public EMFGraphics2D(EMFDocument eMFDocument, GraphicsState graphicsState) {
        this.fDocument = eMFDocument;
        this.fState = graphicsState;
    }

    @Override
    public Graphics create() {
        return new EMFGraphics2D(this.fDocument, new GraphicsState(this.fState));
    }

    @Override
    public Graphics create(int n, int n2, int n3, int n4) {
        Graphics graphics = this.create();
        graphics.translate(n, n2);
        graphics.clipRect(0, 0, n3, n4);
        return graphics;
    }

    @Override
    public void dispose() {
    }

    public GraphicsState getState() {
        return this.fState;
    }

    public EMFDocument getDocument() {
        return this.fDocument;
    }

    @Override
    public void translate(int n, int n2) {
        this.fState.translate(n, n2);
    }

    @Override
    public void translate(double d, double d2) {
        this.fState.translate(d, d2);
    }

    @Override
    public void rotate(double d) {
        this.fState.rotate(d);
    }

    @Override
    public void rotate(double d, double d2, double d3) {
        this.fState.rotate(d, d2, d3);
    }

    @Override
    public void scale(double d, double d2) {
        this.fState.scale(d, d2);
    }

    @Override
    public void shear(double d, double d2) {
        this.fState.shear(d, d2);
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        this.fState.transform(affineTransform);
    }

    @Override
    public void setTransform(AffineTransform affineTransform) {
        this.fState.setTransform(affineTransform);
    }

    @Override
    public AffineTransform getTransform() {
        return this.fState.getTransform();
    }

    @Override
    public Paint getPaint() {
        return this.fState.getPaint();
    }

    @Override
    public void setPaint(Paint paint) {
        this.fState.setPaint(paint);
    }

    @Override
    public Stroke getStroke() {
        return this.fState.getStroke();
    }

    @Override
    public void setStroke(Stroke stroke) {
        this.fState.setStroke(stroke);
    }

    @Override
    public Color getBackground() {
        return this.fState.getBackground();
    }

    @Override
    public void setBackground(Color color) {
        this.fState.setBackground(color);
    }

    @Override
    public Color getColor() {
        return this.fState.getColor();
    }

    @Override
    public void setColor(Color color) {
        this.fState.setColor(color);
    }

    @Override
    public Font getFont() {
        return this.fState.getFont();
    }

    @Override
    public void setFont(Font font) {
        this.fState.setFont(font);
    }

    @Override
    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    @Override
    public void clipRect(int n, int n2, int n3, int n4) {
        this.fState.clipRect(n, n2, n3, n4);
    }

    @Override
    public void clip(Shape shape) {
        this.fState.clip(shape);
    }

    @Override
    public void setClip(int n, int n2, int n3, int n4) {
        this.fState.setClip(n, n2, n3, n4);
    }

    @Override
    public Shape getClip() {
        return this.fState.getClip();
    }

    @Override
    public void setClip(Shape shape) {
        this.fState.setClip(shape);
    }

    @Override
    public Rectangle getClipBounds() {
        return this.fState.getClipBounds();
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.fState.setRenderingHint(key, object);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key key) {
        return this.fState.getRenderingHint(key);
    }

    @Override
    public void setRenderingHints(Map<?, ?> map) {
        this.fState.setRenderingHints(map);
    }

    @Override
    public void addRenderingHints(Map<?, ?> map) {
        this.fState.addRenderingHints(map);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.fState.getRenderingHints();
    }

    @Override
    public void setComposite(Composite composite) {
        this.fState.setComposite(composite);
    }

    @Override
    public Composite getComposite() {
        return this.fState.getComposite();
    }

    @Override
    public void setPaintMode() {
        this.setComposite(AlphaComposite.SrcOver);
    }

    @Override
    public void setXORMode(Color color) {
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.fDocument.getFontRenderContext(this.fState.getRenderingHints());
    }

    @Override
    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        AffineTransform affineTransform;
        Shape shape2 = shape;
        if (bl) {
            shape2 = this.getStroke().createStrokedShape(shape2);
        }
        if ((affineTransform = this.getTransform()) != null) {
            shape2 = affineTransform.createTransformedShape(shape2);
        }
        return shape2.intersects(rectangle);
    }

    @Override
    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.fDocument.getDevice().getDefaultConfiguration();
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return this.fDocument.getFontMetrics(font, this.fState.getRenderingHints());
    }

    @Override
    public void clearRect(int n, int n2, int n3, int n4) {
        this.fDocument.clear(n, n2, n3, n4, this.fState);
    }

    @Override
    public void fill(Shape shape) {
        this.fDocument.fill(shape, this.fState);
    }

    @Override
    public void draw(Shape shape) {
        this.fDocument.draw(shape, this.fState);
    }

    @Override
    public void drawString(String string, float f, float f2) {
        this.fDocument.drawString(string, f, f2, this.fState);
    }

    @Override
    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        this.fDocument.drawImage(renderedImage, affineTransform, this.fState);
    }
}

