/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.print;

import com.mathworks.hg.print.Graphics2DDecorator;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;

public class RenderedImageDrawingGraphics2D
extends Graphics2DDecorator {
    public RenderedImageDrawingGraphics2D(Graphics graphics) {
        super(graphics);
    }

    @Override
    protected Graphics doCreateNew(Graphics graphics) {
        return new RenderedImageDrawingGraphics2D(graphics);
    }

    @Override
    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        if (!this.doRenderedDraw(image, this.createTransform(affineTransform))) {
            return super.drawImage(image, affineTransform, imageObserver);
        }
        return true;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (!this.doRenderedDraw(image, this.createLocationTransform(n, n2))) {
            return super.drawImage(image, n, n2, imageObserver);
        }
        return true;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        if (!this.doRenderedDraw(image, this.createBoundsTransform(image, n, n2, n3, n4, imageObserver))) {
            return super.drawImage(image, n, n2, n3, n4, imageObserver);
        }
        return true;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        if (!this.doRenderedDraw(image, color, this.createLocationTransform(n, n2))) {
            return super.drawImage(image, n, n2, color, imageObserver);
        }
        return true;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (!this.doRenderedDraw(image, color, this.createBoundsTransform(image, n, n2, n3, n4, imageObserver))) {
            return super.drawImage(image, n, n2, n3, n4, color, imageObserver);
        }
        return true;
    }

    @Override
    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        AffineTransform affineTransform2 = this.getTransform();
        this.transform(affineTransform);
        super.drawRenderedImage(renderedImage, new AffineTransform());
        this.setTransform(affineTransform2);
    }

    private boolean doRenderedDraw(Image image, TransformFactory transformFactory) {
        if (image instanceof RenderedImage) {
            this.drawRenderedImage((RenderedImage)((Object)image), transformFactory.createTransform());
            return true;
        }
        return false;
    }

    private boolean doRenderedDraw(Image image, Color color, TransformFactory transformFactory) {
        if (image instanceof RenderedImage) {
            RenderedImage renderedImage = (RenderedImage)((Object)image);
            AffineTransform affineTransform = this.getTransform();
            AffineTransform affineTransform2 = transformFactory.createTransform();
            this.transform(affineTransform2);
            Paint paint = this.getPaint();
            this.setPaint(color);
            this.fillRect(0, 0, renderedImage.getWidth(), renderedImage.getHeight());
            this.setPaint(paint);
            this.drawRenderedImage(renderedImage, new AffineTransform());
            this.setTransform(affineTransform);
            return true;
        }
        return false;
    }

    private TransformFactory createTransform(final AffineTransform affineTransform) {
        return new TransformFactory(){

            @Override
            public AffineTransform createTransform() {
                return affineTransform;
            }
        };
    }

    private TransformFactory createLocationTransform(final int n, final int n2) {
        return new TransformFactory(){

            @Override
            public AffineTransform createTransform() {
                return AffineTransform.getTranslateInstance(n, n2);
            }
        };
    }

    private TransformFactory createBoundsTransform(final Image image, final int n, final int n2, final int n3, final int n4, final ImageObserver imageObserver) {
        return new TransformFactory(){

            @Override
            public AffineTransform createTransform() {
                int n5 = image.getWidth(imageObserver);
                int n22 = image.getHeight(imageObserver);
                double d = (double)n3 / (double)n5;
                double d2 = (double)n4 / (double)n22;
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(n, n2);
                affineTransform.scale(d, d2);
                return affineTransform;
            }
        };
    }

    private static interface TransformFactory {
        public AffineTransform createTransform();
    }
}

