/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.print;

import com.mathworks.hg.print.Graphics2DDecorator;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

public class PenOffsetGraphics2D
extends Graphics2DDecorator {
    public PenOffsetGraphics2D(Graphics graphics) {
        super(graphics);
    }

    @Override
    protected Graphics doCreateNew(Graphics graphics) {
        return new PenOffsetGraphics2D(graphics);
    }

    @Override
    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        PenState penState = this.setPenForDrawing();
        super.draw3DRect(n, n2, n3, n4, bl);
        this.restorePenState(penState);
    }

    @Override
    public void drawLine(int n, int n2, int n3, int n4) {
        PenState penState = this.setPenForDrawing();
        super.drawLine(n, n2, n3, n4);
        this.restorePenState(penState);
    }

    @Override
    public void drawRect(int n, int n2, int n3, int n4) {
        PenState penState = this.setPenForDrawing();
        super.drawRect(n, n2, n3, n4);
        this.restorePenState(penState);
    }

    @Override
    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        PenState penState = this.setPenForDrawing();
        super.drawRoundRect(n, n2, n3, n4, n5, n6);
        this.restorePenState(penState);
    }

    @Override
    public void drawOval(int n, int n2, int n3, int n4) {
        PenState penState = this.setPenForDrawing();
        super.drawOval(n, n2, n3, n4);
        this.restorePenState(penState);
    }

    @Override
    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        PenState penState = this.setPenForDrawing();
        super.drawArc(n, n2, n3, n4, n5, n6);
        this.restorePenState(penState);
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        PenState penState = this.setPenForDrawing();
        super.drawPolyline(nArray, nArray2, n);
        this.restorePenState(penState);
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        PenState penState = this.setPenForDrawing();
        super.drawPolygon(nArray, nArray2, n);
        this.restorePenState(penState);
    }

    @Override
    public void drawPolygon(Polygon polygon) {
        PenState penState = this.setPenForDrawing();
        super.drawPolygon(polygon);
        this.restorePenState(penState);
    }

    private PenState setPenForDrawing() {
        PenState penState = new PenState(this);
        this.translate(0.5, 0.5);
        this.setStroke(new BasicStroke(1.0f, 2, 2));
        return penState;
    }

    private void restorePenState(PenState penState) {
        penState.restore(this);
    }

    private class PenState {
        private AffineTransform fTransform;
        private Stroke fStroke;

        public PenState(Graphics2D graphics2D) {
            this.fTransform = graphics2D.getTransform();
            this.fStroke = graphics2D.getStroke();
        }

        public void restore(Graphics2D graphics2D) {
            graphics2D.setTransform(this.fTransform);
            graphics2D.setStroke(this.fStroke);
        }
    }
}

