/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.print;

import com.mathworks.hg.print.ColorConverter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.WritableRaster;

public class OpaqueAlphaRemover
implements ColorConverter {
    @Override
    public Color convert(Graphics2D graphics2D, Color color) {
        return color;
    }

    @Override
    public Paint convertPaint(Graphics2D graphics2D, Paint paint) {
        return paint;
    }

    @Override
    public BufferedImage convertImage(Graphics2D graphics2D, BufferedImage bufferedImage) {
        if (this.hasOpaqueAlpha(bufferedImage)) {
            ColorModel colorModel = OpaqueAlphaRemover.createOpaqueColorModel(bufferedImage.getColorModel());
            if (colorModel == bufferedImage.getColorModel() || colorModel.getNumComponents() != bufferedImage.getColorModel().getNumComponents() - 1) {
                return bufferedImage;
            }
            WritableRaster writableRaster = this.stripLastBand(bufferedImage.getRaster());
            return new BufferedImage(colorModel, writableRaster, true, null);
        }
        return bufferedImage;
    }

    private boolean hasOpaqueAlpha(BufferedImage bufferedImage) {
        if (bufferedImage.getTransparency() != 1) {
            WritableRaster writableRaster = bufferedImage.getAlphaRaster();
            if (writableRaster == null || writableRaster.getNumBands() != 1) {
                return false;
            }
            int n = writableRaster.getSampleModel().getSampleSize(0);
            int n2 = (1 << n) - 1;
            for (int i = 0; i < bufferedImage.getWidth(); ++i) {
                for (int j = 0; j < bufferedImage.getHeight(); ++j) {
                    int n3 = writableRaster.getSample(i, j, 0);
                    if (n3 >= n2) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static ColorModel createOpaqueColorModel(ColorModel colorModel) {
        if (colorModel instanceof ComponentColorModel) {
            ComponentColorModel componentColorModel = (ComponentColorModel)colorModel;
            return new ComponentColorModel(componentColorModel.getColorSpace(), componentColorModel.getComponentSize(), false, false, 1, componentColorModel.getTransferType());
        }
        if (colorModel instanceof DirectColorModel) {
            DirectColorModel directColorModel = (DirectColorModel)colorModel;
            return new DirectColorModel(directColorModel.getColorSpace(), directColorModel.getPixelSize(), directColorModel.getRedMask(), directColorModel.getGreenMask(), directColorModel.getBlueMask(), 0, false, directColorModel.getTransferType());
        }
        return colorModel;
    }

    private WritableRaster stripLastBand(WritableRaster writableRaster) {
        int n = writableRaster.getNumBands();
        int[] nArray = new int[n - 1];
        for (int i = 0; i < n - 1; ++i) {
            nArray[i] = i;
        }
        return writableRaster.createWritableChild(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight(), writableRaster.getMinX(), writableRaster.getMinY(), nArray);
    }
}

