/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.print;

import com.mathworks.hg.peer.FigurePanelContainer;
import com.mathworks.hg.print.FontCachingGraphics2D;
import com.mathworks.hg.print.MWTextHandler;
import com.mathworks.jmi.Matlab;
import com.mathworks.util.FileUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.truetype.TTFFontLoader;
import org.apache.fop.fonts.type1.Type1FontLoader;
import org.apache.fop.render.DefaultFontResolver;
import org.apache.fop.svg.PDFDocumentGraphics2D;
import org.apache.fop.svg.PDFDocumentGraphics2DConfigurator;
import org.apache.xmlgraphics.java2d.TextHandler;
import org.apache.xmlgraphics.java2d.ps.AbstractPSDocumentGraphics2D;
import org.apache.xmlgraphics.java2d.ps.PSGraphics2D;

public class FOPFontConfigurator {
    private static FontCreator sTTFCreatorInstance = new TTFCreator();
    private static FontCreator sType1CreatorInstance = new Type1Creator();
    private static FontCache sLoadedFonts = new FontCache();

    public static void configurePDFFonts(PDFDocumentGraphics2D pDFDocumentGraphics2D, FigurePanelContainer figurePanelContainer) throws ConfigurationException {
        PDFDocumentGraphics2DConfigurator pDFDocumentGraphics2DConfigurator = new PDFDocumentGraphics2DConfigurator();
        pDFDocumentGraphics2DConfigurator.configure(pDFDocumentGraphics2D, FOPFontConfigurator.createCMFontsConfiguration(FOPFontConfigurator.getCMTrueTypeFontPath(), ".ttf", sTTFCreatorInstance, figurePanelContainer), false);
    }

    public static void configurePSFonts(AbstractPSDocumentGraphics2D abstractPSDocumentGraphics2D, FigurePanelContainer figurePanelContainer) throws FOPException {
        FontInfo fontInfo = PDFDocumentGraphics2DConfigurator.createFontInfo((Configuration)FOPFontConfigurator.createCMFontsConfiguration(FOPFontConfigurator.getCMType1FontPath(), ".pfb", sType1CreatorInstance, figurePanelContainer), (boolean)false);
        abstractPSDocumentGraphics2D.setCustomTextHandler((TextHandler)new MWTextHandler((PSGraphics2D)abstractPSDocumentGraphics2D, fontInfo));
    }

    public static boolean canLoadTexFonts() {
        File file = new File(FOPFontConfigurator.getCMType1FontPath(), "mwa_cmb10.pfb");
        return sType1CreatorInstance.createFont(file) != null;
    }

    public static Vector<String> getCMFontNames() {
        Vector<String> vector = new Vector<String>();
        Map<File, CustomFont> map = FOPFontConfigurator.getFonts(FOPFontConfigurator.getCMTrueTypeFontPath(), ".ttf", sTTFCreatorInstance);
        for (Map.Entry<File, CustomFont> entry : map.entrySet()) {
            vector.add(FOPFontConfigurator.getCMFontName(entry.getKey(), entry.getValue()));
        }
        return vector;
    }

    private static Configuration createCMFontsConfiguration(File file, String string, FontCreator fontCreator, FigurePanelContainer figurePanelContainer) {
        DefaultConfiguration defaultConfiguration = new DefaultConfiguration("cfg");
        DefaultConfiguration defaultConfiguration2 = new DefaultConfiguration("use-cache");
        defaultConfiguration2.setValue(true);
        defaultConfiguration.addChild((Configuration)defaultConfiguration2);
        DefaultConfiguration defaultConfiguration3 = new DefaultConfiguration("cache-file");
        defaultConfiguration3.setValue(FOPFontConfigurator.getFOPFontCache().getAbsolutePath());
        defaultConfiguration.addChild((Configuration)defaultConfiguration3);
        DefaultConfiguration defaultConfiguration4 = new DefaultConfiguration("fonts");
        defaultConfiguration.addChild((Configuration)defaultConfiguration4);
        FOPFontConfigurator.loadFonts(defaultConfiguration4, file, string, fontCreator, figurePanelContainer);
        return defaultConfiguration;
    }

    private static File getFOPFontCache() {
        File file = new File(FileUtils.getPreferencesDirectory(), "fop");
        if (!file.exists()) {
            file.mkdirs();
        }
        return new File(file, "fop.cache");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadFonts(DefaultConfiguration defaultConfiguration, File file, String string, FontCreator fontCreator, FigurePanelContainer figurePanelContainer) {
        boolean bl = false;
        FontCachingGraphics2D fontCachingGraphics2D = null;
        try {
            if (figurePanelContainer != null) {
                fontCachingGraphics2D = new FontCachingGraphics2D(figurePanelContainer.getTargetContainer());
                bl = fontCachingGraphics2D.usesComputerModernFonts();
            }
            if (!bl) {
                return;
            }
            Map<File, CustomFont> map = FOPFontConfigurator.getFonts(file, string, fontCreator);
            for (Map.Entry<File, CustomFont> entry : map.entrySet()) {
                CustomFont customFont = entry.getValue();
                String string2 = FOPFontConfigurator.getCMFontName(entry.getKey(), customFont);
                String string3 = entry.getKey().toURI().toString();
                String string4 = entry.getValue().getFontSubName();
                if (string4 == null) {
                    string4 = "";
                }
                boolean bl2 = string4.equals("Bold");
                if (fontCachingGraphics2D != null && !fontCachingGraphics2D.usesFont(customFont)) continue;
                DefaultConfiguration defaultConfiguration2 = FOPFontConfigurator.generateFont(string2, string3, bl2);
                defaultConfiguration.addChild((Configuration)defaultConfiguration2);
            }
        }
        finally {
            if (fontCachingGraphics2D != null) {
                fontCachingGraphics2D.dispose();
            }
        }
    }

    private static Map<File, CustomFont> getFonts(File file, final String string, FontCreator fontCreator) {
        HashMap<File, CustomFont> hashMap = new HashMap<File, CustomFont>();
        File[] fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string2) {
                return string2.toLowerCase().endsWith(string);
            }
        });
        if (fileArray != null) {
            for (File file2 : fileArray) {
                CustomFont customFont = fontCreator.createFont(file2);
                if (customFont == null) continue;
                hashMap.put(file2, customFont);
            }
        }
        return hashMap;
    }

    private static String getCMFontName(File file, CustomFont customFont) {
        String string = file.getName();
        return string.substring(0, string.indexOf("."));
    }

    private static DefaultConfiguration generateFont(String string, String string2, boolean bl) {
        DefaultConfiguration defaultConfiguration = new DefaultConfiguration("font");
        if (string2 != null) {
            defaultConfiguration.setAttribute("embed-url", string2);
        }
        String string3 = string;
        defaultConfiguration.addChild((Configuration)FOPFontConfigurator.generateFontTriplet(string3, false, bl));
        defaultConfiguration.addChild((Configuration)FOPFontConfigurator.generateFontTriplet(string3, true, bl));
        return defaultConfiguration;
    }

    private static DefaultConfiguration generateFontTriplet(String string, boolean bl, boolean bl2) {
        DefaultConfiguration defaultConfiguration = new DefaultConfiguration("font-triplet");
        defaultConfiguration.setAttribute("name", string);
        defaultConfiguration.setAttribute("style", bl ? "normal" : "italic");
        defaultConfiguration.setAttribute("weight", bl2 ? "bold" : "normal");
        return defaultConfiguration;
    }

    private static void generateFontSubstitutions(DefaultConfiguration defaultConfiguration, String string, String string2) {
        defaultConfiguration.addChild((Configuration)FOPFontConfigurator.generateFontSubstitution(string, string2, "normal", "normal", "normal", "normal"));
        defaultConfiguration.addChild((Configuration)FOPFontConfigurator.generateFontSubstitution(string, string2, "italic", "italic", "normal", "normal"));
        defaultConfiguration.addChild((Configuration)FOPFontConfigurator.generateFontSubstitution(string, string2, "italic", "italic", "bold", "bold"));
        defaultConfiguration.addChild((Configuration)FOPFontConfigurator.generateFontSubstitution(string, string2, "normal", "normal", "bold", "bold"));
    }

    private static DefaultConfiguration generateFontSubstitution(String string, String string2, String string3, String string4, String string5, String string6) {
        DefaultConfiguration defaultConfiguration = new DefaultConfiguration("substitution");
        DefaultConfiguration defaultConfiguration2 = new DefaultConfiguration("from");
        defaultConfiguration2.setAttribute("font-family", string);
        defaultConfiguration2.setAttribute("font-style", string3);
        defaultConfiguration2.setAttribute("font-weight", string5);
        defaultConfiguration.addChild((Configuration)defaultConfiguration2);
        DefaultConfiguration defaultConfiguration3 = new DefaultConfiguration("to");
        defaultConfiguration3.setAttribute("font-family", string2);
        defaultConfiguration3.setAttribute("font-style", string4);
        defaultConfiguration3.setAttribute("font-weight", string6);
        defaultConfiguration.addChild((Configuration)defaultConfiguration3);
        return defaultConfiguration;
    }

    private static DefaultConfiguration generateFontReferences(String[] stringArray) {
        DefaultConfiguration defaultConfiguration = new DefaultConfiguration("referenced-fonts");
        for (String string : stringArray) {
            DefaultConfiguration defaultConfiguration2 = new DefaultConfiguration("match");
            defaultConfiguration2.setAttribute("font-family", string);
            defaultConfiguration.addChild((Configuration)defaultConfiguration2);
        }
        return defaultConfiguration;
    }

    private static File getCMTrueTypeFontPath() {
        File file = new File(Matlab.matlabRoot());
        File file2 = new File(file, "sys");
        File file3 = new File(file2, "fonts");
        File file4 = new File(file3, "ttf");
        return new File(file4, "cm");
    }

    private static File getCMType1FontPath() {
        File file = new File(Matlab.matlabRoot());
        File file2 = new File(file, "sys");
        File file3 = new File(file2, "fonts");
        File file4 = new File(file3, "type1");
        return new File(file4, "cm");
    }

    private static class FontCache
    extends LinkedHashMap<File, CustomFont> {
        private final int fMaxItems = 100;

        public FontCache() {
            super(50, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<File, CustomFont> entry) {
            return this.size() > 100;
        }
    }

    private static class Type1Creator
    extends FontCreator {
        private Type1Creator() {
        }

        @Override
        public CustomFont createFont(File file) {
            String[] stringArray = file.getName().split("\\.(?=[^\\.]+$)");
            File file2 = new File(file.getParentFile(), stringArray[0] + ".pfm");
            if (!file2.exists()) {
                return null;
            }
            CustomFont customFont = (CustomFont)sLoadedFonts.get(file);
            if (customFont == null) {
                try {
                    Type1FontLoader type1FontLoader = new Type1FontLoader(file.toURI().toString(), true, true, sResolver);
                    customFont = type1FontLoader.getFont();
                    sLoadedFonts.put(file, customFont);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return customFont;
        }
    }

    private static class TTFCreator
    extends FontCreator {
        private TTFCreator() {
        }

        @Override
        public CustomFont createFont(File file) {
            CustomFont customFont = (CustomFont)sLoadedFonts.get(file);
            if (customFont == null) {
                try {
                    TTFFontLoader tTFFontLoader = new TTFFontLoader(file.toURI().toString(), sResolver);
                    customFont = tTFFontLoader.getFont();
                    sLoadedFonts.put(file, customFont);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return customFont;
        }
    }

    private static abstract class FontCreator {
        protected static FontResolver sResolver;

        private FontCreator() {
        }

        public abstract CustomFont createFont(File var1);

        static {
            FopFactory fopFactory = FopFactory.newInstance();
            FOUserAgent fOUserAgent = new FOUserAgent(fopFactory);
            sResolver = new DefaultFontResolver(fOUserAgent);
        }
    }
}

