/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer.ui.table;

import com.mathworks.hg.peer.ui.table.MultilineTableHeaderRenderer;
import com.mathworks.hg.peer.ui.table.TableHeaderNames;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class RowHeader
extends JTable {
    private static int MIN_WIDTH = 30;
    private JTable mMainTable;

    public RowHeader(JTable jTable) {
        if (jTable == null) {
            throw new IllegalArgumentException("RowHeader.<init>: Main Table cannot be null.");
        }
        this.mMainTable = jTable;
        this.setModel(new RowNumberTableModel());
        this.adjustPreferredScrollableViewportSize();
        this.setCellSelectionEnabled(false);
        this.setColumnRenederer();
    }

    @Override
    public void scrollRectToVisible(Rectangle rectangle) {
        Rectangle rectangle2 = this.mMainTable.getVisibleRect();
        rectangle2.y = rectangle.y;
        rectangle2.height = rectangle.height;
        this.mMainTable.scrollRectToVisible(rectangle2);
    }

    private void setColumnRenederer() {
        Serializable serializable;
        TableCellRenderer tableCellRenderer;
        if (PlatformInfo.isMacintosh()) {
            tableCellRenderer = new MultilineTableHeaderRenderer();
        } else {
            tableCellRenderer = PlatformInfo.isWindowsClassicAppearance() ? new InnerRowHeaderRenderer() : this.getTableHeader().getDefaultRenderer();
            if (tableCellRenderer instanceof JLabel) {
                serializable = (JLabel)((Object)tableCellRenderer);
                LookAndFeel.installColorsAndFont((JComponent)serializable, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
                LookAndFeel.installBorder((JComponent)serializable, "TableHeader.cellBorder");
                ((JLabel)serializable).setHorizontalAlignment(0);
            }
        }
        serializable = this.getColumnModel().getColumn(0);
        ((TableColumn)serializable).setCellRenderer(tableCellRenderer);
    }

    public void updatePreferredHeight() {
        Dimension dimension = this.getPreferredScrollableViewportSize();
        dimension.height = this.mMainTable.getHeight();
        this.setPreferredScrollableViewportSize(dimension);
    }

    @Override
    public boolean isCellSelected(int n, int n2) {
        return false;
    }

    @Override
    public int getRowHeight() {
        return this.mMainTable.getRowHeight();
    }

    @Override
    public int getRowHeight(int n) {
        return this.mMainTable.getRowHeight(n);
    }

    public void updateGUI() {
        this.adjustPreferredScrollableViewportSize();
        super.resizeAndRepaint();
    }

    public void setRowNames(Object[] objectArray) {
        ((RowNumberTableModel)this.getModel()).setDataSource(objectArray);
        this.updateGUI();
    }

    public void adjustPreferredScrollableViewportSize() {
        int n = this.getPreferredScrollableViewportSize().width;
        int n2 = String.valueOf(this.mMainTable.getRowCount()).length();
        int n3 = ((RowNumberTableModel)this.getModel()).getMaxRowHeaderLength();
        int n4 = Math.max(n2, n3);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n5 = n4 <= 6 ? Math.max(MIN_WIDTH, fontMetrics.charWidth('W') * (n4 + 1)) : fontMetrics.charWidth('W') * n4;
        if (n != n5) {
            this.doAdjustViewportSize(n5);
        }
    }

    private void doAdjustViewportSize(int n) {
        this.setPreferredScrollableViewportSize(new Dimension(n, this.mMainTable.getHeight()));
        this.repaint();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        ((JComponent)((Object)this.getColumnModel().getColumn(0).getCellRenderer())).setEnabled(this.mMainTable.isEnabled());
    }

    public class InnerRowHeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        private Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public InnerRowHeaderRenderer() {
            this.setOpaque(true);
            this.setBorder(this.noFocusBorder);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (jTable != null) {
                this.setFont(jTable.getFont());
            }
            this.setText(object == null ? "" : object.toString());
            return this;
        }
    }

    private class RowNumberTableModel
    extends AbstractTableModel {
        private TableHeaderNames mRowHeaderNames = new TableHeaderNames();

        private RowNumberTableModel() {
        }

        @Override
        public int getRowCount() {
            return RowHeader.this.mMainTable.getModel().getRowCount();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        public void setDataSource(Object[] objectArray) {
            this.mRowHeaderNames.setNames(objectArray);
            this.fireTableDataChanged();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.mRowHeaderNames.getHeaderName(n);
        }

        protected int getMaxRowHeaderLength() {
            return this.mRowHeaderNames.getMaxCharLength();
        }
    }
}

