/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.util.OutputHelperProcessingException;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import javax.swing.JComponent;
import javax.swing.RepaintManager;

public class PaintDisabled {
    private PaintDisabled() {
    }

    public static boolean isChildOfPaintDisabledContainer(Component component) {
        Component component2 = component;
        boolean bl = false;
        while (component2 != null) {
            Container container;
            if (component2 instanceof PaintDisabledHandler) {
                bl = ((PaintDisabledHandler)((Object)component2)).isPaintDisabled();
            }
            if (bl || (container = component2.getParent()) == null) break;
            component2 = container;
        }
        return bl;
    }

    public static void visitChildren(Container container, boolean bl) throws OutputHelperProcessingException {
        int n;
        for (int i = n = container.getComponentCount(); i > 0; --i) {
            Component component = container.getComponent(i - 1);
            PaintDisabled.setPaintDisabled(component, bl);
            if (!(component instanceof Container)) continue;
            PaintDisabled.visitChildren((Container)component, bl);
        }
    }

    public static void setPaintDisabled(Component component, boolean bl) throws OutputHelperProcessingException {
        if (component instanceof PaintDisabledHandler) {
            ((PaintDisabledHandler)((Object)component)).setPaintDisabled(bl);
        }
    }

    public static void installRepaintManager(JComponent jComponent) {
        NullRepaintManager.install(jComponent);
    }

    public static void removeRepaintManager() {
        NullRepaintManager.dispose();
    }

    public static boolean isRepaintManagerActive() {
        return NullRepaintManager.isActive();
    }

    private static final class NullRepaintManager
    extends RepaintManager {
        private static NullRepaintManager sInstance = null;
        private static final Object LOCK = new Object();
        private RepaintManager fOldRepaintManager = null;
        private boolean fInitialized = NullRepaintManager.getInstance() != null;
        private boolean fDisposing = false;

        private NullRepaintManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static NullRepaintManager getInstance() {
            NullRepaintManager nullRepaintManager;
            Object object = LOCK;
            synchronized (object) {
                nullRepaintManager = sInstance;
            }
            return nullRepaintManager;
        }

        private boolean isInitialized() {
            return this.fInitialized;
        }

        public static boolean isActive() {
            NullRepaintManager nullRepaintManager = NullRepaintManager.getInstance();
            return nullRepaintManager != null && nullRepaintManager.isInitialized();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(JComponent jComponent) {
            assert (EventQueue.isDispatchThread());
            if (!this.isInitialized()) {
                this.fOldRepaintManager = RepaintManager.currentManager(jComponent);
                assert (this.fOldRepaintManager != null);
                assert (!(this.fOldRepaintManager instanceof NullRepaintManager));
                RepaintManager.setCurrentManager(this);
                this.fInitialized = true;
                Object object = LOCK;
                synchronized (object) {
                    sInstance = this;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remove() {
            Object object;
            assert (EventQueue.isDispatchThread());
            if (this.isInitialized()) {
                this.fInitialized = false;
                object = this.fOldRepaintManager;
                this.fOldRepaintManager = null;
                assert (object != null);
                RepaintManager.setCurrentManager((RepaintManager)object);
            }
            object = LOCK;
            synchronized (object) {
                sInstance = null;
            }
        }

        static void install(JComponent jComponent) {
            new NullRepaintManager().add(jComponent);
        }

        boolean isDisposing() {
            return this.fDisposing;
        }

        void setDisposing(boolean bl) {
            this.fDisposing = bl;
        }

        static void dispose() {
            NullRepaintManager nullRepaintManager = NullRepaintManager.getInstance();
            if (nullRepaintManager != null && !nullRepaintManager.isDisposing()) {
                nullRepaintManager.setDisposing(true);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        NullRepaintManager nullRepaintManager = NullRepaintManager.getInstance();
                        if (nullRepaintManager.isDisposing()) {
                            nullRepaintManager.remove();
                        }
                    }
                };
                if (EventQueue.isDispatchThread()) {
                    runnable.run();
                } else {
                    EventQueue.invokeLater(runnable);
                }
            }
        }

        @Override
        public synchronized void addInvalidComponent(JComponent jComponent) {
            if (!PaintDisabled.isChildOfPaintDisabledContainer(jComponent)) {
                super.addInvalidComponent(jComponent);
            }
        }

        @Override
        public void addDirtyRegion(JComponent jComponent, int n, int n2, int n3, int n4) {
            if (!PaintDisabled.isChildOfPaintDisabledContainer(jComponent)) {
                super.addDirtyRegion(jComponent, n, n2, n3, n4);
            }
        }
    }

    public static interface PaintDisabledTargetHandler {
        public void setPaintDisabledTarget(Component var1);
    }

    public static interface PaintDisabledHandler {
        public void setPaintDisabled(boolean var1) throws OutputHelperProcessingException;

        public boolean isPaintDisabled();
    }
}

