/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.ActiveXCanvas;
import com.mathworks.hg.peer.BlockedOnPositionState;
import com.mathworks.hg.peer.DebugUtilities;
import com.mathworks.hg.peer.FigureBoundsNotification;
import com.mathworks.hg.peer.FigureClient;
import com.mathworks.hg.peer.FigureHG2Client;
import com.mathworks.hg.peer.FigureHG2Mediator;
import com.mathworks.hg.peer.FigurePeer;
import com.mathworks.hg.peer.HG2WindowRectHandler;
import com.mathworks.hg.peer.HeavyweightLightweightContainerFactory;
import com.mathworks.hg.peer.JavaSceneServerPeer;
import com.mathworks.hg.peer.NoBlockOnResizeAndWindowStyleChangeState;
import com.mathworks.hg.peer.WindowRectHandler;
import com.mathworks.hg.util.HGPeerRunnable;
import com.mathworks.hg.util.HGUtils;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class HG2FigurePeer
extends FigurePeer {
    public FigureHG2Client fHG2Client;

    public HG2FigurePeer() throws Throwable {
        super(null, 0, false);
    }

    public HG2FigurePeer(int n, boolean bl) throws Throwable {
        super(n, bl);
    }

    public HG2FigurePeer(Desktop desktop, int n, boolean bl) throws Throwable {
        super(desktop, n, bl);
    }

    @Override
    protected WindowRectHandler createWindowRectHandler() {
        return new HG2WindowRectHandler();
    }

    @Override
    protected FigureClient createFigureClient(Desktop desktop, String string, boolean bl, String string2, int n) {
        this.fHG2Client = new FigureHG2Mediator(desktop, string, bl, string2, this);
        return this.fHG2Client;
    }

    @Override
    public void addSceneServerPeer(final JavaSceneServerPeer javaSceneServerPeer) {
        HGUtils.invokeLater(new HGPeerRunnable(this, 24, 0, false){

            @Override
            public void run() {
                HG2FigurePeer.this.fHG2Client.addSceneServerPeer(javaSceneServerPeer);
            }
        });
    }

    @Override
    public void setBackgroundColor(final Color color) {
        HGUtils.invokeLater(new HGPeerRunnable(this, 25, 7){

            @Override
            public void run() {
                HG2FigurePeer.this.fHG2Client.setBackgroundColor(color);
            }
        });
    }

    @Override
    protected ActiveXCanvas getActiveXCanvasImpl() {
        ActiveXCanvas activeXCanvas = HeavyweightLightweightContainerFactory.getActiveXContainer(this);
        this.addActiveXControl(activeXCanvas);
        return activeXCanvas;
    }

    @Override
    protected void createHWNDForActiveXImpl(ActiveXCanvas activeXCanvas) {
        if (activeXCanvas.getNativeWindowHandle() == 0L) {
            this.doCreateFigureHidden();
        }
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
    }

    @Override
    public BlockedOnPositionState createBlockedOnPositionState() {
        return new NoBlockOnResizeAndWindowStyleChangeState();
    }

    @Override
    public void clearWaitForResize(boolean bl, boolean bl2) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Must call this method from the MATLAB thread";
        this.fBlockedOnPositionState.clearWaitForResize(bl, bl2);
    }

    @Override
    public void setWaitForResize(boolean bl) {
        this.fBlockedOnPositionState.setWaitForResize(bl);
    }

    @Override
    public boolean getWaitForResize() {
        Rectangle rectangle;
        Rectangle rectangle2;
        boolean bl = this.fBlockedOnPositionState.getWaitForResize();
        if (bl && (rectangle2 = this.fWindowRectHandler.getBounds()).equals(rectangle = this.fWindowRectHandler.getBounds(true))) {
            this.fBlockedOnPositionState.stopWaiting();
        }
        return bl;
    }

    @Override
    public boolean getWaitForWindowStyle() {
        return this.fBlockedOnPositionState.getWaitForWindowStyle();
    }

    private void doUnlockWindowOuterRect() {
        assert (SwingUtilities.isEventDispatchThread()) : "Must call doUnlockWindowOuterRect from event dispatch thread";
        this.fWindowRectHandler.setActivePositionMode(true);
    }

    @Override
    protected void unlockWindowOuterRect() {
        HGUtils.invokeLater(new HGPeerRunnable(this, 27, 7){

            @Override
            public void run() {
                HG2FigurePeer.this.doUnlockWindowOuterRect();
            }
        });
    }

    @Override
    protected void handleFigureBoundsNotification(FigureBoundsNotification figureBoundsNotification) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must call doUnlockWindowOuterRect from event dispatch thread";
        Rectangle rectangle = figureBoundsNotification.getInnerBounds();
        Rectangle rectangle2 = figureBoundsNotification.getOuterBounds();
        this.handleFigureBoundsNotificationHelper(false, false, rectangle2, rectangle);
    }

    @Override
    protected void bringFigureToFront() {
        if (this.fCurrentWindowStyle == FigurePeer.WindowStyle.NORMAL) {
            this.fFigureClient.showClient(false);
            this.fFigureClient.getFrameProxy().toFront();
        } else {
            super.bringFigureToFront();
        }
    }

    @Override
    protected void showUndockedFigure() {
        assert (this.fCurrentWindowStyle == FigurePeer.WindowStyle.NORMAL || this.fCurrentWindowStyle == FigurePeer.WindowStyle.MODAL);
        this.fFigureClient.showClient(false);
        this.fFigureClient.getFrameProxy().show(true);
        this.requestFocus();
    }

    @Override
    public void doShowContextMenu(JPopupMenu jPopupMenu, int n, int n2) {
        assert (SwingUtilities.isEventDispatchThread());
        this.doShowContextMenuInComponentContainer(jPopupMenu, n, n2);
    }

    @Override
    protected boolean shouldSetWindowResizableBeApplied() {
        return true;
    }

    @Override
    public Point getContainerLocation() {
        assert (!SwingUtilities.isEventDispatchThread());
        DebugUtilities.logMessage(160, "HG2FigurePeer.getContainerLocation", this);
        Point point = null;
        if (this.fFigureClient != null) {
            point = this.fFigureClient.getContainerLocation();
        }
        if (point == null) {
            point = new Point();
        }
        return point;
    }
}

