/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.OverlayLayout;

public class FigureOverlayLayout
extends OverlayLayout {
    static final int FIGURE_LAYOUT = 1001;
    static final String FIGURE_COMPONENT_PRESENT = "FigureComponent_Present";
    private Component fFigureComponent;
    private Component fFigureComponentContainer;
    private Component fOverlayComponent;

    public FigureOverlayLayout(Container container) {
        super(container);
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        if (object != null && object instanceof String) {
            this.addLayoutComponent((String)object, component);
        } else {
            super.addLayoutComponent(component, object);
        }
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        if (string != null) {
            boolean bl = false;
            if ("Overlay".equals(string)) {
                if (this.fOverlayComponent != null) {
                    this.fOverlayComponent.getParent().remove(this.fOverlayComponent);
                }
                this.fOverlayComponent = component;
                bl = false;
            }
            if ("FigureComponent".equals(string)) {
                assert (this.fFigureComponent == null);
                this.fFigureComponent = component;
                bl = true;
            }
            if ("FigureComponentContainer".equals(string)) {
                assert (this.fFigureComponentContainer == null);
                this.fFigureComponentContainer = component;
                bl = true;
            }
            if (bl) {
                this.fireFigureCompPresentProperty();
            }
        }
        super.addLayoutComponent(string, component);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        boolean bl = false;
        if (component == this.fFigureComponent) {
            this.fFigureComponent = null;
        } else if (component == this.fFigureComponentContainer) {
            bl = true;
            this.fFigureComponentContainer = null;
        } else if (component == this.fOverlayComponent) {
            this.fOverlayComponent = null;
            bl = true;
        }
        super.removeLayoutComponent(component);
        if (bl) {
            this.fireFigureCompPresentProperty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Component component = this.fOverlayComponent;
        Component component2 = this.fFigureComponent;
        Component component3 = this.fFigureComponentContainer;
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            int n2 = container.getComponentCount();
            if (n2 == 0) {
                return;
            }
            int n3 = container.getWidth();
            int n4 = container.getHeight();
            Rectangle rectangle = new Rectangle(0, 0, n3, n4);
            for (n = n2; n > 0; --n) {
                Component component4 = container.getComponent(n - 1);
                component4.setBounds(rectangle);
                if (component4 == component || component4 == component2 || component4 == component3) continue;
                System.out.println("Unrecognized component in the figure. Removing " + component4);
                container.remove(component4);
            }
            n = container.getComponentCount() - 1;
            if (component2 != null) {
                container.setComponentZOrder(component2, n--);
            }
            if (component3 != null) {
                container.setComponentZOrder(component3, n);
            }
            if (component != null) {
                assert (n == 1);
                container.setComponentZOrder(component, 0);
            }
        }
    }

    private void fireFigureCompPresentProperty() {
        if (this.fFigureComponentContainer != null) {
            assert (this.fFigureComponentContainer instanceof JComponent);
            ((JComponent)this.fFigureComponentContainer).putClientProperty(FIGURE_COMPONENT_PRESENT, this.fFigureComponent != null);
        }
    }
}

