/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.FigureEditableComponentManager;
import com.mathworks.hg.peer.FigurePeer;
import com.mathworks.hg.peer.FigureValidator;
import com.mathworks.hg.peer.HG2FigurePeer;
import com.mathworks.hg.peer.PopupMenuHideHelper;
import com.mathworks.hg.peer.event.UiMenuEvent;
import com.mathworks.hg.peer.event.UiMenuListener;
import com.mathworks.hg.util.HGPeerQueueUser;
import com.mathworks.hg.util.HGPeerRunnable;
import com.mathworks.hg.util.HGUtils;
import com.mathworks.mwswing.MJPopupMenu;
import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.awt.KeyboardFocusManager;
import java.util.EventListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ContextMenuPeer
implements HGPeerQueueUser {
    MJPopupMenu fContextMenu;
    private static int sFirstMethodIndex;
    protected static int sAddContextMenu;
    protected static int sRemoveContextMenu;
    protected static int sShowContextMenu;
    protected static int sHideContextMenu;
    protected static int sCreateContextMenu;
    private static int sLastMethodIndex;
    private static final String[] sLogMessages;
    private FigurePeer fParentFigure = null;
    private EventListenerList listenerList = new EventListenerList();

    public ContextMenuPeer() {
        HGUtils.invokeLater(new HGPeerRunnable(this, sCreateContextMenu, 2){

            @Override
            public void run() {
                ContextMenuPeer.this.doCreateContextMenu();
            }
        });
    }

    protected void doCreateContextMenu() {
        assert (SwingUtilities.isEventDispatchThread());
        this.fContextMenu = new MJPopupMenu(){

            public void setVisible(boolean bl) {
                if (bl != this.isVisible()) {
                    if (ContextMenuPeer.this.fParentFigure instanceof HG2FigurePeer || ContextMenuPeer.this.fParentFigure.getOffscreenRendering() && ContextMenuPeer.this.fParentFigure.useLightWeightContainer()) {
                        super.setVisible(bl);
                    } else {
                        PopupMenuHideHelper popupMenuHideHelper = new PopupMenuHideHelper();
                        popupMenuHideHelper.preVisibleChange(ContextMenuPeer.this.fParentFigure.getAxisComponent(), (Component)((Object)this), bl);
                        super.setVisible(bl);
                        popupMenuHideHelper.postVisibleChange();
                    }
                }
            }
        };
        this.fContextMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                keyboardFocusManager.clearGlobalFocusOwner();
                UiMenuEvent uiMenuEvent = new UiMenuEvent(popupMenuEvent.getSource());
                ContextMenuPeer.this.fireMenuAction(uiMenuEvent);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
    }

    @Override
    public FigureValidator getParentFigureValidator() {
        return this.fParentFigure;
    }

    @Override
    public int getUserLastMethodID() {
        return ContextMenuPeer.getLastMethodIndex();
    }

    @Override
    public String getUserMethodDescription(int n) {
        String string = null;
        if (n >= sFirstMethodIndex && n <= sLastMethodIndex) {
            string = sLogMessages[n - sFirstMethodIndex];
        }
        return string;
    }

    protected static int getLastMethodIndex() {
        return sLastMethodIndex;
    }

    public void addContextMenu(FigurePeer figurePeer) {
        this.fParentFigure = figurePeer;
    }

    public void removeContextMenu(FigurePeer figurePeer) {
        HGUtils.invokeLater(new HGPeerRunnable(this, sRemoveContextMenu, 1){

            @Override
            public void run() {
                if (ContextMenuPeer.this.fContextMenu != null) {
                    ContextMenuPeer.this.fContextMenu.setVisible(false);
                    ContextMenuPeer.this.fParentFigure = null;
                }
            }
        });
    }

    FigurePeer getParentFigure() {
        return this.fParentFigure;
    }

    void addChildMenu(JMenuItem jMenuItem) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new Error("Must call addChildMenu from event dispatch thread");
        }
        if (null != this.fContextMenu) {
            this.fContextMenu.add(jMenuItem);
        }
    }

    public MJPopupMenu getComponent() {
        return this.fContextMenu;
    }

    public void showContextMenu(final int n, final int n2) {
        HGUtils.invokeLater(new HGPeerRunnable(this, sShowContextMenu, 8){

            @Override
            public void run() {
                if (ContextMenuPeer.this.fParentFigure == null || ContextMenuPeer.this.fContextMenu == null) {
                    return;
                }
                Component[] componentArray = ContextMenuPeer.this.fContextMenu.getComponents();
                boolean bl = false;
                for (int i = 0; i < componentArray.length; ++i) {
                    if (!componentArray[i].isVisible()) continue;
                    bl = true;
                    break;
                }
                try {
                    if (bl) {
                        ContextMenuPeer.this.fParentFigure.doShowContextMenu((JPopupMenu)ContextMenuPeer.this.fContextMenu, n, n2);
                    }
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    PopupMenuEvent popupMenuEvent = new PopupMenuEvent(this);
                    UiMenuEvent uiMenuEvent = new UiMenuEvent(popupMenuEvent.getSource());
                    ContextMenuPeer.this.fireMenuAction(uiMenuEvent);
                }
            }
        });
    }

    public void hideContextMenu() {
        HGUtils.invokeLater(new HGPeerRunnable(this, sShowContextMenu, 8){

            @Override
            public void run() {
                if (ContextMenuPeer.this.fParentFigure == null || ContextMenuPeer.this.fContextMenu == null) {
                    return;
                }
                ContextMenuPeer.this.fParentFigure.doHideContextMenu((JPopupMenu)ContextMenuPeer.this.fContextMenu);
            }
        });
    }

    public synchronized void removeMenuListener(UiMenuListener uiMenuListener) {
        this.listenerList.remove(UiMenuListener.class, uiMenuListener);
    }

    public synchronized void addMenuListener(UiMenuListener uiMenuListener) {
        this.listenerList.add(UiMenuListener.class, uiMenuListener);
    }

    protected void fireMenuAction(UiMenuEvent uiMenuEvent) {
        EventListener[] eventListenerArray;
        FigureEditableComponentManager.commitCurrentEditableComponent();
        for (EventListener eventListener : eventListenerArray = this.listenerList.getListeners(UiMenuListener.class)) {
            ((UiMenuListener)eventListener).MenuAction(uiMenuEvent);
        }
    }

    static {
        sAddContextMenu = sFirstMethodIndex = 0;
        sRemoveContextMenu = sFirstMethodIndex + 1;
        sShowContextMenu = sFirstMethodIndex + 2;
        sHideContextMenu = sFirstMethodIndex + 3;
        sLastMethodIndex = sCreateContextMenu = sFirstMethodIndex + 4;
        sLogMessages = new String[]{"addContextMenu", "removeContextMenu", "showContextMenu", "hideContextMenu", "createContextMenu"};
    }
}

