/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.classfile;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.classfile.Utf8StringIndexPair;
import org.mozilla.javascript.WrappedException;

class ConstantPool {
    private Hashtable OEAB = new Hashtable();
    private Hashtable S = new Hashtable();
    private Hashtable addClass = new Hashtable();
    private Hashtable addNameAndType = new Hashtable();
    private int addUtf8 = 0;
    private int append = 1;
    private byte[] arraycopy = new byte[256];

    ConstantPool() {
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort((short)this.append);
        dataOutputStream.write(this.arraycopy, 0, this.addUtf8);
    }

    int getWriteSize() {
        return 2 + this.addUtf8;
    }

    short addConstant(int n) {
        this.ensure(5);
        this.arraycopy[this.addUtf8++] = 3;
        this.arraycopy[this.addUtf8++] = (byte)(n >> 24);
        this.arraycopy[this.addUtf8++] = (byte)(n >> 16);
        this.arraycopy[this.addUtf8++] = (byte)(n >> 8);
        this.arraycopy[this.addUtf8++] = (byte)n;
        return (short)this.append++;
    }

    short addConstant(long l) {
        this.ensure(9);
        this.arraycopy[this.addUtf8++] = 5;
        this.arraycopy[this.addUtf8++] = (byte)(l >> 56);
        this.arraycopy[this.addUtf8++] = (byte)(l >> 48);
        this.arraycopy[this.addUtf8++] = (byte)(l >> 40);
        this.arraycopy[this.addUtf8++] = (byte)(l >> 32);
        this.arraycopy[this.addUtf8++] = (byte)(l >> 24);
        this.arraycopy[this.addUtf8++] = (byte)(l >> 16);
        this.arraycopy[this.addUtf8++] = (byte)(l >> 8);
        this.arraycopy[this.addUtf8++] = (byte)l;
        short s = (short)this.append;
        this.append += 2;
        return s;
    }

    short addConstant(float f) {
        this.ensure(5);
        this.arraycopy[this.addUtf8++] = 4;
        int n = Float.floatToIntBits(f);
        this.arraycopy[this.addUtf8++] = (byte)(n >> 24);
        this.arraycopy[this.addUtf8++] = (byte)(n >> 16);
        this.arraycopy[this.addUtf8++] = (byte)(n >> 8);
        this.arraycopy[this.addUtf8++] = (byte)n;
        return (short)this.append++;
    }

    short addConstant(double d) {
        this.ensure(9);
        this.arraycopy[this.addUtf8++] = 6;
        long l = Double.doubleToLongBits(d);
        this.arraycopy[this.addUtf8++] = (byte)(l >> 56);
        this.arraycopy[this.addUtf8++] = (byte)(l >> 48);
        this.arraycopy[this.addUtf8++] = (byte)(l >> 40);
        this.arraycopy[this.addUtf8++] = (byte)(l >> 32);
        this.arraycopy[this.addUtf8++] = (byte)(l >> 24);
        this.arraycopy[this.addUtf8++] = (byte)(l >> 16);
        this.arraycopy[this.addUtf8++] = (byte)(l >> 8);
        this.arraycopy[this.addUtf8++] = (byte)l;
        short s = (short)this.append;
        this.append += 2;
        return s;
    }

    short addConstant(String string) {
        Utf8StringIndexPair utf8StringIndexPair = (Utf8StringIndexPair)this.OEAB.get(string);
        if (utf8StringIndexPair == null) {
            this.addUtf8(string);
            utf8StringIndexPair = (Utf8StringIndexPair)this.OEAB.get(string);
        }
        if (utf8StringIndexPair.itsStringIndex == -1) {
            utf8StringIndexPair.itsStringIndex = (short)this.append++;
            this.ensure(3);
            this.arraycopy[this.addUtf8++] = 8;
            this.arraycopy[this.addUtf8++] = (byte)(utf8StringIndexPair.itsUtf8Index >> 8);
            this.arraycopy[this.addUtf8++] = (byte)utf8StringIndexPair.itsUtf8Index;
        }
        return utf8StringIndexPair.itsStringIndex;
    }

    short addUtf8(String string) {
        Utf8StringIndexPair utf8StringIndexPair = (Utf8StringIndexPair)this.OEAB.get(string);
        if (utf8StringIndexPair == null) {
            utf8StringIndexPair = new Utf8StringIndexPair((short)this.append++, -1);
            this.OEAB.put(string, utf8StringIndexPair);
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeUTF(string);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                this.ensure(1 + byArray.length);
                this.arraycopy[this.addUtf8++] = 1;
                System.arraycopy(byArray, 0, this.arraycopy, this.addUtf8, byArray.length);
                this.addUtf8 += byArray.length;
            }
            catch (IOException iOException) {
                throw WrappedException.wrapException(iOException);
            }
        }
        return utf8StringIndexPair.itsUtf8Index;
    }

    short addNameAndType(short s, short s2) {
        this.ensure(5);
        this.arraycopy[this.addUtf8++] = 12;
        this.arraycopy[this.addUtf8++] = (byte)(s >> 8);
        this.arraycopy[this.addUtf8++] = (byte)s;
        this.arraycopy[this.addUtf8++] = (byte)(s2 >> 8);
        this.arraycopy[this.addUtf8++] = (byte)s2;
        return (short)this.append++;
    }

    short addClass(short s) {
        Short s2 = new Short(s);
        Short s3 = (Short)this.addNameAndType.get(s2);
        if (s3 == null) {
            this.ensure(3);
            this.arraycopy[this.addUtf8++] = 7;
            this.arraycopy[this.addUtf8++] = (byte)(s >> 8);
            this.arraycopy[this.addUtf8++] = (byte)s;
            s3 = new Short((short)this.append++);
            this.addNameAndType.put(s2, s3);
        }
        return s3;
    }

    short addClass(String string) {
        short s = this.addUtf8(ClassFileWriter.fullyQualifiedForm(string));
        return this.addClass(s);
    }

    short addFieldRef(String string, String string2, String string3) {
        String string4 = string + " " + string2 + " " + string3;
        Short s = (Short)this.S.get(string4);
        if (s == null) {
            short s2 = this.addUtf8(string2);
            short s3 = this.addUtf8(string3);
            short s4 = this.addNameAndType(s2, s3);
            short s5 = this.addClass(string);
            this.ensure(5);
            this.arraycopy[this.addUtf8++] = 9;
            this.arraycopy[this.addUtf8++] = (byte)(s5 >> 8);
            this.arraycopy[this.addUtf8++] = (byte)s5;
            this.arraycopy[this.addUtf8++] = (byte)(s4 >> 8);
            this.arraycopy[this.addUtf8++] = (byte)s4;
            s = new Short((short)this.append++);
            this.S.put(string4, s);
        }
        return s;
    }

    short addMethodRef(String string, String string2, String string3) {
        String string4 = string + " " + string2 + " " + string3;
        Short s = (Short)this.addClass.get(string4);
        if (s == null) {
            short s2 = this.addUtf8(string2);
            short s3 = this.addUtf8(string3);
            short s4 = this.addNameAndType(s2, s3);
            short s5 = this.addClass(string);
            this.ensure(5);
            this.arraycopy[this.addUtf8++] = 10;
            this.arraycopy[this.addUtf8++] = (byte)(s5 >> 8);
            this.arraycopy[this.addUtf8++] = (byte)s5;
            this.arraycopy[this.addUtf8++] = (byte)(s4 >> 8);
            this.arraycopy[this.addUtf8++] = (byte)s4;
            s = new Short((short)this.append++);
            this.addClass.put(string4, s);
        }
        return s;
    }

    short addInterfaceMethodRef(String string, String string2, String string3) {
        short s = this.addUtf8(string2);
        short s2 = this.addUtf8(string3);
        short s3 = this.addNameAndType(s, s2);
        short s4 = this.addClass(string);
        this.ensure(5);
        this.arraycopy[this.addUtf8++] = 11;
        this.arraycopy[this.addUtf8++] = (byte)(s4 >> 8);
        this.arraycopy[this.addUtf8++] = (byte)s4;
        this.arraycopy[this.addUtf8++] = (byte)(s3 >> 8);
        this.arraycopy[this.addUtf8++] = (byte)s3;
        return (short)this.append++;
    }

    void ensure(int n) {
        while (this.addUtf8 + n >= this.arraycopy.length) {
            byte[] byArray = this.arraycopy;
            this.arraycopy = new byte[this.arraycopy.length * 2];
            System.arraycopy(byArray, 0, this.arraycopy, 0, this.addUtf8);
        }
    }
}

