/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services.settings;

import com.mathworks.services.settings.Setting;

public final class SettingLevel
extends Enum<SettingLevel> {
    public static final /* enum */ SettingLevel SESSION = new SettingLevel();
    public static final /* enum */ SettingLevel USER = new SettingLevel();
    public static final /* enum */ SettingLevel WORKGROUP = new SettingLevel();
    public static final /* enum */ SettingLevel FACTORY = new SettingLevel();
    private static final String SESSION_LEVEL;
    private static final String USER_LEVEL;
    private static final String WORKGROUP_LEVEL;
    private static final String FACTORY_LEVEL;
    public static final SettingLevel DEFAULT;
    private static final /* synthetic */ SettingLevel[] $VALUES;

    public static SettingLevel[] values() {
        return (SettingLevel[])$VALUES.clone();
    }

    public static SettingLevel valueOf(String string) {
        return Enum.valueOf(SettingLevel.class, string);
    }

    private static SettingLevel getDefault() {
        SettingLevel settingLevel = SettingLevel.getLevel(Helper.nativeGetDefaultLevel());
        assert (settingLevel != null);
        return settingLevel;
    }

    public String value() {
        switch (this) {
            case SESSION: {
                return SESSION_LEVEL;
            }
            case FACTORY: {
                return FACTORY_LEVEL;
            }
            case WORKGROUP: {
                return WORKGROUP_LEVEL;
            }
            case USER: {
                return USER_LEVEL;
            }
        }
        assert (false);
        return USER_LEVEL;
    }

    public int comparePrecedence(SettingLevel settingLevel) {
        return Helper.nativeCompareLevels(this.value(), settingLevel.value());
    }

    public static SettingLevel getLevel(String string) {
        for (SettingLevel settingLevel : SettingLevel.values()) {
            if (!settingLevel.value().equals(string)) continue;
            return settingLevel;
        }
        return null;
    }

    static {
        $VALUES = new SettingLevel[]{SESSION, USER, WORKGROUP, FACTORY};
        Setting.loadLibrary();
        SESSION_LEVEL = Helper.nativeGetSessionLevel();
        USER_LEVEL = Helper.nativeGetUserLevel();
        WORKGROUP_LEVEL = Helper.nativeGetWorkgroupLevel();
        FACTORY_LEVEL = Helper.nativeGetFactoryLevel();
        DEFAULT = SettingLevel.getDefault();
    }

    private static class Helper {
        private Helper() {
        }

        static native String nativeGetSessionLevel();

        static native String nativeGetUserLevel();

        static native String nativeGetFactoryLevel();

        static native String nativeGetWorkgroupLevel();

        static native String nativeGetDefaultLevel();

        static native int nativeCompareLevels(String var0, String var1);
    }
}

