/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services.settings;

import com.mathworks.services.settings.Setting;
import com.mathworks.services.settings.SettingChangeEvent;
import com.mathworks.services.settings.SettingListener;
import com.mathworks.services.settings.SettingPath;
import com.mathworks.services.settings.SettingPathConverter;
import java.util.Arrays;

public abstract class SettingAdapter
implements SettingListener {
    private SettingPathConverter fConverter = null;

    public SettingAdapter() {
    }

    public SettingAdapter(SettingPathConverter settingPathConverter) {
        this.fConverter = settingPathConverter;
    }

    @Override
    public void settingChanged(SettingChangeEvent settingChangeEvent) {
    }

    @Override
    public void settingAdded(SettingChangeEvent settingChangeEvent) {
        if (settingChangeEvent.getOriginalEvent() != null) {
            this.settingChanged(settingChangeEvent);
        }
    }

    @Override
    public void settingRemoved(SettingChangeEvent settingChangeEvent) {
        if (settingChangeEvent.getOriginalEvent() != null) {
            this.settingChanged(settingChangeEvent);
        }
    }

    @Override
    public void settingRenamed(SettingChangeEvent settingChangeEvent) {
        if (settingChangeEvent.getOriginalEvent() != null) {
            this.settingChanged(settingChangeEvent);
        }
    }

    @Override
    public SettingChangeEvent createEvent(Object object, String[] stringArray, String string, String string2, boolean bl) {
        SettingPath settingPath = object instanceof SettingPath ? (SettingPath)object : ((Setting)object).getPath();
        SettingPath settingPath2 = new SettingPath(settingPath, false, stringArray);
        int n = settingPath.size();
        assert (stringArray.length >= n);
        if (object instanceof Setting) {
            if (stringArray.length == n) {
                return new SettingChangeEvent((Setting)object, settingPath2, string, null);
            }
            SettingPath settingPath3 = new SettingPath(settingPath, false, Arrays.copyOfRange(stringArray, 0, n));
            Setting setting = (Setting)object;
            SettingPath settingPath4 = new SettingPath(setting.getPath(), true, setting.getName());
            SettingChangeEvent settingChangeEvent = new SettingChangeEvent(settingPath4, settingPath2, string, string2, bl, null);
            return new SettingChangeEvent((Setting)object, settingPath3, stringArray[n], settingChangeEvent);
        }
        SettingChangeEvent settingChangeEvent = new SettingChangeEvent(settingPath, settingPath2, string, string2, bl, null);
        assert (n <= stringArray.length + 1);
        if (this.fConverter != null) {
            try {
                int n2 = this.fConverter.findCompositeSetting(stringArray, string, n);
                if (n2 > 0) {
                    if (n2 < n || n2 > stringArray.length) {
                        throw new IndexOutOfBoundsException("Index " + n2 + " not in range [" + n + "," + stringArray.length + "] for " + settingPath2);
                    }
                    SettingPath settingPath5 = n2 == stringArray.length ? settingPath : new SettingPath(settingPath, false, Arrays.copyOfRange(stringArray, 0, n2));
                    return new SettingChangeEvent(settingPath, settingPath5, n2 == stringArray.length ? string : stringArray[n2], null, false, settingChangeEvent);
                }
            }
            catch (RuntimeException runtimeException) {
                return new SettingChangeEvent(settingPath, settingPath2, string, string2, bl, null, runtimeException);
            }
        }
        return settingChangeEvent;
    }

    private static SettingListener getTestListener() {
        return new SettingAdapter(){
            static final int NONE = -1;
            static final int CHANGED = 0;
            static final int ADDED = 1;
            static final int REMOVED = 2;
            static final int RENAMED = 3;
            private volatile int fEvent = -1;
            private Object fSource;
            private String[] fParent;
            private String fChild;
            private String fOldName;
            private boolean fIsChildNode;

            @Override
            public SettingChangeEvent createEvent(Object object, String[] stringArray, String string, String string2, boolean bl) {
                this.fSource = object;
                this.fParent = stringArray;
                this.fChild = string;
                this.fOldName = string2;
                this.fIsChildNode = bl;
                if (!(object instanceof SettingPath)) {
                    throw new RuntimeException("test exception");
                }
                return super.createEvent(object, stringArray, string, string2, bl);
            }

            @Override
            public void settingChanged(SettingChangeEvent settingChangeEvent) {
                this.fEvent = 0;
            }

            @Override
            public void settingAdded(SettingChangeEvent settingChangeEvent) {
                this.fEvent = 1;
            }

            @Override
            public void settingRemoved(SettingChangeEvent settingChangeEvent) {
                this.fEvent = 2;
            }

            @Override
            public void settingRenamed(SettingChangeEvent settingChangeEvent) {
                this.fEvent = 3;
            }

            private boolean isOK(Object object, String[] stringArray, String string, String string2, boolean bl) {
                boolean bl2 = object.equals(this.fSource) && Arrays.equals(stringArray, this.fParent) && string.equals(this.fChild) && (string2 == this.fOldName || string2 != null && string2.equals(this.fOldName)) && bl == this.fIsChildNode;
                this.fSource = null;
                this.fParent = null;
                this.fChild = null;
                this.fOldName = null;
                this.fIsChildNode = !this.fIsChildNode;
                return bl2;
            }

            private int getEvent() {
                int n = this.fEvent;
                this.fEvent = -1;
                return n;
            }
        };
    }
}

