/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services.settings;

import com.mathworks.services.settings.SettingAccessException;
import com.mathworks.services.settings.SettingColorConverter;
import com.mathworks.services.settings.SettingConverter;
import com.mathworks.services.settings.SettingException;
import com.mathworks.services.settings.SettingFontConverter;
import com.mathworks.services.settings.SettingInfo;
import com.mathworks.services.settings.SettingLevel;
import com.mathworks.services.settings.SettingLevelRuntimeException;
import com.mathworks.services.settings.SettingListener;
import com.mathworks.services.settings.SettingNameRuntimeException;
import com.mathworks.services.settings.SettingNotFoundException;
import com.mathworks.services.settings.SettingPath;
import com.mathworks.services.settings.SettingProperties;
import com.mathworks.services.settings.SettingRectangleConverter;
import com.mathworks.services.settings.SettingTransaction;
import com.mathworks.services.settings.SettingTypeException;
import com.mathworks.services.settings.SettingUnsupportedTypeRuntimeException;
import com.mathworks.services.settings.SettingValidationException;
import com.mathworks.util.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class Setting<T> {
    private final SettingPath fPath;
    private final String fName;
    private final AtomicReference<Class<T>> fType = new AtomicReference();
    private final AtomicReference<SettingConverter<T>> fConverter = new AtomicReference();
    private final AtomicReference<SettingInfo<T>> fInfo = new AtomicReference();
    private T fValue;
    private SettingLevel fLevel;
    private static final AtomicBoolean LIB_LOADED;
    private static final long DEFAULT_CONTEXT = 0L;
    private static final Map<Class<?>, SettingConverter<?>> CONVERTERS;

    public Setting(SettingPath settingPath, String string) throws SettingNotFoundException, IllegalArgumentException {
        Setting.loadLibrary();
        if (!settingPath.exists()) {
            throw new SettingNotFoundException(settingPath.toString());
        }
        this.fPath = settingPath;
        this.fName = string;
        if (string == null) {
            throw new IllegalArgumentException("Setting name must not be null");
        }
        this.fValue = null;
        this.fLevel = null;
        if (!this.exists()) {
            throw new SettingNotFoundException(this.fullPath());
        }
    }

    private Setting(SettingPath settingPath, String string, SettingConverter<T> settingConverter) throws SettingNotFoundException, SettingTypeException, IllegalArgumentException {
        Setting.loadLibrary();
        if (!settingPath.exists()) {
            throw new SettingNotFoundException(settingPath.toString());
        }
        if (settingConverter != null) {
            this.fType.set(settingConverter.getType());
            this.fConverter.set(settingConverter);
        }
        this.fPath = settingPath;
        this.fName = string;
        if (string == null) {
            throw new IllegalArgumentException("Setting name must not be null");
        }
        this.fValue = null;
        this.fLevel = null;
        if (!this.existsThrowType()) {
            throw new SettingNotFoundException(this.fullPath());
        }
    }

    public Setting(SettingPath settingPath, SettingConverter<T> settingConverter, String string) throws SettingNotFoundException, SettingTypeException, IllegalArgumentException {
        this(settingPath, string, settingConverter);
        this.get();
    }

    public Setting(SettingPath settingPath, Class<T> clazz, String string) throws SettingNotFoundException, SettingTypeException, IllegalArgumentException {
        this(settingPath, string, Setting.getBuiltinConverter(clazz));
        if (this.fConverter.get() != null) {
            assert (this.fType.get() == clazz);
        } else {
            this.fType.set(clazz);
        }
        this.get();
    }

    public Setting(String string, @Nullable T t, @Nullable Class<T> clazz, @Nullable SettingLevel settingLevel) throws IllegalArgumentException, SettingNameRuntimeException {
        Setting.loadLibrary();
        if (string == null) {
            throw new IllegalArgumentException("Setting name must not be null");
        }
        this.fName = Setting.validateKeyName(string);
        this.fPath = null;
        this.fValue = t;
        this.fLevel = settingLevel;
        if (t != null) {
            this.fType.set(t.getClass());
            if (clazz != null && this.fType.get() != clazz) {
                throw new IllegalArgumentException("type != value.getClass");
            }
        } else {
            this.fType.set(clazz);
        }
    }

    public Setting(String string, T t, @Nullable SettingLevel settingLevel) throws SettingNameRuntimeException, IllegalArgumentException {
        this(string, t, null, settingLevel);
    }

    public Setting(String string, T t) throws SettingNameRuntimeException, IllegalArgumentException {
        this(string, t, null);
    }

    static <T> SettingConverter<T> getBuiltinConverter(Class<T> clazz) {
        return clazz == null ? null : CONVERTERS.get(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadLibrary() {
        if (LIB_LOADED.get()) {
            return;
        }
        Class<Setting> clazz = Setting.class;
        synchronized (Setting.class) {
            block8: {
                if (LIB_LOADED.get()) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
                LIB_LOADED.set(true);
                try {
                    System.loadLibrary("nativesettings");
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane jOptionPane = new JOptionPane("Failed to load nativesettings library: " + throwable.getMessage(), 0, -1){

                                @Override
                                public int getMaxCharactersPerLineCount() {
                                    return 100;
                                }
                            };
                            jOptionPane.createDialog("ERROR").setVisible(true);
                        }
                    });
                    Log.logThrowable((Throwable)throwable);
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    if (!(throwable instanceof RuntimeException)) break block8;
                    throw (RuntimeException)throwable;
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void noLoadLibrary() {
        LIB_LOADED.set(true);
    }

    public T get() throws SettingTypeException, SettingNotFoundException {
        return this.getInternal(false, null);
    }

    public T get(SettingLevel settingLevel) throws SettingNotFoundException, SettingTypeException {
        return this.getInternal(true, settingLevel);
    }

    public T get(Class<T> clazz) throws SettingNotFoundException, SettingTypeException, IllegalStateException {
        if (!this.fType.compareAndSet(null, clazz) && clazz != this.fType.get()) {
            throw new IllegalStateException();
        }
        return this.getInternal(false, null);
    }

    public T get(SettingConverter<T> settingConverter) throws SettingNotFoundException, SettingTypeException {
        this.setConverter(settingConverter);
        if (this.fConverter.get() == null) {
            return this.get();
        }
        return this.get(this.fConverter.get().getType());
    }

    private T getInternal(boolean bl, @Nullable SettingLevel settingLevel) throws SettingNotFoundException, SettingTypeException {
        Class<Object> clazz;
        SettingInfo<T> settingInfo;
        SettingConverter<T> settingConverter;
        if (this.fPath == null) {
            Class<?> clazz2;
            T t;
            Object object = t = settingLevel == null || settingLevel == this.fLevel ? this.fValue : null;
            if (t != null && this.fType.get() == null && !this.fType.compareAndSet(null, clazz2 = t.getClass()) && this.fType.get() != clazz2) {
                throw new SettingTypeException(this, clazz2, this.fType.get());
            }
            return t;
        }
        if (!bl) {
            assert (settingLevel == null);
            settingConverter = SettingTransaction.getTransaction();
            if (settingConverter != null && ((SettingTransaction)((Object)settingConverter)).contains(this)) {
                Object t = ((SettingTransaction)((Object)settingConverter)).get(this);
                return t;
            }
        }
        if (this.fPath.isChildNode(this.fName) != this.isNodeExpected()) {
            throw new SettingTypeException(this);
        }
        settingConverter = this.fConverter.get();
        if (settingConverter != null) {
            return settingConverter.get(this.getPath(), this.getName(), settingLevel);
        }
        try {
            settingInfo = Setting.nativeGet(this.fPath.getTreePtr(), this.fPath.elements(), this.fName, settingLevel == null ? null : settingLevel.value());
        }
        catch (SettingTypeException settingTypeException) {
            throw new SettingTypeException("Type of XML data for \"" + this.fullPath() + "\" cannot be processed by Java");
        }
        T t = settingInfo.getValue();
        Class<Object> clazz3 = clazz = t == null ? settingInfo.getType() : t.getClass();
        if (!this.fType.compareAndSet(null, clazz3) && clazz3 != null && this.fType.get() != clazz3) {
            throw new SettingTypeException(this, clazz3, this.fType.get());
        }
        if (settingInfo.getType() != null) {
            this.fInfo.set(settingInfo);
        }
        return t;
    }

    public SettingProperties<T> getProperties() {
        try {
            return new SettingProperties<T>(this.getLevel(), this.getType(), this.getConverter(), null);
        }
        catch (SettingNotFoundException settingNotFoundException) {
            return null;
        }
    }

    public void setConverter(SettingConverter<T> settingConverter) throws IllegalStateException {
        if (settingConverter == null) {
            return;
        }
        if (this.fConverter.compareAndSet(null, settingConverter)) {
            Class<T> clazz = settingConverter.getType();
            if (!this.fType.compareAndSet(null, clazz) && this.fType.get() != clazz) {
                throw new IllegalStateException("Attempt to change Setting type via new converter");
            }
        } else if (this.fConverter.get().getType() != settingConverter.getType()) {
            throw new IllegalStateException("Attempt to change converter type");
        }
    }

    public void set(T t) throws SettingValidationException, ClassCastException, SettingAccessException, SettingNotFoundException, SettingTypeException {
        this.set(t, SettingLevel.DEFAULT);
    }

    public void set(T t, SettingConverter<T> settingConverter) throws SettingValidationException, ClassCastException, SettingAccessException, SettingNotFoundException, IllegalStateException, SettingTypeException {
        this.setConverter(settingConverter);
        this.set(t, SettingLevel.DEFAULT);
    }

    public void set(T t, SettingLevel settingLevel) throws ClassCastException, SettingValidationException, SettingLevelRuntimeException, SettingAccessException, SettingNotFoundException, SettingTypeException {
        this.set(0L, t, settingLevel);
    }

    /*
     * Unable to fully structure code
     */
    public final void set(long var1_1, T var3_2, @Nullable SettingLevel var4_3) throws ClassCastException, SettingValidationException, SettingLevelRuntimeException, SettingAccessException, SettingNotFoundException, SettingTypeException {
        if (var3_2 != null) {
            var5_4 = var3_2.getClass();
            if (!this.fType.compareAndSet((Class<T>)null, (Class<T>)var5_4)) {
                if (!this.fType.get().isInstance(var3_2)) {
                    throw new ClassCastException("Type was \"" + this.fType.get().getName() + "\"; attempted to set \"" + var3_2.getClass().getName() + "\"");
                }
            } else if (this.fPath != null) {
                try {
                    this.get();
                }
                catch (SettingTypeException var6_5) {
                    var7_9 = var6_5.getActualType();
                    this.fType.set((Class<T>)var7_9);
                    if (this.fType.get().isInstance(var3_2)) ** GOTO lbl20
                    throw var6_5;
                }
            }
        } else if (this.fPath != null) {
            throw new IllegalStateException();
        }
lbl20:
        // 6 sources

        if (this.fPath != null) {
            var5_4 = SettingTransaction.getTransaction();
            if (var5_4 != null) {
                var5_4.add(this, var3_2, var4_3);
                return;
            }
            try {
                var6_6 = this.fConverter.get();
                if (var6_6 != null) {
                    if (var1_1 != 0L || !var6_6.isNode()) {
                        var6_6.set(var1_1, this.fPath, this.fName, var3_2, var4_3);
                    }
                    var7_9 = new SettingTransaction();
                    var7_9.start();
                    this.set(var1_1, var3_2, var4_3);
                    var7_9.commit();
                }
                if (this.fInfo.get() == null) {
                    this.fInfo.compareAndSet(null, new SettingInfo<T>(var3_2));
                } else {
                    this.fInfo.get().setValue(var3_2);
                }
                Setting.nativeSet(var1_1, this.fPath.getTreePtr(), this.fPath.elements(), this.fName, this.fInfo.get(), var1_1 == 0L ? Setting.levelValue(var4_3) : null);
            }
            catch (SettingAccessException | SettingNotFoundException | SettingUnsupportedTypeRuntimeException | SettingValidationException var6_7) {
                throw var6_7;
            }
            catch (SettingException var6_8) {
                throw new RuntimeException(var6_8);
            }
        } else {
            this.fValue = var3_2;
            if (var4_3 != null) {
                this.fLevel = var4_3;
            }
        }
    }

    public SettingConverter<T> getConverter() {
        return this.fConverter.get();
    }

    private static String levelValue(SettingLevel settingLevel) {
        if (settingLevel == null) {
            return SettingLevel.DEFAULT.value();
        }
        return settingLevel.value();
    }

    public SettingLevel getLevel() throws SettingNotFoundException {
        if (this.fPath == null) {
            return this.fLevel;
        }
        SettingLevel settingLevel = SettingLevel.getLevel(Setting.nativeGetLevel(this.fPath.getTreePtr(), this.fPath.elements(), this.fName));
        assert (settingLevel != null);
        return settingLevel;
    }

    public boolean exists() throws SettingUnsupportedTypeRuntimeException {
        if (this.fPath == null) {
            return false;
        }
        if (this.fConverter.get() != null && this.fConverter.get().isNode()) {
            try {
                SettingPath settingPath = new SettingPath(this.fPath, this.fName);
            }
            catch (SettingNotFoundException settingNotFoundException) {
                return false;
            }
            return true;
        }
        return Setting.nativeExists(this.fPath.getTreePtr(), this.fPath.elements(), this.fName);
    }

    private boolean existsThrowType() throws SettingTypeException {
        if (this.fPath == null) {
            return false;
        }
        try {
            boolean bl = this.fPath.isChildNode(this.fName);
            if (bl != this.isNodeExpected()) {
                throw new SettingTypeException(this);
            }
            return true;
        }
        catch (SettingNotFoundException settingNotFoundException) {
            return false;
        }
    }

    public boolean isNodeExpected() {
        return this.fConverter.get() != null && this.fConverter.get().isNode();
    }

    public Class<T> getType() {
        block4: {
            if (this.fType.get() == null) {
                try {
                    this.get();
                }
                catch (SettingNotFoundException settingNotFoundException) {
                    return null;
                }
                catch (SettingTypeException settingTypeException) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError();
                }
            }
        }
        return this.fType.get();
    }

    public void setType(Class<T> clazz) throws IllegalStateException {
        if (!this.fType.compareAndSet(null, clazz) && !this.fType.get().equals(clazz)) {
            throw new IllegalStateException("Attempt to change type of setting from " + this.fType.get().getName() + " to " + clazz.getName());
        }
    }

    public String fullPath() {
        if (this.fPath == null) {
            return this.fName;
        }
        String string = this.fPath.toString();
        if (!string.isEmpty()) {
            return string + '.' + this.fName;
        }
        return this.fName;
    }

    public String getName() {
        return this.fName;
    }

    public void addListener(SettingListener settingListener) throws UnsupportedOperationException, SettingNotFoundException {
        if (this.fPath == null) {
            throw new UnsupportedOperationException();
        }
        Setting.nativeAddRemoveListener(this, this.fPath.getTreePtr(), this.fPath.elements(), this.fName, settingListener);
    }

    public void removeListener(SettingListener settingListener) throws SettingNotFoundException {
        if (this.fPath != null) {
            Setting.nativeAddRemoveListener(null, this.fPath.getTreePtr(), this.fPath.elements(), this.fName, settingListener);
        }
    }

    public void delete() throws SettingNotFoundException, SettingAccessException {
        if (this.fPath != null) {
            this.fPath.delete(this.getName());
        }
    }

    public void unset(SettingLevel settingLevel) throws SettingAccessException, SettingNotFoundException {
        if (this.fPath != null) {
            if (this.fConverter.get() != null) {
                try {
                    this.fConverter.get().unset(this, settingLevel);
                }
                catch (SettingAccessException | SettingNotFoundException settingException) {
                    throw settingException;
                }
                catch (SettingException settingException) {
                    throw new RuntimeException(settingException);
                }
            } else {
                Setting.nativeUnset(this.fPath.getTreePtr(), this.fPath.elements(), this.fName, Setting.levelValue(settingLevel));
            }
        }
    }

    public boolean isSet(SettingLevel settingLevel) {
        if (this.fConverter.get() != null && this.fConverter.get().isNode()) {
            try {
                return this.fConverter.get().isSet(this, settingLevel == null ? SettingLevel.DEFAULT : settingLevel);
            }
            catch (SettingException settingException) {
                throw new RuntimeException(settingException);
            }
        }
        if (this.fPath == null) {
            return settingLevel == this.fLevel || (settingLevel == null ? SettingLevel.DEFAULT : settingLevel).equals((Object)(this.fLevel == null ? SettingLevel.DEFAULT : this.fLevel));
        }
        return Setting.nativeIsSet(this.fPath.getTreePtr(), this.fPath.elements(), this.fName, Setting.levelValue(settingLevel));
    }

    public String getFactoryDir() {
        return this.fPath == null ? null : Setting.nativeGetFactoryDir(this.fPath.getTreePtr());
    }

    public SettingPath getPath() {
        return this.fPath;
    }

    public String toString() {
        Object var1_1 = null;
        try {
            var1_1 = this.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.fName + '=' + var1_1;
    }

    public boolean equals(Object object) {
        if (object instanceof Setting) {
            Setting setting = (Setting)object;
            return (this.fPath == setting.getPath() || this.fPath != null && this.fPath.equals(setting.getPath())) && this.fName.equals(setting.fName);
        }
        return false;
    }

    public int hashCode() {
        return (this.fPath != null ? this.fPath.hashCode() : 0) + this.fName.hashCode();
    }

    private static String validateKeyName(String string) throws SettingNameRuntimeException {
        if (!Setting.nativeIsKeyNameValid(string)) {
            throw new SettingNameRuntimeException(string);
        }
        return string;
    }

    private static native <T> SettingInfo<T> nativeGet(long var0, String[] var2, String var3, String var4) throws SettingNotFoundException, SettingTypeException;

    private static native String nativeGetLevel(long var0, String[] var2, String var3);

    private static native <T> void nativeSet(long var0, long var2, String[] var4, String var5, SettingInfo<T> var6, String var7) throws SettingValidationException, SettingNotFoundException, SettingAccessException, SettingUnsupportedTypeRuntimeException;

    private static native void nativeUnset(long var0, String[] var2, String var3, String var4) throws SettingNotFoundException, SettingAccessException;

    private static native boolean nativeIsSet(long var0, String[] var2, String var3, String var4);

    static native void nativeAddRemoveListener(@Nullable Object var0, long var1, String[] var3, @Nullable String var4, SettingListener var5) throws UnsupportedOperationException, SettingNotFoundException;

    static native String nativeGetFactoryDir(long var0);

    private static native boolean nativeIsKeyNameValid(String var0);

    static native boolean nativeExists(long var0, String[] var2, @Nullable String var3);

    static {
        SettingConverter[] settingConverterArray;
        LIB_LOADED = new AtomicBoolean(false);
        CONVERTERS = new HashMap();
        for (SettingConverter settingConverter : settingConverterArray = new SettingConverter[]{new SettingFontConverter(), new SettingColorConverter(), new SettingRectangleConverter()}) {
            CONVERTERS.put(settingConverter.getType(), settingConverter);
        }
    }
}

