/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.computils.widgets;

import com.mathworks.toolbox.shared.computils.confinement.ThreadCheck;
import com.mathworks.toolbox.shared.computils.confinement.predicates.OnlyEDT;
import com.mathworks.util.Disposable;
import com.mathworks.widgets.BusyAffordance;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

@ThreadCheck(access=OnlyEDT.class)
public class DisposableBusyAffordance
extends BusyAffordance
implements Disposable {
    private boolean fStarted = false;
    private boolean fDisposed = false;

    public DisposableBusyAffordance() {
        this.initialize();
    }

    public DisposableBusyAffordance(BusyAffordance.AffordanceSize affordanceSize) {
        super(affordanceSize);
        this.initialize();
    }

    private void initialize() {
        JComponent jComponent = this.getComponent();
        jComponent.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                if (DisposableBusyAffordance.this.fStarted && !DisposableBusyAffordance.this.fDisposed) {
                    DisposableBusyAffordance.super.start();
                }
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                DisposableBusyAffordance.super.stop();
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
    }

    public void start() {
        if (!this.fDisposed) {
            super.start();
            this.fStarted = true;
        }
    }

    public void stop() {
        super.stop();
        this.fStarted = false;
    }

    public void dispose() {
        this.fDisposed = true;
        this.stop();
    }
}

