/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.computils.threads;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class CoalescingExecutor<T extends Runnable> {
    private final Executor fExecutor;
    private final Combiner<T> fCombiner;
    private final AtomicReference<T> fNextTask = new AtomicReference<Object>(null);
    private final AtomicBoolean fRunning = new AtomicBoolean(false);

    public CoalescingExecutor(Executor executor, Combiner<T> combiner) {
        this.fExecutor = executor;
        this.fCombiner = combiner;
    }

    public synchronized void execute(T t) {
        Runnable runnable = (Runnable)this.fNextTask.get();
        if (runnable != null) {
            Runnable runnable2 = this.fCombiner.combine(runnable, (Runnable)t);
            if (!this.fNextTask.compareAndSet(runnable, runnable2)) {
                this.fNextTask.set(t);
            }
        } else {
            this.fNextTask.set(t);
        }
        this.submitWorker();
    }

    private void submitWorker() {
        if (this.fNextTask.get() != null && this.fRunning.compareAndSet(false, true)) {
            this.fExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Runnable runnable = CoalescingExecutor.this.fNextTask.getAndSet(null);
                    try {
                        if (runnable != null) {
                            runnable.run();
                        }
                    }
                    finally {
                        CoalescingExecutor.this.fRunning.set(false);
                        CoalescingExecutor.this.submitWorker();
                    }
                }
            });
        }
    }

    public static interface Combiner<T> {
        public T combine(T var1, T var2);
    }
}

