/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.computils.file.diffreader.fileextraction.ui;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.toolbox.shared.computils.exceptions.ExceptionHandler;
import com.mathworks.toolbox.shared.computils.file.diffreader.fileextraction.ConflictMarkerExtractor;
import com.mathworks.toolbox.shared.computils.file.diffreader.fileextraction.FileNotifyingConflictMarkerExtractor;
import com.mathworks.toolbox.shared.computils.file.diffreader.fileextraction.ui.ExtractionParametersWidget;
import com.mathworks.toolbox.shared.computils.file.diffreader.fileextraction.ui.PostExtractAction;
import com.mathworks.toolbox.shared.computils.file.diffreader.fileextraction.ui.ToggleablePostExtractAction;
import com.mathworks.toolbox.shared.computils.file.diffreader.fileextraction.ui.UserDefinedConflictExtractionParameters;
import com.mathworks.toolbox.shared.computils.file.resources.FileResources;
import com.mathworks.toolbox.shared.computils.tasks.EventBroadcastingTerminationClient;
import com.mathworks.toolbox.shared.computils.tasks.MutableCancellationStatus;
import com.mathworks.toolbox.shared.computils.widgets.HTMLMessagePane;
import com.mathworks.widgets.ComponentBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class ConflictMarkerExtractorDialog
extends MJDialog
implements Runnable {
    private static final int INNER_GAP = 10;
    public static final String NAME = "ConflictMarkerExtractorDialog";
    public static final String EXTRACT_BUTTON_NAME = "ConflictMarkerExtractButton";
    public static final String CANCEL_BUTTON_NAME = "ConflictMarkerCancelButton";
    public static final String ABORT_BUTTON_NAME = "ConflictMarkerAbortButton";
    private final ExtractorInteractor fExtractorInteractor;
    private final UserDefinedConflictExtractionParameters fExtractionParameters;
    private final ExecutorService fExecutorService;
    private final ExceptionHandler fExceptionHandler;
    private final MutableCancellationStatus fMutableCancellationStatus;
    private final EventBroadcastingTerminationClient fEventBroadcastingTerminationClient;
    private final ToggleablePostExtractAction fPostExtractAction;

    public ConflictMarkerExtractorDialog(File file, ExecutorService executorService, ExceptionHandler exceptionHandler, PostExtractAction postExtractAction, Frame frame, String string) {
        super(frame);
        UserDefinedConflictExtractionParameters userDefinedConflictExtractionParameters;
        this.setName(NAME);
        this.fExecutorService = executorService;
        this.fExceptionHandler = exceptionHandler;
        this.fPostExtractAction = new ToggleablePostExtractAction(postExtractAction);
        this.setTitle(FileResources.getString("ui.extractConflictMarkers.title", new String[0]));
        this.fMutableCancellationStatus = new MutableCancellationStatus();
        this.fEventBroadcastingTerminationClient = new EventBroadcastingTerminationClient(this.fMutableCancellationStatus);
        this.fExtractionParameters = userDefinedConflictExtractionParameters = new UserDefinedConflictExtractionParameters(file);
        this.fExtractionParameters.setToExtractMineOverConflicted();
        this.fExtractorInteractor = new ExtractorInteractor();
        this.setLayout(new BorderLayout());
        this.add(this.buildMainPanel(userDefinedConflictExtractionParameters, string), "Center");
        this.setSize(new Dimension(485, 300));
        this.setModal(true);
    }

    public ConflictMarkerExtractorDialog(File file, ExecutorService executorService, ExceptionHandler exceptionHandler, PostExtractAction postExtractAction, Frame frame) {
        this(file, executorService, exceptionHandler, postExtractAction, frame, null);
    }

    public ConflictMarkerExtractorDialog(File file, ExecutorService executorService, ExceptionHandler exceptionHandler) {
        this(file, executorService, exceptionHandler, null, null);
    }

    public ConflictMarkerExtractorDialog(File file, ExecutorService executorService) {
        this(file, executorService, new ExceptionHandler(){

            @Override
            public void handle(Exception exception) {
                exception.printStackTrace();
            }
        });
    }

    private JPanel buildMainPanel(UserDefinedConflictExtractionParameters userDefinedConflictExtractionParameters, String string) {
        MJPanel mJPanel = new MJPanel();
        GroupLayout groupLayout = new GroupLayout((Container)mJPanel);
        mJPanel.setLayout(groupLayout);
        groupLayout.setAutoCreateContainerGaps(true);
        DescriptionLabel descriptionLabel = new DescriptionLabel(userDefinedConflictExtractionParameters, string);
        ExtractionParametersWidget extractionParametersWidget = new ExtractionParametersWidget(userDefinedConflictExtractionParameters);
        JComponent jComponent = new PostExtractActionWidget().getComponent();
        ExtractStrategyControl extractStrategyControl = new ExtractStrategyControl();
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup().addComponent((Component)((Object)descriptionLabel), 0, -2, Integer.MAX_VALUE).addComponent(extractStrategyControl.getComponent()).addComponent(extractionParametersWidget.getComponent()).addGroup(groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Integer.MAX_VALUE).addComponent(jComponent, -2, -2, -2).addComponent(this.fExtractorInteractor.getComponent(), -2, -2, -2)));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addComponent((Component)((Object)descriptionLabel), 0, -2, -2).addComponent(extractStrategyControl.getComponent(), -2, -2, -2).addGap(10).addComponent(extractionParametersWidget.getComponent(), -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Integer.MAX_VALUE).addGroup(groupLayout.createParallelGroup().addComponent(jComponent, -2, -2, -2).addComponent(this.fExtractorInteractor.getComponent(), -2, -2, -2)));
        groupLayout.setAutoCreateGaps(true);
        return mJPanel;
    }

    private void extract() {
        this.fExtractorInteractor.showExtractingView();
        this.fExecutorService.submit(new Runnable(){

            @Override
            public void run() {
                DialogExtractor dialogExtractor = new DialogExtractor();
                try {
                    ((ConflictMarkerExtractor)dialogExtractor).extract();
                    ConflictMarkerExtractorDialog.this.closeDialog();
                    ConflictMarkerExtractorDialog.this.fPostExtractAction.runPostExtractAction(ConflictMarkerExtractorDialog.this.fExtractionParameters.getMineFile(), ConflictMarkerExtractorDialog.this.fExtractionParameters.getTheirsFile());
                }
                catch (IOException iOException) {
                    ConflictMarkerExtractorDialog.this.fExceptionHandler.handle(iOException);
                }
            }
        });
    }

    private void closeDialog() {
        this.dispose();
    }

    private void abort() {
        this.fEventBroadcastingTerminationClient.cancel();
    }

    @Override
    public void run() {
        this.setVisible(true);
    }

    private class AbortButton
    extends MJButton {
        private AbortButton() {
            this.setName(ConflictMarkerExtractorDialog.ABORT_BUTTON_NAME);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ConflictMarkerExtractorDialog.this.abort();
                }
            });
            ConflictMarkerExtractorDialog.this.fEventBroadcastingTerminationClient.add(new EventBroadcastingTerminationClient.Listener(){

                @Override
                public void cancel() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AbortButton.this.setEnabled(false);
                            AbortButton.this.setDisabledText();
                        }
                    });
                }

                @Override
                public void reset() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AbortButton.this.setEnabled(true);
                            AbortButton.this.setEnabledText();
                        }
                    });
                }
            });
            this.setEnabledText();
        }

        private void setEnabledText() {
            this.setText(FileResources.getString("ui.extractConflictMarkers.abort", new String[0]));
        }

        private void setDisabledText() {
            this.setText(FileResources.getString("ui.extractConflictMarkers.aborting", new String[0]));
        }
    }

    private class CancelButton
    extends MJButton {
        private CancelButton() {
            this.setText(FileResources.getString("ui.extractConflictMarkers.cancel", new String[0]));
            this.setName(ConflictMarkerExtractorDialog.CANCEL_BUTTON_NAME);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ConflictMarkerExtractorDialog.this.closeDialog();
                }
            });
        }
    }

    private class ExtractButton
    extends MJButton {
        private ExtractButton() {
            this.setText(FileResources.getString("ui.extractConflictMarkers.extract", new String[0]));
            this.setName(ConflictMarkerExtractorDialog.EXTRACT_BUTTON_NAME);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ConflictMarkerExtractorDialog.this.extract();
                }
            });
        }
    }

    private class ExtractControls
    implements ComponentBuilder {
        private final JPanel iRoot = new MJPanel();

        private ExtractControls() {
            GroupLayout groupLayout = new GroupLayout(this.iRoot);
            groupLayout.setAutoCreateGaps(true);
            this.iRoot.setLayout(groupLayout);
            ExtractButton extractButton = new ExtractButton();
            CancelButton cancelButton = new CancelButton();
            groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addComponent((Component)((Object)extractButton), -2, -2, -2).addComponent((Component)((Object)cancelButton), -2, -2, -2));
            groupLayout.setVerticalGroup(groupLayout.createParallelGroup().addComponent((Component)((Object)extractButton), -2, -2, -2).addComponent((Component)((Object)cancelButton), -2, -2, -2));
        }

        public JComponent getComponent() {
            return this.iRoot;
        }
    }

    private class ExtractRunningControls
    implements ComponentBuilder {
        private final JPanel iRoot = new MJPanel();

        private ExtractRunningControls() {
            AbortButton abortButton = new AbortButton();
            MJLabel mJLabel = new MJLabel(FileResources.getString("ui.extractConflictMarkers.extracting", new String[0]));
            GroupLayout groupLayout = new GroupLayout(this.iRoot);
            this.iRoot.setLayout(groupLayout);
            groupLayout.setAutoCreateGaps(true);
            groupLayout.setVerticalGroup(groupLayout.createParallelGroup().addComponent((Component)mJLabel, -2, -2, -2).addComponent((Component)((Object)abortButton), -2, -2, -2));
            groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Integer.MAX_VALUE).addComponent((Component)mJLabel).addComponent((Component)((Object)abortButton)));
        }

        public JComponent getComponent() {
            return this.iRoot;
        }
    }

    private class ExtractStrategyControl
    implements ComponentBuilder {
        private final JPanel iRoot = new MJPanel();

        ExtractStrategyControl() {
            JRadioButton jRadioButton = this.createSelectButton("ui.extractConflictMarkers.setToExtractPreservingConflicted", new Runnable(){

                @Override
                public void run() {
                    ConflictMarkerExtractorDialog.this.fExtractionParameters.setToExtractPreservingConflicted();
                }
            });
            jRadioButton.setSelected(true);
            JRadioButton jRadioButton2 = this.createSelectButton("ui.extractConflictMarkers.copyMineOverConflictedStrategySelector", new Runnable(){

                @Override
                public void run() {
                    ConflictMarkerExtractorDialog.this.fExtractionParameters.setToExtractMineOverConflicted();
                }
            });
            JRadioButton jRadioButton3 = this.createSelectButton("ui.extractConflictMarkers.copyTheirsOverConflictedStrategySelector", new Runnable(){

                @Override
                public void run() {
                    ConflictMarkerExtractorDialog.this.fExtractionParameters.setToExtractTheirsOverConflicted();
                }
            });
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(jRadioButton2);
            buttonGroup.add(jRadioButton3);
            buttonGroup.add(jRadioButton);
            jRadioButton2.setSelected(true);
            GroupLayout groupLayout = new GroupLayout(this.iRoot);
            this.iRoot.setLayout(groupLayout);
            groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addComponent(jRadioButton2, -2, -2, -2).addComponent(jRadioButton3, -2, -2, -2).addComponent(jRadioButton, -2, -2, -2));
            groupLayout.setHorizontalGroup(groupLayout.createParallelGroup().addComponent(jRadioButton2).addComponent(jRadioButton3).addComponent(jRadioButton));
        }

        JRadioButton createSelectButton(String string, final Runnable runnable) {
            MJRadioButton mJRadioButton = new MJRadioButton();
            mJRadioButton.setName(string);
            mJRadioButton.setText(FileResources.getString(string, new String[0]));
            mJRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    runnable.run();
                }
            });
            return mJRadioButton;
        }

        public JComponent getComponent() {
            return this.iRoot;
        }
    }

    private class ExtractorInteractor
    implements ComponentBuilder {
        private final ExtractRunningControls fExtractRunningControls;
        private final ExtractControls fExtractControls;
        private JPanel iRoot;

        private ExtractorInteractor() {
            this.fExtractRunningControls = new ExtractRunningControls();
            this.fExtractControls = new ExtractControls();
            this.iRoot = new MJPanel();
            this.iRoot.setLayout(new BorderLayout());
            this.showConfigView();
        }

        public void showExtractingView() {
            this.changeView(this.fExtractRunningControls.getComponent());
        }

        public void showConfigView() {
            this.changeView(this.fExtractControls.getComponent());
        }

        private void changeView(JComponent jComponent) {
            this.iRoot.removeAll();
            this.iRoot.add((Component)jComponent, "Center");
            this.iRoot.revalidate();
            this.iRoot.repaint();
        }

        public JComponent getComponent() {
            return this.iRoot;
        }
    }

    private class DialogExtractor
    extends FileNotifyingConflictMarkerExtractor {
        DialogExtractor() {
            super(ConflictMarkerExtractorDialog.this.fExtractionParameters, ConflictMarkerExtractorDialog.this.fMutableCancellationStatus);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void extract() throws IOException {
            this.preExtractActions();
            try {
                super.extract();
            }
            finally {
                this.postExtractActions();
            }
        }

        private void preExtractActions() {
            ConflictMarkerExtractorDialog.this.fEventBroadcastingTerminationClient.reset();
        }

        private void postExtractActions() {
            ConflictMarkerExtractorDialog.this.fEventBroadcastingTerminationClient.reset();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConflictMarkerExtractorDialog.this.fExtractorInteractor.showConfigView();
                }
            });
        }
    }

    private static class DescriptionLabel
    extends HTMLMessagePane {
        private DescriptionLabel(UserDefinedConflictExtractionParameters userDefinedConflictExtractionParameters, String string) {
            this.setEditable(false);
            this.setOpaque(false);
            if (string == null) {
                string = FileResources.getString("ui.extractConflictMarkers.description", userDefinedConflictExtractionParameters.getConflictedFile().getAbsolutePath());
            }
            this.setText(string);
        }
    }

    private class PostExtractActionWidget
    implements ComponentBuilder {
        private final MJCheckBox iCheckBox = new MJCheckBox();
        private static final String DIFF_CONTROL_NAME = "doDiffControl";

        private PostExtractActionWidget() {
            this.iCheckBox.setName(DIFF_CONTROL_NAME);
            if (ConflictMarkerExtractorDialog.this.fPostExtractAction.isNoOp()) {
                this.iCheckBox.setVisible(false);
            } else {
                this.iCheckBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ConflictMarkerExtractorDialog.this.fPostExtractAction.toggle();
                    }
                });
                this.iCheckBox.setText(ConflictMarkerExtractorDialog.this.fPostExtractAction.getDescription());
                this.iCheckBox.setSelected(true);
            }
        }

        public JComponent getComponent() {
            return this.iCheckBox;
        }
    }
}

