/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hadoop;

import com.mathworks.hadoop.MWArrayWritable;
import com.mathworks.hadoop.MWWritableOutput;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;

public class MapUtil
implements Serializable {
    private boolean debug = false;
    private Object expression = null;
    private Object jcontext = null;
    private Method jeval = null;
    private Method jget = null;
    private Method jset = null;
    private MWWritableOutput adapter = null;
    private MWArrayWritable mwArray = null;

    public MapUtil(Configuration conf, Object expression, Object jcontext, Method jeval, Method jset, Method jget, boolean debug) {
        this.expression = expression;
        this.jcontext = jcontext;
        this.jeval = jeval;
        this.jset = jset;
        this.jget = jget;
        this.debug = debug;
    }

    public void getKeyValues(Object inKey, Object inValue, Mapper.Context context) throws IOException {
        if (this.expression != null) {
            try {
                this.jset.invoke(this.jcontext, "key1", inKey);
                this.jset.invoke(this.jcontext, "var1", inValue);
                this.jeval.invoke(this.expression, this.jcontext);
                Object first = this.jget.invoke(this.jcontext, "r1");
                Object result = this.jget.invoke(this.jcontext, "key1");
                if (result != null) {
                    if (!result.getClass().isArray()) {
                        this.write2Context(result.toString(), first, context);
                    } else {
                        for (String k : (String[])result) {
                            this.write2Context(k, first, context);
                        }
                    }
                }
            }
            catch (Exception e) {
                StackTraceElement[] st = e.getStackTrace();
                String errorMsg = "";
                for (StackTraceElement el : st) {
                    errorMsg = errorMsg + el.toString() + "\n";
                    if (el.getMethodName().equals("setup") && el.getClassName().endsWith("MWBuiltinReduce")) break;
                }
                throw new IOException(errorMsg);
            }
        }
    }

    private void write2Context(String key, Object value, Mapper.Context context) throws IOException, InterruptedException {
        if (value == null) {
            context.write((Object)new Text(key), (Object)NullWritable.get());
        } else {
            if (this.adapter == null && this.mwArray == null) {
                if (!context.getMapOutputValueClass().equals(MWArrayWritable.class)) {
                    this.adapter = new MWWritableOutput(context.getMapOutputValueClass());
                    this.adapter.setWritable(value instanceof Writable);
                } else {
                    this.mwArray = new MWArrayWritable();
                }
            }
            if (this.adapter != null) {
                this.adapter.setInstance(value);
                context.write((Object)new Text(key), (Object)this.adapter.getInstance());
            } else {
                if (!value.getClass().isArray()) {
                    throw new IOException("The values is not an array as expected");
                }
                this.mwArray.set(value);
                context.write((Object)new Text(key), (Object)this.mwArray);
            }
        }
    }
}

